#import <Cocoa/Cocoa.h>
#import "CMNode.h"

@interface CMMessageNode : CMNode {
  id expr;
  NSMutableString *message;
  NSMutableArray *args;
  SEL selector;
}

+ (id)nodeWithExpression:(id)anExpression;
+ (id)nodeWithExpression:(id)anExpression message:(NSString *)aMessage;
+ (id)nodeWithExpression:(id)anExpression
                 message:(NSString *)aMessage
               arguments:(NSArray *)names;
+ (id)nodeWithMessage:(NSString *)aMessage;

- (id)init;
- (id)initWithExpression:(id)anExpression;
- (id)initWithExpression:(id)anExpression
                 message:(NSString *)aMessage;
- (id)initWithExpression:(id)anExpression
                 message:(NSString *)aMessage
               arguments:(NSArray *)names;
- (id)initWithMessage:(NSString *)aMessage;
- (void)dealloc;

- (id)expression;
- (NSString *)message;
- (NSArray *)argumentNodes;
- (SEL)selector;
- (void)setSelector:(SEL)aSelector;

- (void)insertStringToMessage:(NSString *)aString;
- (void)appendStringToMessage:(NSString *)aString;
- (void)addArgument:(id)anObject;
- (BOOL)isSingleMessage;
- (BOOL)isKeywordMessage;
- (BOOL)isDefined;

@end
