#import <Cocoa/Cocoa.h>

@class CMContext, CMToken;

@interface CMLexer : NSObject {
    NSString *string;
    NSMutableArray *tokens;
    CMContext *context;
}

+ (id)lexerWithString:(NSString *)aString context:(CMContext *)aContext;

- (id)init;
- (id)initWithString:(NSString *)aString  context:(CMContext *)aContext;
- (void)dealloc;

- (void)parse;
- (CMToken *)parseQuatedStringWithScanner:(NSScanner *)scanner
                        isSingleQuotation:(BOOL)flag;
- (CMToken *)parseDigitWithScanner:(NSScanner *)scanner;
- (CMToken *)parseRegularExpressionWithScanner:(NSScanner *)scanner
                                      preToken:(CMToken *)preToken;
- (CMToken *)parseSelectorWithScanner:(NSScanner *)scanner
                             preToken:(CMToken *)preToken;
- (void)setPrefixContent:(NSMutableString *)aString forToken:(CMToken *)aToken;
- (NSArray *)tokens;
- (CMContext *)context;

@end
