#import <Cocoa/Cocoa.h>
#import "CMInteger.h"

@class CMSmallInteger, CMFloat;

@interface CMLargeInteger : CMInteger {
  BDIGIT *digits;
  long digitLength;
  BOOL sign;
}

+ (id)integerWithDigitLength:(long)aDigitLength sign:(BOOL)flag;
+ (id)integerWithLongLong:(long long)aValue;
+ (id)integerWithUnsignedLongLong:(unsigned long long)aValue sign:(BOOL)flag;

- (id)initWithUnsignedLongLong:(unsigned long long)aValue sign:(BOOL)flag;
- (id)initWithDigitLength:(long)aDigitLength sign:(BOOL)flag;

- (BDIGIT *)digits;
- (long)digitLength;
- (void)setDigitLength:(long)aValue;
- (BOOL)sign;
- (void)setSign:(BOOL)flag;

- (CMFloat *)float;
- (double)doubleValue;
- (long)longValue;
- (unsigned long)unsignedLongValue;
- (unsigned long)unsignedLongValueWithType:(NSString *)type;

- (NSComparisonResult)compareCMSmallInteger:(CMSmallInteger *)anInteger;
- (NSComparisonResult)compareCMLargeInteger:(CMLargeInteger *)anInteger;
- (NSComparisonResult)compareCMFloat:(CMFloat *)aFloat;

- (id)objectByAddingCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByAddingCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByAddingCMLargeInteger:(CMLargeInteger *)anInteger
                          withSign:(BOOL)flag;
- (id)objectByAddingCMFloat:(CMFloat *)aFloat;

- (id)objectBySubtractingCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectBySubtractingCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectBySubtractingCMFloat:(CMFloat *)aFloat;

- (id)objectByMultiplyingByCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByMultiplyingByCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByMultiplyingByCMFloat:(CMFloat *)aFloat;

- (id)objectByDividingByCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByDividingByCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByDividingByCMFloat:(CMFloat *)aFloat;
- (void)divideByLargeInteger:(CMLargeInteger *)anInteger
                withQuotient:(CMLargeInteger **)divp
                      modulo:(CMLargeInteger **)modp;
- (void)divideByLargeInteger:(CMLargeInteger *)anInteger
                withQuotient:(CMLargeInteger **)divp
                   remainder:(CMLargeInteger **)modp;

- (id)moduloOfDividedByCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)moduloOfDividedByCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)moduloOfDividedByCMFloat:(CMFloat *)aFloat;

- (id)objectByRaisingToPowerCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByRaisingToPowerCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByRaisingToPowerCMFloat:(CMFloat *)aFloat;

- (void)complementWithCarry:(BOOL)carray;

@end
