#import "CMKeyValueCodingNode.h"
#import "common.h"

@implementation CMKeyValueCodingNode

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitKeyValueCodingNode");
  [aVisitor visitKeyValueCodingNode:self];
  LOG(@"<== visitKeyValueCodingNode");
}

- (CMNode *)expression
{
  return [nodes objectAtIndex:0];
}

- (NSString *)keyPath
{
  NSMutableArray *paths = [NSMutableArray arrayWithCapacity:1];
  id path, e = [nodes objectEnumerator];
  [e nextObject];
  while (path = [e nextObject]) {
    [paths addObject:[path keyPath]];
  }
  return [paths componentsJoinedByString:@"."];

}

- (NSString *)description;
{
  return [NSString stringWithFormat:@"(kvc %@.%@)",
                   [[self expression] description], [self keyPath]];
}

@end
