#import "common.h"
#import "CMInvocation.h"
#import "CMBoolean.h"
#import "CMTrue.h"
#import "CMFalse.h"
#import "CMNil.h"
#import "CMObjCTypeConverter.h"
#import "CMRange.h"
#import "CMSelector.h"
#import "CMVariable.h"


@implementation CMInvocation

+ (id)invocationWithMethodSignature:(NSMethodSignature *)aSignature
{
  return [[[self alloc] initWithMethodSignature:aSignature] autorelease];
}

- (id)initWithMethodSignature:(NSMethodSignature *)aSignature
{
  [self init];
  signature = [aSignature retain];
  invocation = [[NSInvocation invocationWithMethodSignature:signature] retain];
  return self;
}

- (void)dealloc
{
  [signature release];
  [invocation release];
  [super dealloc];
}

- (NSMethodSignature *)methodSignature { return signature; }
- (id)target { return [invocation target]; }
- (void)setTarget:(id)aTarget {[invocation setTarget:aTarget];}
- (SEL)selector { return [invocation selector]; }
- (void)setSelector:(SEL)aSelector { [invocation setSelector:aSelector]; }
- (id)returnValue { return returnValue; }

- (void)setArgumentToVariable:(CMVariable *)aVariable atIndex:(int)index
{
  const char *type = [[invocation methodSignature] getArgumentTypeAtIndex:index];
  if (IS_ENCODE_IDP(type))
    [invocation setArgument:[aVariable objectPointer] atIndex:index];
  else
    [self setArgumentToObject:[aVariable object] atIndex:index];
}

- (void)setArgumentToObject:(id)anObject atIndex:(int)index
{
  if (anObject && ![anObject isNil]) {
    const char *type = [[invocation methodSignature] getArgumentTypeAtIndex:index];
    const void *arg = [anObject objCValueWithType:type];
    [invocation setArgument:(void *)arg atIndex:index];
  }
}

- (void)invoke
{
  [invocation invoke];
  returnValue = [CMObjCTypeConverter returnValueWithInvocation:invocation];
}

@end
