#import "common.h"
#import "CMInteger.h"
#import "CMSmallInteger.h"
#import "CMLargeInteger.h"

@implementation CMInteger

+ (id)integerWithString:(NSString *)aString
{
  return [self integerWithCString:[aString cString] base:-1 check:YES];
}

// rb_cstr_to_inum
+ (id)integerWithCString:(const char *)cString base:(int)base check:(BOOL)flag
{
  const char *s = cString;
  char *end;
  char nondigit = 0;
  BOOL sign = YES;
  int c;
  BDIGIT_DBL num;
  long len, blen = 1;
  long i;
  id z = nil;
  BDIGIT *zds;

  // nullȂ0
  if (!cString) {
    if (flag) goto bad;
    return [CMSmallInteger zero];
  }

  // G[`FbN
  if (flag) {
    while (ISSPACE(*cString)) cString++;
  } else {
    while (ISSPACE(*cString) || *cString == '_') cString++;
  }

  // +, -
  if (cString[0] == '+') {
    cString++;
  } else if (cString[0] == '-') {
    cString++;
    sign = NO;
  }

  // +, - ꍇ̃G[
  if (cString[0] == '+' || cString[0] == '-') {
    if (flag) goto bad;
    return [CMSmallInteger zero];
  }

  // i̔f
  if (base <= 0) {
    if (cString[0] == '0') {
	    switch (cString[1]) {
      case 'x': case 'X':
        base = 16;
        break;
      case 'b': case 'B':
        base = 2;
        break;
      case 'o': case 'O':
        base = 8;
        break;
      case 'd': case 'D':
        base = 10;
        break;
      default:
        base = 8;
	    }
    } else if (base < -1) {
	    base = -base;
    } else {
	    base = 10;
    }
  }

  switch (base) {
  case 2:
    len = 1;
    if (cString[0] == '0' && (cString[1] == 'b'||cString[1] == 'B')) {
	    cString += 2;
    }
    break;
  case 3:
    len = 2;
    break;
  case 8:
    if (cString[0] == '0' && (cString[1] == 'o'||cString[1] == 'O')) {
	    cString += 2;
    }
  case 4: case 5: case 6: case 7:
    len = 3;
    break;
  case 10:
    if (cString[0] == '0' && (cString[1] == 'd'||cString[1] == 'D')) {
	    cString += 2;
    }
  case 9: case 11: case 12: case 13: case 14: case 15:
    len = 4;
    break;
  case 16:
    len = 4;
    if (cString[0] == '0' && (cString[1] == 'x'||cString[1] == 'X')) {
	    cString += 2;
    }
    break;

  default:
    if (base < 2 || 36 < base) {
	    //rb_raise(rb_eArgError, "illegal radix %d", base);
      LOG(@"illegal radix %d", base); return nil;
    }
    if (base <= 32) {
	    len = 5;
    }
    else {
	    len = 6;
    }
    break;
  }
  if (*cString == '0') {		/* squeeze preceeding 0s */
    while (*++cString == '0');
    --cString;
  }
  len *= strlen(cString) * sizeof(char);

  if (len <= (sizeof(id)*CHAR_BIT)) {
    unsigned long long val = strtoul((char*)cString, &end, base);

    if (*end == '_') goto bigparse;
    if (flag) {
	    if (end == cString) goto bad; /* no number */
	    while (*end && ISSPACE(*end)) end++;
	    if (*end) goto bad;	      /* trailing garbage */
    }

    if (POSFIXABLE(val)) {
	    if (sign)
        return [CMSmallInteger integerWithLong:val];
	    else {
        long result = -(long)val;
        return [CMSmallInteger integerWithLong:result];
	    }
    } else {
      // tbignum̐
      return [CMLargeInteger integerWithUnsignedLongLong:val sign:sign];
    }
  }

 bigparse:
  len = (len/BITSPERDIG)+1;
  if (flag && *cString == '_') goto bad;

  z = [CMLargeInteger integerWithDigitLength:len sign:sign];
  zds = BDIGITS(z);
  for (i=len;i--;) zds[i]=0;
  while (c = *cString++) {
    if (c == '_') {
	    if (flag) {
        if (nondigit) goto bad;
        nondigit = c;
	    }
	    continue;
    }
    else if (isdigit(c)) {
	    c -= '0';
    }
    else if (islower(c)) {
	    c -= 'a' - 10;
    }
    else if (isupper(c)) {
	    c -= 'A' - 10;
    }
    else {
	    break;
    }
    if (c >= base) break;
    nondigit = 0;
    i = 0;
    num = c;
    for (;;) {
	    while (i<blen) {
        num += (BDIGIT_DBL)zds[i]*base;
        zds[i++] = BIGLO(num);
        num = BIGDN(num);
	    }
	    if (num) {
        blen++;
        continue;
	    }
	    break;
    }
  }
  if (flag) {
    cString--;
    if (s+1 < cString && cString[-1] == '_') goto bad;
    while (*cString && ISSPACE(*cString)) cString++;
    if (*cString) {
	  bad:
	    //rb_invalid_str(s, "Integer");
      // error
      LOG(@"Integer error");
    }
  }

  return [z integer];
}

@end
