#import <Cocoa/Cocoa.h>
#import "CMNumber.h"

@class CMSmallInteger, CMLargeInteger;

@interface CMFloat : CMNumber {
  double value;
}

+ (id)floatWithString:(NSString *)aString;
+ (id)floatWithDouble:(double)aValue;

- (id)initWithDouble:(double)aValue;

- (float)floatValue;
- (double)doubleValue;

- (BOOL)isZero;
- (BOOL)isFinite;
- (BOOL)isInfinite;
- (BOOL)isNaN;

- (NSComparisonResult)compareCMSmallInteger:(CMSmallInteger *)anInteger;
- (NSComparisonResult)compareCMLargeInteger:(CMLargeInteger *)anInteger;
- (NSComparisonResult)compareCMFloat:(CMFloat *)aFloat;

- (id)objectByAddingCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByAddingCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByAddingCMFloat:(CMFloat *)aFloat;

- (id)objectBySubtractingCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectBySubtractingCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectBySubtractingCMFloat:(CMFloat *)aFloat;

- (id)objectByMultiplyingByCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByMultiplyingByCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByMultiplyingByCMFloat:(CMFloat *)aFloat;

- (id)objectByDividingByCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByDividingByCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByDividingByCMFloat:(CMFloat *)aFloat;
- (void)divideByDouble:(double)aValue
          withQuotient:(double *)divp
                modulo:(double *)modp;

- (id)moduloOfDividedByCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)moduloOfDividedByCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)moduloOfDividedByCMFloat:(CMFloat *)aFloat;

- (id)objectByRaisingToPowerCMSmallInteger:(CMSmallInteger *)anInteger;
- (id)objectByRaisingToPowerCMLargeInteger:(CMLargeInteger *)anInteger;
- (id)objectByRaisingToPowerCMFloat:(CMFloat *)aFloat;

@end
