#import "CMException.h"
#import "CMNode.h"
#import "CMMethod.h"

NSString *CMRuntimeException = @"CMRuntimeException";
NSString *CMNameException = @"CMNameException";
NSString *CMTypeException = @"CMTypeException";
NSString *CMLoadException = @"CMLoadException";;
NSString *CMSecurityException = @"CMSecurityException";
NSString *CMZeroDivideException = @"CMZeroDivideException";
NSString *CMSelectorNotRecognizedException = @"CMSelectorNotRecognizedException";

NSString *CMPseudoVariableReason = @"can't assign to %@";

#define UndefinedVariableReason      @"undefined variable '%@'"
#define SelectorNotRecognizedReason  @"selector is not recognized %@"
#define ReturnTypeNotSuppertReason   @"%@ return type %s is not supported"
#define ArgumentTypeNotSuppertReason @"%@ argument type %s at %d is not supported"
#define NoSuchFileToLoadReason       @"no such file to load - %@"

@implementation CMException

+ (void)raiseUndefinedVariableExceptionWithNode:(CMNode *)aNode
                                           name:(NSString *)aName
{
  id info = [aNode userInfoWithMethodNode:[aNode methodNode]];
  NSString *reason = [NSString stringWithFormat:UndefinedVariableReason, aName];
  [[NSException exceptionWithName:CMNameException reason:reason userInfo:info]
    raise];
}

+ (void)raiseSelectorNotRecognizedExceptionWithNode:(CMNode *)aNode
                                             object:(id)anObject
                                           selector:(SEL)aSelector
{
  id info = [aNode userInfoWithMethodNode:[aNode methodNode]];
  NSString *method = [CMMethod descriptionWithObject:anObject selector:aSelector];
  NSString *reason = [NSString stringWithFormat:SelectorNotRecognizedReason,
                               method];
  NSException *ex = [NSException exceptionWithName:CMSelectorNotRecognizedException
                                 reason:reason
                                 userInfo:info];
  [ex raise];
}

+ (void)raiseReturnTypeExceptionWithType:(const char *)type
                                  object:(id)anObject
                                selector:(SEL)aSelector
{
  NSString *method = [CMMethod descriptionWithObject:anObject selector:aSelector];
  [NSException raise:CMRuntimeException
               format:ReturnTypeNotSuppertReason, method, type];
}

+ (void)raiseArgumentTypeExceptionWithType:(const char *)type
                                   atIndex:(unsigned int)index
                                    object:(id)anObject
                                  selector:(SEL)aSelector
{
  NSString *method = [CMMethod descriptionWithObject:anObject selector:aSelector];
  [NSException raise:CMRuntimeException
               format:ArgumentTypeNotSuppertReason, method, type, index];
}

+ (void)raiseNoSuchFileToLoadExceptionWithPath:(NSString *)path
{
  [NSException raise:CMLoadException
               format:NoSuchFileToLoadReason, path];
}

+ (void)raiseZeroDivideException
{
  [NSException raise:CMZeroDivideException
               format:@"divided by 0"];
}

@end
