#import <Cocoa/Cocoa.h>

extern NSString *CMRuntimeException;
extern NSString *CMNameException;
extern NSString *CMTypeException;
extern NSString *CMLoadException;
extern NSString *CMSecurityException;
extern NSString *CMZeroDivideException;
extern NSString *CMSelectorNotRecognizedException;
extern NSString *CMPseudoVariableReason;

@class CMNode;

@interface CMException : NSObject {

}

+ (void)raiseUndefinedVariableExceptionWithNode:(CMNode *)aNode
                                           name:(NSString *)aName;
+ (void)raiseSelectorNotRecognizedExceptionWithNode:(CMNode *)aNode
                                             object:(id)anObject
                                           selector:(SEL)aSelector;
+ (void)raiseReturnTypeExceptionWithType:(const char *)type
                                  object:(id)anObject
                                selector:(SEL)aSelector;
+ (void)raiseArgumentTypeExceptionWithType:(const char *)type
                                   atIndex:(unsigned int)index
                                    object:(id)anObject
                                  selector:(SEL)aSelector;
+ (void)raiseNoSuchFileToLoadExceptionWithPath:(NSString *)path;
+ (void)raiseZeroDivideException;

@end
