#import "common.h"
#import "CMEnvironment.h"
#import <crt_externs.h>

#define environ (*_NSGetEnviron())
#define ALLOC_N(type,n) (type*)malloc(sizeof(type)*(n))
#define REALLOC_N(var,type,n) (var)=(type*)realloc((char*)(var),sizeof(type)*(n))

static char **origenviron;


@implementation CMEnvironment

+ (void)initialize
{
  origenviron = environ;
}

+ (int)indexForName:(NSString *)aName
{
  const char *name  = [aName cString];
  register int i, len = strlen(name);
  char **env;

  env = environ;
  for (i = 0; env[i]; i++) {
    if (memcmp(env[i], name, len) == 0 && env[i][len] == '=')
      // memcmp must come first to avoid
      break;
  } // potential SEGV's

  return i;
}

- (id)objectForKey:(id)aKey
{
  int i;
  char **env;
  NSArray *keyValue;

  env = environ;
  for (i = 0; env[i]; i++) {
    keyValue = [[NSString stringWithCString:env[i]]
                 componentsSeparatedByString:@"="];
    if ([aKey isEqualToString:[keyValue objectAtIndex:0]])
      return [keyValue objectAtIndex:1];
  }
  return nil;
}

- (void)setObject:(id)anObject forKey:(id)aKey
{
  const char *name, *value;
  int i = [[self class] indexForName:aKey];
  name = [aKey cString];
  value = [anObject cString];

  if (environ == origenviron) {  /* need we copy environment? */
    int j;
    int max;
    char **tmpenv;

    for (max = i; environ[max]; max++) ;
    tmpenv = ALLOC_N(char*, max+2);
    for (j=0; j<max; j++)    /* copy environment */
      tmpenv[j] = strdup(environ[j]);
    tmpenv[max] = 0;
    environ = tmpenv;    /* tell exec where it is now */
  }
  if (!value) {
    if (environ != origenviron) {
      char **envp = origenviron;
      while (*envp && *envp != environ[i]) envp++;
      if (!*envp)
        free(environ[i]);
    }
    while (environ[i]) {
      environ[i] = environ[i+1];
      i++;
    }
    return;
  }
  if (!environ[i]) {      /* does not exist yet */
    REALLOC_N(environ, char*, i+2);  /* just expand it a bit */
    environ[i+1] = 0;  /* make sure it's null terminated */
  }
  else {
    if (environ[i] != origenviron[i])
      free(environ[i]);
  }
  environ[i] = ALLOC_N(char, strlen(name) + strlen(value) + 2);
  sprintf(environ[i],"%s=%s",name,value); /* all that work just for this */
}

- (void)removeAllObjects
{
  [self removeObjectsForKeys:[[self dictionary] allKeys]];
}

- (void)removeObjectForKey:(id)aKey
{
  id value;
  if (value = [self objectForKey:aKey])
    [self setObject:nil forKey:aKey];
}

- (void)removeObjectsForKeys:(NSArray *)keyArray
{
  id key, e = [keyArray objectEnumerator];
  while (key = [e nextObject]) {
    [self removeObjectForKey:key];
  }
}

- (void)setDictionary:(NSDictionary *)otherDictionary
{
  id key, e;

  e = [otherDictionary keyEnumerator];
  while (key = [e nextObject]) {
    [self setObject:[otherDictionary objectForKey:key] forKey:key];
  }
}

- (id)valueForKey:(NSString *)key
{
  return [self objectForKey:key];
}

- (void)setValue:(id)value forKey:(NSString *)key
{
  [self setObject:value forKey:key];
}

- (NSString *)description
{
  return [[self dictionary] description];
}

- (NSDictionary *)dictionary
{
  int i;
  char **env;
  NSMutableDictionary *dict;
  NSArray *keyValue;

  env = environ;
  dict = [NSMutableDictionary dictionaryWithCapacity:1];
  for (i = 0; env[i]; i++) {
    keyValue = [[NSString stringWithCString:env[i]]
                 componentsSeparatedByString:@"="];
    [dict setObject:[keyValue objectAtIndex:1] forKey:[keyValue objectAtIndex:0]];
  }
  return dict;
}

- (void)forwardInvocation:(NSInvocation *)anInvocation
{
  SEL sel = [anInvocation selector];
  if ([NSMutableDictionary instancesRespondToSelector:sel])
    [anInvocation invokeWithTarget:[self dictionary]];
  else
    [self doesNotRecognizeSelector:sel];
}

- (NSMethodSignature *)methodSignatureForSelector:(SEL)aSelector
{
  if ([super respondsToSelector:aSelector])
    return [super methodSignatureForSelector:aSelector];
  else
    return [NSMutableDictionary instanceMethodSignatureForSelector:@selector(self)];
}

@end
