//
//  CMEmbeddedObjects.m
//  CocoaMill
//

#import "common.h"
#import "CMEmbeddedObjects.h"
#import "CMRange.h"
#import "CMSize.h"
#import "CMPoint.h"
#import "CMRect.h"

static id embeddedObjectDictionary = nil;

@implementation CMEmbeddedObjects

+ (NSDictionary *)embeddedObjectDictionary
{
  if (!embeddedObjectDictionary) {
    embeddedObjectDictionary = [[NSMutableDictionary alloc] initWithCapacity:1];
    [embeddedObjectDictionary addEntriesFromDictionary:
                                [self foundationConstantDictionary]];
    [embeddedObjectDictionary addEntriesFromDictionary:
                                [self foundationGlobalVariableDictionary]];
    [embeddedObjectDictionary addEntriesFromDictionary:
                                [self applicationConstantDictionary]];
    [embeddedObjectDictionary addEntriesFromDictionary:
                                [self applicationGlobalVariableDictionary]];
  }
  return embeddedObjectDictionary;
}

+ (id)embeddedObjectForName:(NSString *)aName
{
  return [[self embeddedObjectDictionary] objectForKey:aName];
}

+ (NSDictionary *)foundationConstantDictionary
{
  return [NSDictionary dictionaryWithObjectsAndKeys:

    // NSComparisonResult
    PLNG2SINT(NSOrderedAscending),  @"NSOrderedAscending",
    PLNG2SINT(NSOrderedSame),       @"NSOrderedSame",
    PLNG2SINT(NSOrderedDescending), @"NSOrderedDescending",

    // NSHTTPCookieAcceptPolicy
    PLNG2SINT(NSHTTPCookieAcceptPolicyAlways), @"NSHTTPCookieAcceptPolicyAlways",
    PLNG2SINT(NSHTTPCookieAcceptPolicyNever),  @"NSHTTPCookieAcceptPolicyNever",
    PLNG2SINT(NSHTTPCookieAcceptPolicyOnlyFromMainDocumentDomain),
              @"NSHTTPCookieAcceptPolicyOnlyFromMainDocumentDomain",

    // NSInsertionPosition
    PLNG2SINT(NSPositionAfter),     @"NSPositionAfter",
    PLNG2SINT(NSPositionBefore),    @"NSPositionBefore",
    PLNG2SINT(NSPositionBeginning), @"NSPositionBeginning",
    PLNG2SINT(NSPositionEnd),       @"NSPositionEnd",
    PLNG2SINT(NSPositionReplace),   @"NSPositionReplace",

    // NSKeyValueChange
    PLNG2SINT(NSKeyValueChangeSetting),     @"NSKeyValueChangeSetting",
    PLNG2SINT(NSKeyValueChangeInsertion),   @"NSKeyValueChangeInsertion",
    PLNG2SINT(NSKeyValueChangeRemoval),     @"NSKeyValueChangeRemoval",
    PLNG2SINT(NSKeyValueChangeReplacement), @"NSKeyValueChangeReplacement",
    PLNG2SINT(NSKeyValueChangeReplacement), @"NSKeyValueChangeReplacement",

    // NSNetServicesError
    PLNG2SINT(NSNetServicesUnknownError),       @"NSNetServicesUnknownError",
    PLNG2SINT(NSNetServicesCollisionError),     @"NSNetServicesCollisionError",
    PLNG2SINT(NSNetServicesNotFoundError),      @"NSNetServicesNotFoundError",
    PLNG2SINT(NSNetServicesActivityInProgress), @"NSNetServicesActivityInProgress",
    PLNG2SINT(NSNetServicesBadArgumentError),   @"NSNetServicesBadArgumentError",
    PLNG2SINT(NSNetServicesCancelledError),     @"NSNetServicesCancelledError",
    PLNG2SINT(NSNetServicesInvalidError),       @"NSNetServicesInvalidError",

    // NSPropertyListFormat
    PLNG2SINT(NSPropertyListOpenStepFormat), @"NSPropertyList",
    PLNG2SINT(NSPropertyListXMLFormat_v1_0), @"NSPropertyListXMLFormat_v1_0",
    PLNG2SINT(NSPropertyListBinaryFormat_v1_0),
              @"NSPropertyListBinaryFormat_v1_0",

    // NSPropertyListMutabilityOptions
    PLNG2SINT(NSPropertyListImmutable), @"NSPropertyListImmutable",
    PLNG2SINT(NSPropertyListMutableContainers),
                       @"NSPropertyListMutableContainers",
    PLNG2SINT(NSPropertyListMutableContainersAndLeaves),
                       @"NSPropertyListMutableContainersAndLeaves",

    // NSRectEdge
    PLNG2SINT(NSMinXEdge), @"NSMinXEdge",
    PLNG2SINT(NSMinYEdge), @"NSMinYEdge",
    PLNG2SINT(NSMaxXEdge), @"NSMaxXEdge",
    PLNG2SINT(NSMaxYEdge), @"NSMaxYEdge",

    // NSRelativePosition
    PLNG2SINT(NSRelativeAfter),  @"NSRelativeAfter",
    PLNG2SINT(NSRelativeBefore), @"NSRelativeBefore",

    // NSRoundingMode
    PLNG2SINT(NSRoundPlain),   @"NSRoundPlain",
    PLNG2SINT(NSRoundDown),    @"NSRoundDown",
    PLNG2SINT(NSRoundUp),      @"NSRoundUp",
    PLNG2SINT(NSRoundBankers), @"NSRoundBankers",

    // NSSaveOptions
    PLNG2SINT(NSSaveOptionsYes), @"NSSaveOptionsYes",
    PLNG2SINT(NSSaveOptionsNo),  @"NSSaveOptionsNo",
    PLNG2SINT(NSSaveOptionsAsk), @"NSSaveOptionsAsk",

    // NSSearchPathDirectory
    PLNG2SINT(NSApplicationDirectory),          @"NSApplicationDirectory",
    PLNG2SINT(NSDemoApplicationDirectory),      @"NSDemoApplicationDirectory",
    PLNG2SINT(NSDeveloperApplicationDirectory), @"NSDeveloperApplicationDirectory",
    PLNG2SINT(NSAdminApplicationDirectory),     @"NSAdminApplicationDirectory",
    PLNG2SINT(NSLibraryDirectory),              @"NSLibraryDirectory",
    PLNG2SINT(NSDeveloperDirectory),            @"NSDeveloperDirectory",
    PLNG2SINT(NSUserDirectory),                 @"NSUserDirectory",
    PLNG2SINT(NSDocumentationDirectory),        @"NSDocumentationDirectory",
    PLNG2SINT(NSDocumentDirectory),             @"NSDocumentDirectory",
    PLNG2SINT(NSAllApplicationsDirectory),      @"NSAllApplicationsDirectory",
    PLNG2SINT(NSAllLibrariesDirectory),         @"NSAllLibrariesDirectory",

    PLNG2SINT(NSLocalDomainMask), @"NSLocalDomainMask",
    PLNG2SINT(NSNetworkDomainMask), @"NSNetworkDomainMask",
    PLNG2SINT(NSSystemDomainMask), @"NSSystemDomainMask",
    PLNG2SINT(NSAllDomainsMask), @"NSAllDomainsMask",

    // NSStreamEvent
    PLNG2SINT(NSStreamEventNone), @"NSStreamEventNone",
    PLNG2SINT(NSStreamEventOpenCompleted), @"NSStreamEventOpenCompleted",
    PLNG2SINT(NSStreamEventHasBytesAvailable), @"NSStreamEventHasBytesAvailable",
    PLNG2SINT(NSStreamEventHasSpaceAvailable), @"NSStreamEventHasSpaceAvailable",
    PLNG2SINT(NSStreamEventErrorOccurred), @"NSStreamEventErrorOccurred",
    PLNG2SINT(NSStreamEventEndEncountered), @"NSStreamEventEndEncountered",

    // NSStreamStatus
    PLNG2SINT(NSStreamStatusNotOpen), @"NSStreamStatusNotOpen",
    PLNG2SINT(NSStreamStatusOpening), @"NSStreamStatusOpening",
    PLNG2SINT(NSStreamStatusOpen), @"NSStreamStatusOpen",
    PLNG2SINT(NSStreamStatusReading), @"NSStreamStatusReading",
    PLNG2SINT(NSStreamStatusWriting), @"NSStreamStatusWriting",
    PLNG2SINT(NSStreamStatusAtEnd), @"NSStreamStatusAtEnd",
    PLNG2SINT(NSStreamStatusClosed), @"NSStreamStatusClosed",
    PLNG2SINT(NSStreamStatusError), @"NSStreamStatusError",

    // NSTestComparisonOperation
    PLNG2SINT(NSEqualToComparison), @"NSEqualToComparison",
    PLNG2SINT(NSLessThanOrEqualToComparison), @"NSLessThanOrEqualToComparison",
    PLNG2SINT(NSLessThanComparison), @"NSLessThanComparison",
    PLNG2SINT(NSGreaterThanOrEqualToComparison), @"NSGreaterThanOrEqualToComparison",
    PLNG2SINT(NSGreaterThanComparison), @"NSGreaterThanComparison",
    PLNG2SINT(NSBeginsWithComparison), @"NSBeginsWithComparison",
    PLNG2SINT(NSEndsWithComparison), @"NSEndsWithComparison",
    PLNG2SINT(NSContainsComparison), @"NSContainsComparison",

    // NSURLHandleStatus
    PLNG2SINT(NSURLCacheStorageAllowed), @"NSURLCacheStorageAllowed",
    PLNG2SINT(NSURLCacheStorageAllowedInMemoryOnly),
                       @"NSURLCacheStorageAllowedInMemoryOnly",
    PLNG2SINT(NSURLCacheStorageNotAllowed), @"NSURLCacheStorageNotAllowed",

    // NSURLRequestCachePolicy
    PLNG2SINT(NSURLRequestUseProtocolCachePolicy),
                       @"NSURLRequestUseProtocolCachePolicy",
    PLNG2SINT(NSURLRequestReloadIgnoringCacheData),
                       @"NSURLRequestReloadIgnoringCacheData",
    PLNG2SINT(NSURLRequestReturnCacheDataElseLoad),
                       @"NSURLRequestReturnCacheDataElseLoad",
    PLNG2SINT(NSURLRequestReturnCacheDataDontLoad),
                       @"NSURLRequestReturnCacheDataDontLoad",

    // NSWhoseSubelementIdentifier
    PLNG2SINT(NSIndexSubelement),  @"NSIndexSubelement",
    PLNG2SINT(NSEverySubelement),  @"NSEverySubelement",
    PLNG2SINT(NSMiddleSubelement), @"NSMiddleSubelement",
    PLNG2SINT(NSRandomSubelement), @"NSRandomSubelement",
    PLNG2SINT(NSNoSubelement),     @"NSNoSubelement",

    // Key Value Observing Options
    PLNG2SINT(NSKeyValueObservingOptionNew), @"NSKeyValueObservingOptionNew",
    PLNG2SINT(NSKeyValueObservingOptionOld), @"NSKeyValueObservingOptionOld",

    // NSNotFound
    PLNG2SINT(NSNotFound), @"NSNotFound",


    // Search Types
    PLNG2SINT(NSCaseInsensitiveSearch), @"NSCaseInsensitiveSearch",
    PLNG2SINT(NSLiteralSearch), @"NSLiteralSearch",
    PLNG2SINT(NSBackwardsSearch), @"NSBackwardsSearch",
    PLNG2SINT(NSAnchoredSearch), @"NSAnchoredSearch",
    PLNG2SINT(NSNumericSearch), @"NSNumericSearch",

    // String Encodings
    PLNG2SINT(NSASCIIStringEncoding), @"NSASCIIStringEncoding",
    PLNG2SINT(NSNEXTSTEPStringEncoding), @"NSNEXTSTEPStringEncoding",
    PLNG2SINT(NSJapaneseEUCStringEncoding), @"NSJapaneseEUCStringEncoding",
    PLNG2SINT(NSUTF8StringEncoding), @"NSUTF8StringEncoding",
    PLNG2SINT(NSISOLatin1StringEncoding), @"NSISOLatin1StringEncoding",
    PLNG2SINT(NSSymbolStringEncoding), @"NSSymbolStringEncoding",
    PLNG2SINT(NSNonLossyASCIIStringEncoding), @"NSNonLossyASCIIStringEncoding",
    PLNG2SINT(NSShiftJISStringEncoding), @"NSShiftJISStringEncoding",
    PLNG2SINT(NSISOLatin2StringEncoding), @"NSISOLatin2StringEncoding",
    PLNG2SINT(NSUnicodeStringEncoding), @"NSUnicodeStringEncoding",
    PLNG2SINT(NSWindowsCP1251StringEncoding), @"NSWindowsCP1251StringEncoding",
    PLNG2SINT(NSWindowsCP1252StringEncoding), @"NSWindowsCP1252StringEncoding",
    PLNG2SINT(NSWindowsCP1253StringEncoding), @"NSWindowsCP1253StringEncoding",
    PLNG2SINT(NSWindowsCP1254StringEncoding), @"NSWindowsCP1254StringEncoding",
    PLNG2SINT(NSWindowsCP1250StringEncoding), @"NSWindowsCP1250StringEncoding",
    PLNG2SINT(NSISO2022JPStringEncoding), @"NSISO2022JPStringEncoding",
    PLNG2SINT(NSMacOSRomanStringEncoding), @"NSMacOSRomanStringEncoding",
    PLNG2SINT(NSProprietaryStringEncoding), @"NSProprietaryStringEncoding",

    // WebFoundation Error Codes
    PLNG2SINT(NSURLErrorUnknown), @"NSURLErrorUnknown",
    PLNG2SINT(NSURLErrorCancelled), @"NSURLErrorCancelled",
    PLNG2SINT(NSURLErrorBadURL), @"NSURLErrorBadURL",
    PLNG2SINT(NSURLErrorTimedOut), @"NSURLErrorTimedOut",
    PLNG2SINT(NSURLErrorUnsupportedURL), @"NSURLErrorUnsupportedURL",
    PLNG2SINT(NSURLErrorCannotFindHost), @"NSURLErrorCannotFindHost",
    PLNG2SINT(NSURLErrorCannotConnectToHost), @"NSURLErrorCannotConnectToHost",
    PLNG2SINT(NSURLErrorNetworkConnectionLost), @"NSURLErrorNetworkConnectionLost",
    PLNG2SINT(NSURLErrorDNSLookupFailed), @"NSURLErrorDNSLookupFailed",
    PLNG2SINT(NSURLErrorHTTPTooManyRedirects), @"NSURLErrorHTTPTooManyRedirects",
    PLNG2SINT(NSURLErrorResourceUnavailable), @"NSURLErrorResourceUnavailable",
    PLNG2SINT(NSURLErrorNotConnectedToInternet),
                       @"NSURLErrorNotConnectedToInternet",
    PLNG2SINT(NSURLErrorRedirectToNonExistentLocation),
                       @"NSURLErrorRedirectToNonExistentLocation",
    PLNG2SINT(NSURLErrorBadServerResponse), @"NSURLErrorBadServerResponse",
    PLNG2SINT(NSURLErrorUserCancelledAuthentication),
                       @"NSURLErrorUserCancelledAuthentication",
    PLNG2SINT(NSURLErrorUserAuthenticationRequired),
                       @"NSURLErrorUserAuthenticationRequired",
    PLNG2SINT(NSURLErrorZeroByteResource), @"NSURLErrorZeroByteResource",
    PLNG2SINT(NSURLErrorFileDoesNotExist), @"NSURLErrorFileDoesNotExist",
    PLNG2SINT(NSURLErrorFileIsDirectory), @"NSURLErrorFileIsDirectory",
    PLNG2SINT(NSURLErrorNoPermissionsToReadFile),
                       @"NSURLErrorNoPermissionsToReadFile",
    PLNG2SINT(NSURLErrorSecureConnectionFailed),
                       @"NSURLErrorSecureConnectionFailed",
    PLNG2SINT(NSURLErrorServerCertificateHasBadDate),
                       @"NSURLErrorServerCertificateHasBadDate",
    PLNG2SINT(NSURLErrorServerCertificateUntrusted),
                       @"NSURLErrorServerCertificateUntrusted",
    PLNG2SINT(NSURLErrorServerCertificateHasUnknownRoot),
                       @"NSURLErrorServerCertificateHasUnknownRoot",
    PLNG2SINT(NSURLErrorCannotLoadFromNetwork),
                       @"NSURLErrorCannotLoadFromNetwork",

    // Download and file I/O errors
    PLNG2SINT(NSURLErrorCannotCreateFile), @"NSURLErrorCannotCreateFile",
    PLNG2SINT(NSURLErrorCannotOpenFile), @"NSURLErrorCannotOpenFile",
    PLNG2SINT(NSURLErrorCannotCloseFile), @"NSURLErrorCannotCloseFile",
    PLNG2SINT(NSURLErrorCannotWriteToFile), @"NSURLErrorCannotWriteToFile",
    PLNG2SINT(NSURLErrorCannotRemoveFile), @"NSURLErrorCannotRemoveFile",
    PLNG2SINT(NSURLErrorCannotMoveFile), @"NSURLErrorCannotMoveFile",
    PLNG2SINT(NSURLErrorDownloadDecodingFailedMidStream),
                       @"NSURLErrorDownloadDecodingFailedMidStream",
    PLNG2SINT(NSURLErrorDownloadDecodingFailedToComplete),
                       @"NSURLErrorDownloadDecodingFailedToComplete",

    nil];
}


+ (NSDictionary *)foundationGlobalVariableDictionary
{
  return [NSDictionary dictionaryWithObjectsAndKeys:

    // File Attribute Keys
    NSFileType, @"NSFileType",
    NSFileSize, @"NSFileSize",
    NSFileModificationDate, @"NSFileModificationDate",
    NSFileReferenceCount, @"NSFileReferenceCount",
    NSFileDeviceIdentifier, @"NSFileDeviceIdentifier",
    // NSFileOwnerAccountNumber, @"NSFileOwnerAccountNumber",
    // NSFileGroupOwnerAccountNumber, @"NSFileGroupOwnerAccountNumber",
    NSFilePosixPermissions, @"NSFilePosixPermissions",
    NSFileSystemFileNumber, @"NSFileSystemFileNumber",
    NSFileExtensionHidden, @"NSFileExtensionHidden",
    NSFileHFSCreatorCode, @"NSFileHFSCreatorCode",
    NSFileHFSTypeCode, @"NSFileHFSTypeCode",
    NSFileImmutable, @"NSFileImmutable",
    NSFileAppendOnly, @"NSFileAppendOnly",
    NSFileCreationDate, @"NSFileCreationDate",
    NSFileOwnerAccountID, @"NSFileOwnerAccountID",
    NSFileGroupOwnerAccountID, @"NSFileGroupOwnerAccountID",

    // File-System Attribute Keys
    NSFileSystemSize, @"NSFileSystemSize",
    NSFileSystemFreeSize, @"NSFileSystemFreeSize",
    NSFileSystemNodes, @"NSFileSystemNodes",
    NSFileSystemFreeNodes, @"NSFileSystemFreeNodes",
    NSFileSystemNumber, @"NSFileSystemNumber",

    // File Type Attribute Keys
    NSFileTypeDirectory, @"NSFileTypeDirectory",
    NSFileTypeRegular, @"NSFileTypeRegular",
    NSFileTypeSymbolicLink, @"NSFileTypeSymbolicLink",
    NSFileTypeSocket, @"NSFileTypeSocket",
    NSFileTypeCharacterSpecial, @"NSFileTypeCharacterSpecial",
    NSFileTypeBlockSpecial, @"NSFileTypeBlockSpecial",
    NSFileTypeUnknown, @"NSFileTypeUnknown",

    // HTTP Cookie Property Keys
    NSHTTPCookieComment, @"NSHTTPCookieComment",
    NSHTTPCookieCommentURL, @"NSHTTPCookieCommentURL",
    NSHTTPCookieDiscard, @"NSHTTPCookieDiscard",
    NSHTTPCookieDomain, @"NSHTTPCookieDomain",
    NSHTTPCookieExpires, @"NSHTTPCookieExpires",
    NSHTTPCookieMaximumAge, @"NSHTTPCookieMaximumAge",
    NSHTTPCookieName, @"NSHTTPCookieName",
    NSHTTPCookieOriginURL, @"NSHTTPCookieOriginURL",
    NSHTTPCookiePath, @"NSHTTPCookiePath",
    NSHTTPCookiePort, @"NSHTTPCookiePort",
    NSHTTPCookieSecure, @"NSHTTPCookieSecure",
    NSHTTPCookieValue, @"NSHTTPCookieValue",
    NSHTTPCookieVersion, @"NSHTTPCookieVersion",

    // Key Value Change Keys
    NSKeyValueChangeKindKey, @"NSKeyValueChangeKindKey",
    NSKeyValueChangeNewKey, @"NSKeyValueChangeNewKey",
    NSKeyValueChangeOldKey, @"NSKeyValueChangeOldKey",
    NSKeyValueChangeIndexesKey, @"NSKeyValueChangeIndexesKey",

    // Language-Dependent Date/Time Information
    NSWeekDayNameArray, @"NSWeekDayNameArray",
    NSShortWeekDayNameArray, @"NSShortWeekDayNameArray",
    NSMonthNameArray, @"NSMonthNameArray",
    NSShortMonthNameArray, @"NSShortMonthNameArray",
    NSTimeFormatString, @"NSTimeFormatString",
    NSDateFormatString, @"NSDateFormatString",
    NSTimeDateFormatString, @"NSTimeDateFormatString",
    NSShortTimeDateFormatString, @"NSShortTimeDateFormatString",
    NSAMPMDesignation, @"NSAMPMDesignation",
    NSHourNameDesignations, @"NSHourNameDesignations",
    NSYearMonthWeekDesignations, @"NSYearMonthWeekDesignations",
    NSEarlierTimeDesignations, @"NSEarlierTimeDesignations",
    NSLaterTimeDesignations, @"NSLaterTimeDesignations",
    NSThisDayDesignations, @"NSThisDayDesignations",
    NSNextDayDesignations, @"NSNextDayDesignations",
    NSNextNextDayDesignations, @"NSNextNextDayDesignations",
    NSPriorDayDesignations, @"NSPriorDayDesignations",
    NSDateTimeOrdering, @"NSDateTimeOrdering",
    NSShortDateFormatString, @"NSShortDateFormatString",

    // Language-Dependent Numeric Information
    NSCurrencySymbol, @"NSCurrencySymbol",
    NSDecimalSeparator, @"NSDecimalSeparator",
    NSThousandsSeparator, @"NSThousandsSeparator",
    NSInternationalCurrencyString, @"NSInternationalCurrencyString",
    NSPositiveCurrencyFormatString, @"NSPositiveCurrencyFormatString",
    NSNegativeCurrencyFormatString, @"NSNegativeCurrencyFormatString",
    NSDecimalDigits, @"NSDecimalDigits",

    // NSAppleEvent Timeouts
	  PFLT2FLT(NSAppleEventTimeOutDefault), @"NSAppleEventTimeOutDefault",
	  PFLT2FLT(NSAppleEventTimeOutNone), @"NSAppleEventTimeOutNone",

    // NSConnectionReplyMode
    NSConnectionReplyMode, @"NSConnectionReplyMode",

    // NSDefaultRunLoopMode
    NSDefaultRunLoopMode, @"NSDefaultRunLoopMode",

    // NSError userInfo Keys
    NSLocalizedDescriptionKey, @"NSLocalizedDescriptionKey",
    NSUnderlyingErrorKey, @"NSUnderlyingErrorKey",

    // NSError Error Domains
    NSPOSIXErrorDomain, @"NSPOSIXErrorDomain",
    NSOSStatusErrorDomain, @"NSOSStatusErrorDomain",
    NSMachErrorDomain, @"NSMachErrorDomain",
    NSURLErrorDomain, @"NSURLErrorDomain",

    // NSError URL Key
    NSErrorFailingURLStringKey, @"NSErrorFailingURLStringKey",

    // NSJavaSetup Information
    NSJavaClasses, @"NSJavaClasses",
    NSJavaRoot, @"NSJavaRoot",
    NSJavaPath, @"NSJavaPath",
    NSJavaUserPath, @"NSJavaUserPath",
    NSJavaLibraryPath, @"NSJavaLibraryPath",
    NSJavaOwnVirtualMachine, @"NSJavaOwnVirtualMachine",
    NSJavaPathSeparator, @"NSJavaPathSeparator",

    // NSLocalNotificationCenterType
    NSLocalNotificationCenterType, @"NSLocalNotificationCenterType",

    // NSLocalizedDescriptionKey
    NSLocalizedDescriptionKey, @"NSLocalizedDescriptionKey",

    // NSNetServices Errors
    NSNetServicesErrorCode, @"NSNetServicesErrorCode",
    NSNetServicesErrorDomain, @"NSNetServicesErrorDomain",

    // NSStream Error Domains
    NSStreamSocketSSLErrorDomain, @"NSStreamSocketSSLErrorDomain",
    NSStreamSOCKSErrorDomain, @"NSStreamSOCKSErrorDomain",

    // NSStream Property Keys
    NSStreamSocketSecurityLevelKey, @"NSStreamSocketSecurityLevelKey",
    NSStreamSocketSecurityLevelNone, @"NSStreamSocketSecurityLevelNone",
    NSStreamSocketSecurityLevelSSLv2, @"NSStreamSocketSecurityLevelSSLv2",
    NSStreamSocketSecurityLevelSSLv3, @"NSStreamSocketSecurityLevelSSLv3",
    NSStreamSocketSecurityLevelTLSv1, @"NSStreamSocketSecurityLevelTLSv1",
    NSStreamSocketSecurityLevelNegotiatedSSL, @"NSStreamSocketSecurityLevelNegotiatedSSL",
    NSStreamSOCKSProxyConfigurationKey, @"NSStreamSOCKSProxyConfigurationKey",
    NSStreamSOCKSProxyHostKey, @"NSStreamSOCKSProxyHostKey",
    NSStreamSOCKSProxyPortKey, @"NSStreamSOCKSProxyPortKey",
    NSStreamSOCKSProxyVersionKey, @"NSStreamSOCKSProxyVersionKey",
    NSStreamSOCKSProxyUserKey, @"NSStreamSOCKSProxyUserKey",
    NSStreamSOCKSProxyPasswordKey, @"NSStreamSOCKSProxyPasswordKey",
    NSStreamSOCKSProxyVersion4, @"NSStreamSOCKSProxyVersion4",
    NSStreamSOCKSProxyVersion5, @"NSStreamSOCKSProxyVersion5",
    NSStreamDataWrittenToMemoryStreamKey, @"NSStreamDataWrittenToMemoryStreamKey",
    NSStreamFileCurrentOffsetKey, @"NSStreamFileCurrentOffsetKey",

    // NSUnknownKeyException userInfo Keys
    // NSTargetObjectUserInfoKey, @"NSTargetObjectUserInfoKey",
    // NSUnknownUserInfoKey, @"NSUnknownUserInfoKey",

    // NSURL Schemes
    NSURLFileScheme, @"NSURLFileScheme",

    // NSURLHandle FTP Property Keys
    NSFTPPropertyUserLoginKey, @"NSFTPPropertyUserLoginKey",
    NSFTPPropertyUserPasswordKey, @"NSFTPPropertyUserPasswordKey",
    NSFTPPropertyActiveTransferModeKey, @"NSFTPPropertyActiveTransferModeKey",
    NSFTPPropertyFileOffsetKey, @"NSFTPPropertyFileOffsetKey",
    NSFTPPropertyFTPProxy, @"NSFTPPropertyFTPProxy",

    // NSURLHandle HTTP Property Keys
    NSHTTPPropertyStatusCodeKey, @"NSHTTPPropertyStatusCodeKey",
    NSHTTPPropertyStatusReasonKey, @"NSHTTPPropertyStatusReasonKey",
    NSHTTPPropertyServerHTTPVersionKey, @"NSHTTPPropertyServerHTTPVersionKey",
    NSHTTPPropertyRedirectionHeadersKey, @"NSHTTPPropertyRedirectionHeadersKey",
    NSHTTPPropertyErrorPageDataKey, @"NSHTTPPropertyErrorPageDataKey",
    NSHTTPPropertyHTTPProxy, @"NSHTTPPropertyHTTPProxy",

    // NSURLProtectionSpace Authentication Methods
    NSURLAuthenticationMethodDefault, @"NSURLAuthenticationMethodDefault",
    NSURLAuthenticationMethodHTTPBasic, @"NSURLAuthenticationMethodHTTPBasic",
    NSURLAuthenticationMethodHTTPDigest, @"NSURLAuthenticationMethodHTTPDigest",
    NSURLAuthenticationMethodHTMLForm, @"NSURLAuthenticationMethodHTMLForm",

    // NSURLProtectionSpace Proxy Types
    NSURLProtectionSpaceHTTPProxy, @"NSURLProtectionSpaceHTTPProxy",
    NSURLProtectionSpaceHTTPSProxy, @"NSURLProtectionSpaceHTTPSProxy",
    NSURLProtectionSpaceFTPProxy, @"NSURLProtectionSpaceFTPProxy",
    NSURLProtectionSpaceSOCKSProxy, @"NSURLProtectionSpaceSOCKSProxy",

    // NSUserDefaults Domains
    NSGlobalDomain, @"NSGlobalDomain",
    NSArgumentDomain, @"NSArgumentDomain",
    NSRegistrationDomain, @"NSRegistrationDomain",

    // NSValueTransformer Transformer Names
    NSNegateBooleanTransformerName, @"NSNegateBooleanTransformerName",
    NSIsNilTransformerName, @"NSIsNilTransformerName",
    NSIsNotNilTransformerName, @"NSIsNotNilTransformerName",
    NSUnarchiveFromDataTransformerName, @"NSUnarchiveFromDataTransformerName",

    // NSXMLParserErrorDomain
    NSXMLParserErrorDomain, @"NSXMLParserErrorDomain",

    // Zero Constants
    [CMPoint zeroPoint], @"NSZeroPoint",
    [CMSize zeroSize], @"NSZeroSize",
    [CMRect zeroRect], @"NSZeroRect",

    nil];
}

+ (NSDictionary *)applicationConstantDictionary
{
  return [NSDictionary dictionaryWithObjectsAndKeys:

    // NSAlertStyle
    PLNG2SINT(NSWarningAlertStyle), @"NSWarningAlertStyle",
    PLNG2SINT(NSInformationalAlertStyle), @"NSInformationalAlertStyle",
    PLNG2SINT(NSCriticalAlertStyle), @"NSCriticalAlertStyle",

    // NSAnimationEffect
    PLNG2SINT(NSAnimationEffectDisappearingItemDefault),
                       @"NSAnimationEffectDisappearingItemDefault",
    PLNG2SINT(NSAnimationEffectPoof), @"NSAnimationEffectPoof",

    // NSApplicationDelegateReply
    PLNG2SINT(NSApplicationDelegateReplySuccess), @"NSApplicationDelegateReplySuccess",
    PLNG2SINT(NSApplicationDelegateReplyCancel), @"NSApplicationDelegateReplyCancel",
    PLNG2SINT(NSApplicationDelegateReplyFailure), @"NSApplicationDelegateReplyFailure",

    // NSApplicationTerminateReply
    PLNG2SINT(NSTerminateCancel), @"NSTerminateCancel",
    PLNG2SINT(NSTerminateNow), @"NSTerminateNow",
    PLNG2SINT(NSTerminateLater), @"NSTerminateLater",

    // NSBackingStoreType
    PLNG2SINT(NSBackingStoreRetained), @"NSBackingStoreRetained",
    PLNG2SINT(NSBackingStoreNonretained), @"NSBackingStoreNonretained",
    PLNG2SINT(NSBackingStoreBuffered), @"NSBackingStoreBuffered",

    // NSBezelStyle
    PLNG2SINT(NSRoundedBezelStyle), @"NSRoundedBezelStyle",
    PLNG2SINT(NSRegularSquareBezelStyle), @"NSRegularSquareBezelStyle",
    PLNG2SINT(NSThickSquareBezelStyle), @"NSThickSquareBezelStyle",
    PLNG2SINT(NSThickerSquareBezelStyle), @"NSThickerSquareBezelStyle",
    PLNG2SINT(NSDisclosureBezelStyle), @"NSDisclosureBezelStyle",
    PLNG2SINT(NSShadowlessSquareBezelStyle), @"NSShadowlessSquareBezelStyle",
    PLNG2SINT(NSCircularBezelStyle), @"NSCircularBezelStyle",
    PLNG2SINT(NSTexturedSquareBezelStyle), @"NSTexturedSquareBezelStyle",
    PLNG2SINT(NSHelpButtonBezelStyle), @"NSHelpButtonBezelStyle",

    // NSBezierPathElement
    PLNG2SINT(NSMoveToBezierPathElement), @"NSMoveToBezierPathElement,",
    PLNG2SINT(NSLineToBezierPathElement), @"NSLineToBezierPathElement,",
    PLNG2SINT(NSCurveToBezierPathElement), @"NSCurveToBezierPathElement,",
    PLNG2SINT(NSClosePathBezierPathElement), @"NSClosePathBezierPathElement",

    // NSBitmapImageFileType
    PLNG2SINT(NSTIFFFileType), @"NSTIFFFileType,",
    PLNG2SINT(NSBMPFileType), @"NSBMPFileType,",
    PLNG2SINT(NSGIFFileType), @"NSGIFFileType,",
    PLNG2SINT(NSJPEGFileType), @"NSJPEGFileType,",
    PLNG2SINT(NSPNGFileType), @"NSPNGFileType",

    // NSBorderType
    PLNG2SINT(NSNoBorder), @"NSNoBorder",
    PLNG2SINT(NSLineBorder), @"NSLineBorder",
    PLNG2SINT(NSBezelBorder), @"NSBezelBorder",
    PLNG2SINT(NSGrooveBorder), @"NSGrooveBorder",

    // NSBoxType
    PLNG2SINT(NSBoxPrimary), @"NSBoxPrimary",
    PLNG2SINT(NSBoxSecondary), @"NSBoxSecondary",
    PLNG2SINT(NSBoxSeparator), @"NSBoxSeparator",
    PLNG2SINT(NSBoxOldStyle), @"NSBoxOldStyle",

    // NSBrowserColumnResizingType
    PLNG2SINT(NSBrowserNoColumnResizing), @"NSBrowserNoColumnResizing",
    PLNG2SINT(NSBrowserAutoColumnResizing), @"NSBrowserAutoColumnResizing",
    PLNG2SINT(NSBrowserUserColumnResizing), @"NSBrowserUserColumnResizing",

    // NSButtonType
    PLNG2SINT(NSMomentaryLightButton), @"NSMomentaryLightButton",
    PLNG2SINT(NSPushOnPushOffButton), @"NSPushOnPushOffButton",
    PLNG2SINT(NSToggleButton), @"NSToggleButton",
    PLNG2SINT(NSSwitchButton), @"NSSwitchButton",
    PLNG2SINT(NSRadioButton), @"NSRadioButton",
    PLNG2SINT(NSMomentaryChangeButton), @"NSMomentaryChangeButton",
    PLNG2SINT(NSOnOffButton), @"NSOnOffButton",
    PLNG2SINT(NSMomentaryPushInButton), @"NSMomentaryPushInButton",

    // NSCellAttribute
    PLNG2SINT(NSCellDisabled), @"NSCellDisabled",
    PLNG2SINT(NSCellState), @"NSCellState",
    PLNG2SINT(NSPushInCell), @"NSPushInCell",
    PLNG2SINT(NSCellEditable), @"NSCellEditable",
    PLNG2SINT(NSChangeGrayCell), @"NSChangeGrayCell",
    PLNG2SINT(NSCellHighlighted), @"NSCellHighlighted",
    PLNG2SINT(NSCellLightsByContents), @"NSCellLightsByContents",
    PLNG2SINT(NSCellLightsByGray), @"NSCellLightsByGray",
    PLNG2SINT(NSChangeBackgroundCell), @"NSChangeBackgroundCell",
    PLNG2SINT(NSCellLightsByBackground), @"NSCellLightsByBackground",
    PLNG2SINT(NSCellIsBordered), @"NSCellIsBordered",
    PLNG2SINT(NSCellHasOverlappingImage), @"NSCellHasOverlappingImage",
    PLNG2SINT(NSCellHasImageHorizontal), @"NSCellHasImageHorizontal",
    PLNG2SINT(NSCellHasImageOnLeftOrBottom), @"NSCellHasImageOnLeftOrBottom",
    PLNG2SINT(NSCellChangesContents), @"NSCellChangesContents",
    PLNG2SINT(NSCellIsInsetButton), @"NSCellIsInsetButton",
    PLNG2SINT(NSCellAllowsMixedState), @"NSCellAllowsMixedState",

    // NSCellImagePosition
    PLNG2SINT(NSNoImage), @"NSNoImage",
    PLNG2SINT(NSImageOnly), @"NSImageOnly",
    PLNG2SINT(NSImageLeft), @"NSImageLeft",
    PLNG2SINT(NSImageRight), @"NSImageRight",
    PLNG2SINT(NSImageBelow), @"NSImageBelow",
    PLNG2SINT(NSImageAbove), @"NSImageAbove",
    PLNG2SINT(NSImageOverlaps), @"NSImageOverlaps",

    // NSCellState
    PLNG2SINT(NSMixedState), @"NSMixedState",
    PLNG2SINT(NSOffState), @"NSOffState",
    PLNG2SINT(NSOnState), @"NSOnState",

    // NSCellType
    PLNG2SINT(NSNullCellType), @"NSNullCellType",
    PLNG2SINT(NSTextCellType), @"NSTextCellType",
    PLNG2SINT(NSImageCellType), @"NSImageCellType",

    // NSCharacterCollection
    PLNG2SINT(NSIdentityMappingCharacterCollection), @"NSIdentityMappingCharacterCollection",
    PLNG2SINT(NSAdobeCNS1CharacterCollection), @"NSAdobeCNS1CharacterCollection",
    PLNG2SINT(NSAdobeGB1CharacterCollection), @"NSAdobeGB1CharacterCollection",
    PLNG2SINT(NSAdobeJapan1CharacterCollection), @"NSAdobeJapan1CharacterCollection",
    PLNG2SINT(NSAdobeJapan2CharacterCollection), @"NSAdobeJapan2CharacterCollection",
    PLNG2SINT(NSAdobeKorea1CharacterCollection), @"NSAdobeKorea1CharacterCollection",

    // NSCompositingOperation
    PLNG2SINT(NSCompositeClear), @"NSCompositeClear",
    PLNG2SINT(NSCompositeCopy), @"NSCompositeCopy",
    PLNG2SINT(NSCompositeSourceOver), @"NSCompositeSourceOver",
    PLNG2SINT(NSCompositeSourceIn), @"NSCompositeSourceIn",
    PLNG2SINT(NSCompositeSourceOut), @"NSCompositeSourceOut",
    PLNG2SINT(NSCompositeSourceAtop), @"NSCompositeSourceAtop",
    PLNG2SINT(NSCompositeDestinationOver), @"NSCompositeDestinationOver",
    PLNG2SINT(NSCompositeDestinationIn), @"NSCompositeDestinationIn",
    PLNG2SINT(NSCompositeDestinationOut), @"NSCompositeDestinationOut",
    PLNG2SINT(NSCompositeDestinationAtop), @"NSCompositeDestinationAtop",
    PLNG2SINT(NSCompositeXOR), @"NSCompositeXOR",
    PLNG2SINT(NSCompositePlusDarker), @"NSCompositePlusDarker",
    PLNG2SINT(NSCompositeHighlight), @"NSCompositeHighlight",
    PLNG2SINT(NSCompositePlusLighter), @"NSCompositePlusLighter",

    // NSControlSize
    PLNG2SINT(NSRegularControlSize), @"NSRegularControlSize,",
    PLNG2SINT(NSSmallControlSize), @"NSSmallControlSize,",
    PLNG2SINT(NSMiniControlSize), @"NSMiniControlSize",

    // NSControlTint
    PLNG2SINT(NSDefaultControlTint), @"NSDefaultControlTint",
    PLNG2SINT(NSBlueControlTint), @"NSBlueControlTint",
    PLNG2SINT(NSGraphiteControlTint), @"NSGraphiteControlTint",
    PLNG2SINT(NSClearControlTint), @"NSClearControlTint",

    // NSDocumentChangeType
    PLNG2SINT(NSChangeDone), @"NSChangeDone",
    PLNG2SINT(NSChangeUndone), @"NSChangeUndone",
    PLNG2SINT(NSChangeCleared), @"NSChangeCleared",

    // NSDrawerState
    PLNG2SINT(NSDrawerClosedState), @"NSDrawerClosedState",
    PLNG2SINT(NSDrawerOpeningState), @"NSDrawerOpeningState",
    PLNG2SINT(NSDrawerOpenState), @"NSDrawerOpenState",
    PLNG2SINT(NSDrawerClosingState), @"NSDrawerClosingState",

    // NSEventType
    PLNG2SINT(NSLeftMouseDown), @"NSLeftMouseDown",
    PLNG2SINT(NSLeftMouseUp), @"NSLeftMouseUp",
    PLNG2SINT(NSRightMouseDown), @"NSRightMouseDown",
    PLNG2SINT(NSRightMouseUp), @"NSRightMouseUp",
    PLNG2SINT(NSMouseMoved), @"NSMouseMoved",
    PLNG2SINT(NSLeftMouseDragged), @"NSLeftMouseDragged",
    PLNG2SINT(NSRightMouseDragged), @"NSRightMouseDragged",
    PLNG2SINT(NSMouseEntered), @"NSMouseEntered",
    PLNG2SINT(NSMouseExited), @"NSMouseExited",
    PLNG2SINT(NSKeyDown), @"NSKeyDown",
    PLNG2SINT(NSKeyUp), @"NSKeyUp",
    PLNG2SINT(NSFlagsChanged), @"NSFlagsChanged",
    PLNG2SINT(NSAppKitDefined), @"NSAppKitDefined",
    PLNG2SINT(NSSystemDefined), @"NSSystemDefined",
    PLNG2SINT(NSApplicationDefined), @"NSApplicationDefined",
    PLNG2SINT(NSPeriodic), @"NSPeriodic",
    PLNG2SINT(NSCursorUpdate), @"NSCursorUpdate",
    PLNG2SINT(NSScrollWheel), @"NSScrollWheel",
    PLNG2SINT(NSOtherMouseDown), @"NSOtherMouseDown",
    PLNG2SINT(NSOtherMouseUp), @"NSOtherMouseUp",
    PLNG2SINT(NSOtherMouseDragged), @"NSOtherMouseDragged",

    // NSFindPanelAction
    PLNG2SINT(NSFindPanelActionShowFindPanel), @"NSFindPanelActionShowFindPanel",
    PLNG2SINT(NSFindPanelActionNext), @"NSFindPanelActionNext",
    PLNG2SINT(NSFindPanelActionPrevious), @"NSFindPanelActionPrevious",
    PLNG2SINT(NSFindPanelActionReplaceAll), @"NSFindPanelActionReplaceAll",
    PLNG2SINT(NSFindPanelActionReplace), @"NSFindPanelActionReplace",
    PLNG2SINT(NSFindPanelActionReplaceAndFind), @"NSFindPanelActionReplaceAndFind",
    PLNG2SINT(NSFindPanelActionSetFindString), @"NSFindPanelActionSetFindString",
    PLNG2SINT(NSFindPanelActionReplaceAllInSelection), @"NSFindPanelActionReplaceAllInSelection",

    // NSFocusRingPlacement
    PLNG2SINT(NSFocusRingOnly), @"NSFocusRingOnly",
    PLNG2SINT(NSFocusRingBelow), @"NSFocusRingBelow",
    PLNG2SINT(NSFocusRingAbove), @"NSFocusRingAbove",

    // NSFocusRingType
    PLNG2SINT(NSFocusRingTypeDefault), @"NSFocusRingTypeDefault",
    PLNG2SINT(NSFocusRingTypeNone), @"NSFocusRingTypeNone",
    PLNG2SINT(NSFocusRingTypeExterior), @"NSFocusRingTypeExterior",

    // NSFontAction
    PLNG2SINT(NSNoFontChangeAction), @"NSNoFontChangeAction",
    PLNG2SINT(NSViaPanelFontAction), @"NSViaPanelFontAction",
    PLNG2SINT(NSAddTraitFontAction), @"NSAddTraitFontAction",
    PLNG2SINT(NSSizeUpFontAction), @"NSSizeUpFontAction",
    PLNG2SINT(NSSizeDownFontAction), @"NSSizeDownFontAction",
    PLNG2SINT(NSHeavierFontAction), @"NSHeavierFontAction",
    PLNG2SINT(NSLighterFontAction), @"NSLighterFontAction",
    PLNG2SINT(NSRemoveTraitFontAction), @"NSRemoveTraitFontAction",

    // NSGlyphInscription
    PLNG2SINT(NSGlyphInscribeBase), @"NSGlyphInscribeBase",
    PLNG2SINT(NSGlyphInscribeBelow), @"NSGlyphInscribeBelow",
    PLNG2SINT(NSGlyphInscribeAbove), @"NSGlyphInscribeAbove",
    PLNG2SINT(NSGlyphInscribeOverstrike), @"NSGlyphInscribeOverstrike",
    PLNG2SINT(NSGlyphInscribeOverBelow), @"NSGlyphInscribeOverBelow",

    // NSGlyphLayoutMode
    PLNG2SINT(NSGlyphLayoutAtAPoint), @"NSGlyphLayoutAtAPoint",
    PLNG2SINT(NSGlyphLayoutAgainstAPoint), @"NSGlyphLayoutAgainstAPoint,",
    PLNG2SINT(NSGlyphLayoutWithPrevious), @"NSGlyphLayoutWithPrevious",

    // NSGlyphRelation
    PLNG2SINT(NSGlyphBelow), @"NSGlyphBelow",
    PLNG2SINT(NSGlyphAbove), @"NSGlyphAbove",

    // NSGradientType
    PLNG2SINT(NSGradientNone), @"NSGradientNone",
    PLNG2SINT(NSGradientConcaveWeak), @"NSGradientConcaveWeak",
    PLNG2SINT(NSGradientConcaveStrong), @"NSGradientConcaveStrong",
    PLNG2SINT(NSGradientConvexWeak), @"NSGradientConvexWeak",
    PLNG2SINT(NSGradientConvexStrong), @"NSGradientConvexStrong",

    // NSImageAlignment
    PLNG2SINT(NSImageAlignCenter), @"NSImageAlignCenter",
    PLNG2SINT(NSImageAlignTop), @"NSImageAlignTop,",
    PLNG2SINT(NSImageAlignTopLeft), @"NSImageAlignTopLeft,",
    PLNG2SINT(NSImageAlignTopRight), @"NSImageAlignTopRight,",
    PLNG2SINT(NSImageAlignLeft), @"NSImageAlignLeft,",
    PLNG2SINT(NSImageAlignBottom), @"NSImageAlignBottom,",
    PLNG2SINT(NSImageAlignBottomLeft), @"NSImageAlignBottomLeft,",
    PLNG2SINT(NSImageAlignBottomRight), @"NSImageAlignBottomRight,",
    PLNG2SINT(NSImageAlignRight), @"NSImageAlignRight",

    // NSImageCacheMode
    PLNG2SINT(NSImageCacheDefault), @"NSImageCacheDefault,",
    PLNG2SINT(NSImageCacheAlways), @"NSImageCacheAlways,",
    PLNG2SINT(NSImageCacheBySize), @"NSImageCacheBySize,",
    PLNG2SINT(NSImageCacheNever), @"NSImageCacheNever",

    // NSImageFrameStyle
    PLNG2SINT(NSImageFrameNone), @"NSImageFrameNone",
    PLNG2SINT(NSImageFramePhoto), @"NSImageFramePhoto,",
    PLNG2SINT(NSImageFrameGrayBezel), @"NSImageFrameGrayBezel,",
    PLNG2SINT(NSImageFrameGroove), @"NSImageFrameGroove,",
    PLNG2SINT(NSImageFrameButton), @"NSImageFrameButton",

    // NSImageInterpolation
    PLNG2SINT(NSImageInterpolationDefault), @"NSImageInterpolationDefault,",
    PLNG2SINT(NSImageInterpolationNone), @"NSImageInterpolationNone,",
    PLNG2SINT(NSImageInterpolationLow), @"NSImageInterpolationLow,",
    PLNG2SINT(NSImageInterpolationHigh), @"NSImageInterpolationHigh",

    // NSImageLoadStatus
    PLNG2SINT(NSImageLoadStatusCompleted), @"NSImageLoadStatusCompleted,",
    PLNG2SINT(NSImageLoadStatusCancelled), @"NSImageLoadStatusCancelled,",
    PLNG2SINT(NSImageLoadStatusInvalidData), @"NSImageLoadStatusInvalidData,",
    PLNG2SINT(NSImageLoadStatusUnexpectedEOF), @"NSImageLoadStatusUnexpectedEOF,",
    PLNG2SINT(NSImageLoadStatusReadError), @"NSImageLoadStatusReadError",

    // NSImageRepLoadStatus
    PLNG2SINT(NSImageRepLoadStatusUnknownType), @"NSImageRepLoadStatusUnknownType",
    PLNG2SINT(NSImageRepLoadStatusReadingHeader), @"NSImageRepLoadStatusReadingHeader",
    PLNG2SINT(NSImageRepLoadStatusWillNeedAllData), @"NSImageRepLoadStatusWillNeedAllData",
    PLNG2SINT(NSImageRepLoadStatusInvalidData), @"NSImageRepLoadStatusInvalidData",
    PLNG2SINT(NSImageRepLoadStatusUnexpectedEOF), @"NSImageRepLoadStatusUnexpectedEOF",
    PLNG2SINT(NSImageRepLoadStatusCompleted), @"NSImageRepLoadStatusCompleted",

    // NSImageScaling
    PLNG2SINT(NSScaleProportionally), @"NSScaleProportionally",
    PLNG2SINT(NSScaleToFit), @"NSScaleToFit,",
    PLNG2SINT(NSScaleNone), @"NSScaleNone",

    // NSInterfaceStyle
    PLNG2SINT(NSNoInterfaceStyle), @"NSNoInterfaceStyle",
    PLNG2SINT(NSNextStepInterfaceStyle), @"NSNextStepInterfaceStyle",
    PLNG2SINT(NSWindows95InterfaceStyle), @"NSWindows95InterfaceStyle",
    PLNG2SINT(NSMacintoshInterfaceStyle), @"NSMacintoshInterfaceStyle",

    // NSLayoutDirection
    PLNG2SINT(NSLayoutLeftToRight), @"NSLayoutLeftToRight",
    PLNG2SINT(NSLayoutRightToLeft), @"NSLayoutRightToLeft",

    // NSLayoutStatus
    PLNG2SINT(NSLayoutNotDone), @"NSLayoutNotDone",
    PLNG2SINT(NSLayoutDone), @"NSLayoutDone,",
    PLNG2SINT(NSLayoutCantFit), @"NSLayoutCantFit,",
    PLNG2SINT(NSLayoutOutOfGlyphs), @"NSLayoutOutOfGlyphs",

    // NSLineBreakMode
    PLNG2SINT(NSLineBreakByWordWrapping), @"NSLineBreakByWordWrapping",
    PLNG2SINT(NSLineBreakByCharWrapping), @"NSLineBreakByCharWrapping,",
    PLNG2SINT(NSLineBreakByClipping), @"NSLineBreakByClipping,",
    PLNG2SINT(NSLineBreakByTruncatingHead), @"NSLineBreakByTruncatingHead,",
    PLNG2SINT(NSLineBreakByTruncatingTail), @"NSLineBreakByTruncatingTail,",
    PLNG2SINT(NSLineBreakByTruncatingMiddle), @"NSLineBreakByTruncatingMiddle",

    // NSLineCapStyle
    PLNG2SINT(NSButtLineCapStyle), @"NSButtLineCapStyle",
    PLNG2SINT(NSRoundLineCapStyle), @"NSRoundLineCapStyle",
    PLNG2SINT(NSSquareLineCapStyle), @"NSSquareLineCapStyle",

    // NSLineJoinStyle
    PLNG2SINT(NSMiterLineJoinStyle), @"NSMiterLineJoinStyle",
    PLNG2SINT(NSRoundLineJoinStyle), @"NSRoundLineJoinStyle",
    PLNG2SINT(NSBevelLineJoinStyle), @"NSBevelLineJoinStyle",

    // NSLineMovementDirection
    PLNG2SINT(NSLineDoesntMove), @"NSLineDoesntMove",
    PLNG2SINT(NSLineMovesLeft), @"NSLineMovesLeft",
    PLNG2SINT(NSLineMovesRight), @"NSLineMovesRight",
    PLNG2SINT(NSLineMovesDown), @"NSLineMovesDown",
    PLNG2SINT(NSLineMovesUp), @"NSLineMovesUp",

    // NSLineSweepDirection
    PLNG2SINT(NSLineSweepLeft), @"NSLineSweepLeft",
    PLNG2SINT(NSLineSweepRight), @"NSLineSweepRight",
    PLNG2SINT(NSLineSweepDown), @"NSLineSweepDown",
    PLNG2SINT(NSLineSweepUp), @"NSLineSweepUp",

    // NSMatrixMode
    PLNG2SINT(NSRadioModeMatrix), @"NSRadioModeMatrix",
    PLNG2SINT(NSHighlightModeMatrix), @"NSHighlightModeMatrix",
    PLNG2SINT(NSListModeMatrix), @"NSListModeMatrix",
    PLNG2SINT(NSTrackModeMatrix), @"NSTrackModeMatrix",

    // NSMultibyteGlyphPacking
    PLNG2SINT(NSOneByteGlyphPacking), @"NSOneByteGlyphPacking,",
    PLNG2SINT(NSJapaneseEUCGlyphPacking), @"NSJapaneseEUCGlyphPacking,",
    PLNG2SINT(NSAsciiWithDoubleByteEUCGlyphPacking), @"NSAsciiWithDoubleByteEUCGlyphPacking,",
    PLNG2SINT(NSTwoByteGlyphPacking), @"NSTwoByteGlyphPacking,",
    PLNG2SINT(NSFourByteGlyphPacking), @"NSFourByteGlyphPacking,",
    PLNG2SINT(NSNativeShortGlyphPacking), @"NSNativeShortGlyphPacking",

    // NSOpenGLContextParameter
    PLNG2SINT(NSOpenGLCPSwapRectangle), @"NSOpenGLCPSwapRectangle",
    PLNG2SINT(NSOpenGLCPSwapRectangleEnable), @"NSOpenGLCPSwapRectangleEnable",
    PLNG2SINT(NSOpenGLCPRasterizationEnable), @"NSOpenGLCPRasterizationEnable",
    PLNG2SINT(NSOpenGLCPSwapInterval), @"NSOpenGLCPSwapInterval",
    PLNG2SINT(NSOpenGLCPSurfaceOrder), @"NSOpenGLCPSurfaceOrder",
    PLNG2SINT(NSOpenGLCPSurfaceOpacity), @"NSOpenGLCPSurfaceOpacity",
    PLNG2SINT(NSOpenGLCPStateValidation), @"NSOpenGLCPStateValidation",

    // NSOpenGLGlobalOption
    PLNG2SINT(NSOpenGLGOFormatCacheSize), @"NSOpenGLGOFormatCacheSize",
    PLNG2SINT(NSOpenGLGOClearFormatCache), @"NSOpenGLGOClearFormatCache",
    PLNG2SINT(NSOpenGLGORetainRenderers), @"NSOpenGLGORetainRenderers",
    PLNG2SINT(NSOpenGLGOResetLibrary), @"NSOpenGLGOResetLibrary",

    // NSOpenGLPixelFormatAttribute
    PLNG2SINT(NSOpenGLPFAAllRenderers), @"NSOpenGLPFAAllRenderers",
    PLNG2SINT(NSOpenGLPFADoubleBuffer), @"NSOpenGLPFADoubleBuffer",
    PLNG2SINT(NSOpenGLPFAStereo), @"NSOpenGLPFAStereo",
    PLNG2SINT(NSOpenGLPFAAuxBuffers), @"NSOpenGLPFAAuxBuffers",
    PLNG2SINT(NSOpenGLPFAColorSize), @"NSOpenGLPFAColorSize",
    PLNG2SINT(NSOpenGLPFAAlphaSize), @"NSOpenGLPFAAlphaSize",
    PLNG2SINT(NSOpenGLPFADepthSize), @"NSOpenGLPFADepthSize",
    PLNG2SINT(NSOpenGLPFAStencilSize), @"NSOpenGLPFAStencilSize",
    PLNG2SINT(NSOpenGLPFAAccumSize), @"NSOpenGLPFAAccumSize",
    PLNG2SINT(NSOpenGLPFAMinimumPolicy), @"NSOpenGLPFAMinimumPolicy",
    PLNG2SINT(NSOpenGLPFAMaximumPolicy), @"NSOpenGLPFAMaximumPolicy",
    PLNG2SINT(NSOpenGLPFAOffScreen), @"NSOpenGLPFAOffScreen",
    PLNG2SINT(NSOpenGLPFAFullScreen), @"NSOpenGLPFAFullScreen",
    PLNG2SINT(NSOpenGLPFASampleBuffers), @"NSOpenGLPFASampleBuffers",
    PLNG2SINT(NSOpenGLPFASamples), @"NSOpenGLPFASamples",
    PLNG2SINT(NSOpenGLPFAAuxDepthStencil), @"NSOpenGLPFAAuxDepthStencil",
    PLNG2SINT(NSOpenGLPFARendererID), @"NSOpenGLPFARendererID",
    PLNG2SINT(NSOpenGLPFASingleRenderer), @"NSOpenGLPFASingleRenderer",
    PLNG2SINT(NSOpenGLPFANoRecovery), @"NSOpenGLPFANoRecovery",
    PLNG2SINT(NSOpenGLPFAAccelerated), @"NSOpenGLPFAAccelerated",
    PLNG2SINT(NSOpenGLPFAClosestPolicy), @"NSOpenGLPFAClosestPolicy",
    PLNG2SINT(NSOpenGLPFARobust), @"NSOpenGLPFARobust",
    PLNG2SINT(NSOpenGLPFABackingStore), @"NSOpenGLPFABackingStore",
    PLNG2SINT(NSOpenGLPFAMPSafe), @"NSOpenGLPFAMPSafe",
    PLNG2SINT(NSOpenGLPFAWindow), @"NSOpenGLPFAWindow",
    PLNG2SINT(NSOpenGLPFAMultiScreen), @"NSOpenGLPFAMultiScreen",
    PLNG2SINT(NSOpenGLPFACompliant), @"NSOpenGLPFACompliant",
    PLNG2SINT(NSOpenGLPFAScreenMask), @"NSOpenGLPFAScreenMask",
    PLNG2SINT(NSOpenGLPFAPixelBuffer), @"NSOpenGLPFAPixelBuffer",
    PLNG2SINT(NSOpenGLPFAVirtualScreenCount), @"NSOpenGLPFAVirtualScreenCount",

    // NSPopUpArrowPosition
    PLNG2SINT(NSPopUpNoArrow), @"NSPopUpNoArrow",
    PLNG2SINT(NSPopUpArrowAtCenter), @"NSPopUpArrowAtCenter",
    PLNG2SINT(NSPopUpArrowAtBottom), @"NSPopUpArrowAtBottom",

    // NSPrinterTableStatus
    PLNG2SINT(NSPrinterTableOK), @"NSPrinterTableOK",
    PLNG2SINT(NSPrinterTableNotFound), @"NSPrinterTableNotFound",
    PLNG2SINT(NSPrinterTableError), @"NSPrinterTableError",

    // NSPrintingOrientation
    PLNG2SINT(NSPortraitOrientation), @"NSPortraitOrientation",
    PLNG2SINT(NSLandscapeOrientation), @"NSLandscapeOrientation",

    // NSPrintingPageOrder
    PLNG2SINT(NSDescendingPageOrder), @"NSDescendingPageOrder",
    PLNG2SINT(NSSpecialPageOrder), @"NSSpecialPageOrder",
    PLNG2SINT(NSAscendingPageOrder), @"NSAscendingPageOrder",
    PLNG2SINT(NSUnknownPageOrder), @"NSUnknownPageOrder",

    // NSPrintingPaginationMode
    PLNG2SINT(NSAutoPagination), @"NSAutoPagination",
    PLNG2SINT(NSFitPagination), @"NSFitPagination",
    PLNG2SINT(NSClipPagination), @"NSClipPagination",

    // NSProgressIndicatorStyle
    PLNG2SINT(NSProgressIndicatorBarStyle), @"NSProgressIndicatorBarStyle",
    PLNG2SINT(NSProgressIndicatorSpinningStyle), @"NSProgressIndicatorSpinningStyle",

    // NSProgressIndicatorThickness
    PLNG2SINT(NSProgressIndicatorPreferredThickness),
                       @"NSProgressIndicatorPreferredThickness",
    PLNG2SINT(NSProgressIndicatorPreferredSmallThickness),
                       @"NSProgressIndicatorPreferredSmallThickness",
    PLNG2SINT(NSProgressIndicatorPreferredLargeThickness),
                       @"NSProgressIndicatorPreferredLargeThickness",
    PLNG2SINT(NSProgressIndicatorPreferredAquaThickness),
                       @"NSProgressIndicatorPreferredAquaThickness",

    // NSQTMovieLoopMode
    PLNG2SINT(NSQTMovieNormalPlayback), @"NSQTMovieNormalPlayback,",
    PLNG2SINT(NSQTMovieLoopingPlayback), @"NSQTMovieLoopingPlayback,",
    PLNG2SINT(NSQTMovieLoopingBackAndForthPlayback), @"NSQTMovieLoopingBackAndForthPlayback",

    // NSRequestUserAttentionType
    PLNG2SINT(NSCriticalRequest), @"NSCriticalRequest",
    PLNG2SINT(NSInformationalRequest), @"NSInformationalRequest",

    // NSRulerOrientation
    PLNG2SINT(NSHorizontalRuler), @"NSHorizontalRuler,",
    PLNG2SINT(NSVerticalRuler), @"NSVerticalRuler",

    // NSSaveOperationType
    PLNG2SINT(NSSaveOperation), @"NSSaveOperation",
    PLNG2SINT(NSSaveAsOperation), @"NSSaveAsOperation",
    PLNG2SINT(NSSaveToOperation), @"NSSaveToOperation",

    // NSScrollArrowPosition
    PLNG2SINT(NSScrollerArrowsDefaultSetting), @"NSScrollerArrowsDefaultSetting",
    PLNG2SINT(NSScrollerArrowsNone), @"NSScrollerArrowsNone",

    // NSScrollerArrow
    PLNG2SINT(NSScrollerIncrementArrow), @"NSScrollerIncrementArrow",
    PLNG2SINT(NSScrollerDecrementArrow), @"NSScrollerDecrementArrow",

    // NSScrollerPart
    PLNG2SINT(NSScrollerNoPart), @"NSScrollerNoPart",
    PLNG2SINT(NSScrollerDecrementPage), @"NSScrollerDecrementPage",
    PLNG2SINT(NSScrollerKnob), @"NSScrollerKnob",
    PLNG2SINT(NSScrollerIncrementPage), @"NSScrollerIncrementPage",
    PLNG2SINT(NSScrollerDecrementLine), @"NSScrollerDecrementLine",
    PLNG2SINT(NSScrollerIncrementLine), @"NSScrollerIncrementLine",
    PLNG2SINT(NSScrollerKnobSlot), @"NSScrollerKnobSlot",

    // NSSegmentSwitchTracking
    PLNG2SINT(NSSegmentSwitchTrackingSelectOne), @"NSSegmentSwitchTrackingSelectOne",
    PLNG2SINT(NSSegmentSwitchTrackingSelectAny), @"NSSegmentSwitchTrackingSelectAny",
    PLNG2SINT(NSSegmentSwitchTrackingMomentary), @"NSSegmentSwitchTrackingMomentary",

    // NSSelectionAffinity
    PLNG2SINT(NSSelectionAffinityUpstream), @"NSSelectionAffinityUpstream",
    PLNG2SINT(NSSelectionAffinityDownstream), @"NSSelectionAffinityDownstream",

    // NSSelectionDirection
    PLNG2SINT(NSDirectSelection), @"NSDirectSelection",
    PLNG2SINT(NSSelectingNext), @"NSSelectingNext,",
    PLNG2SINT(NSSelectingPrevious), @"NSSelectingPrevious",

    // NSSelectionGranularity
    PLNG2SINT(NSSelectByCharacter), @"NSSelectByCharacter",
    PLNG2SINT(NSSelectByWord), @"NSSelectByWord",
    PLNG2SINT(NSSelectByParagraph), @"NSSelectByParagraph",

    // NSSliderType
    PLNG2SINT(NSLinearSlider), @"NSLinearSlider",
    PLNG2SINT(NSCircularSlider), @"NSCircularSlider",

    // NSTabState
    PLNG2SINT(NSSelectedTab), @"NSSelectedTab",
    PLNG2SINT(NSBackgroundTab), @"NSBackgroundTab",
    PLNG2SINT(NSPressedTab), @"NSPressedTab",

    // NSTabViewType
    PLNG2SINT(NSTopTabsBezelBorder), @"NSTopTabsBezelBorder",
    PLNG2SINT(NSLeftTabsBezelBorder), @"NSLeftTabsBezelBorder",
    PLNG2SINT(NSBottomTabsBezelBorder), @"NSBottomTabsBezelBorder",
    PLNG2SINT(NSRightTabsBezelBorder), @"NSRightTabsBezelBorder",
    PLNG2SINT(NSNoTabsBezelBorder), @"NSNoTabsBezelBorder",
    PLNG2SINT(NSNoTabsLineBorder), @"NSNoTabsLineBorder",
    PLNG2SINT(NSNoTabsNoBorder), @"NSNoTabsNoBorder",

    // NSTableViewDropOperation
    PLNG2SINT(NSTableViewDropOn), @"NSTableViewDropOn,",
    PLNG2SINT(NSTableViewDropAbove), @"NSTableViewDropAbove",

    // NSTextAlignment
    PLNG2SINT(NSLeftTextAlignment), @"NSLeftTextAlignment",
    PLNG2SINT(NSRightTextAlignment), @"NSRightTextAlignment",
    PLNG2SINT(NSCenterTextAlignment), @"NSCenterTextAlignment",
    PLNG2SINT(NSJustifiedTextAlignment), @"NSJustifiedTextAlignment",
    PLNG2SINT(NSNaturalTextAlignment), @"NSNaturalTextAlignment",

    // NSTextFieldBezelStyle
    PLNG2SINT(NSTextFieldSquareBezel), @"NSTextFieldSquareBezel",
    PLNG2SINT(NSTextFieldRoundedBezel), @"NSTextFieldRoundedBezel",

    // NSTextTabType
    PLNG2SINT(NSLeftTabStopType), @"NSLeftTabStopType",
    PLNG2SINT(NSRightTabStopType), @"NSRightTabStopType,",
    PLNG2SINT(NSCenterTabStopType), @"NSCenterTabStopType,",
    PLNG2SINT(NSDecimalTabStopType), @"NSDecimalTabStopType",

    // NSTickMarkPosition
    PLNG2SINT(NSTickMarkBelow), @"NSTickMarkBelow",
    PLNG2SINT(NSTickMarkAbove), @"NSTickMarkAbove",
    PLNG2SINT(NSTickMarkLeft), @"NSTickMarkLeft",
    PLNG2SINT(NSTickMarkRight), @"NSTickMarkRight",

    // NSTIFFCompression
    PLNG2SINT(NSTIFFCompressionNone), @"NSTIFFCompressionNone",
    PLNG2SINT(NSTIFFCompressionCCITTFAX3), @"NSTIFFCompressionCCITTFAX3",
    PLNG2SINT(NSTIFFCompressionCCITTFAX4), @"NSTIFFCompressionCCITTFAX4",
    PLNG2SINT(NSTIFFCompressionLZW), @"NSTIFFCompressionLZW",
    PLNG2SINT(NSTIFFCompressionJPEG), @"NSTIFFCompressionJPEG",
    PLNG2SINT(NSTIFFCompressionNEXT), @"NSTIFFCompressionNEXT",
    PLNG2SINT(NSTIFFCompressionPackBits), @"NSTIFFCompressionPackBits",
    PLNG2SINT(NSTIFFCompressionOldJPEG), @"NSTIFFCompressionOldJPEG",

    // NSTitlePosition
    PLNG2SINT(NSNoTitle), @"NSNoTitle",
    PLNG2SINT(NSAboveTop), @"NSAboveTop",
    PLNG2SINT(NSAtTop), @"NSAtTop",
    PLNG2SINT(NSBelowTop), @"NSBelowTop",
    PLNG2SINT(NSAboveBottom), @"NSAboveBottom",
    PLNG2SINT(NSAtBottom), @"NSAtBottom",
    PLNG2SINT(NSBelowBottom), @"NSBelowBottom",

    // NSToolbarDisplayMode
    PLNG2SINT(NSToolbarDisplayModeDefault), @"NSToolbarDisplayModeDefault,",
    PLNG2SINT(NSToolbarDisplayModeIconAndLabel), @"NSToolbarDisplayModeIconAndLabel,",
    PLNG2SINT(NSToolbarDisplayModeIconOnly), @"NSToolbarDisplayModeIconOnly,",
    PLNG2SINT(NSToolbarDisplayModeLabelOnly), @"NSToolbarDisplayModeLabelOnly",

    // NSToolbarSizeMode
    PLNG2SINT(NSToolbarSizeModeDefault), @"NSToolbarSizeModeDefault,",
    PLNG2SINT(NSToolbarSizeModeRegular), @"NSToolbarSizeModeRegular,",
    PLNG2SINT(NSToolbarSizeModeSmall), @"NSToolbarSizeModeSmall",

    // NSTypesetterBehavior
    PLNG2SINT(NSTypesetterLatestBehavior), @"NSTypesetterLatestBehavior",
    PLNG2SINT(NSTypesetterOriginalBehavior), @"NSTypesetterOriginalBehavior",
    PLNG2SINT(NSTypesetterBehavior_10_2_WithCompatibility),
                       @"NSTypesetterBehavior_10_2_WithCompatibility",
    PLNG2SINT(NSTypesetterBehavior_10_2), @"NSTypesetterBehavior_10_2",
    PLNG2SINT(NSTypesetterBehavior_10_3), @"NSTypesetterBehavior_10_3",

    // NSUsableScrollerParts
    PLNG2SINT(NSNoScrollerParts), @"NSNoScrollerParts",
    PLNG2SINT(NSOnlyScrollerArrows), @"NSOnlyScrollerArrows",
    PLNG2SINT(NSAllScrollerParts), @"NSAllScrollerParts",

    // NSWindingRule
    PLNG2SINT(NSNonZeroWindingRule), @"NSNonZeroWindingRule",
    PLNG2SINT(NSEvenOddWindingRule), @"NSEvenOddWindingRule",

    // NSWindowButton
    PLNG2SINT(NSWindowCloseButton), @"NSWindowCloseButton,",
    PLNG2SINT(NSWindowMiniaturizeButton), @"NSWindowMiniaturizeButton,",
    PLNG2SINT(NSWindowZoomButton), @"NSWindowZoomButton,",
    PLNG2SINT(NSWindowToolbarButton), @"NSWindowToolbarButton,",
    PLNG2SINT(NSWindowDocumentIconButton), @"NSWindowDocumentIconButton",

    // NSWindowOrderingMode
    PLNG2SINT(NSWindowAbove), @"NSWindowAbove",
    PLNG2SINT(NSWindowBelow), @"NSWindowBelow",
    PLNG2SINT(NSWindowOut), @"NSWindowOut",

    // NSWritingDirection
    PLNG2SINT(NSWritingDirectionLeftToRight), @"NSWritingDirectionLeftToRight",
    PLNG2SINT(NSWritingDirectionRightToLeft), @"NSWritingDirectionRightToLeft",

    // NSAlert\Button
    PLNG2SINT(NSAlertFirstButtonReturn), @"NSAlertFirstButtonReturn",
    PLNG2SINT(NSAlertSecondButtonReturn), @"NSAlertSecondButtonReturn",
    PLNG2SINT(NSAlertThirdButtonReturn), @"NSAlertThirdButtonReturn",

    // NSApplication\Modal
    PLNG2SINT(NSRunStoppedResponse), @"NSRunStoppedResponse",
    PLNG2SINT(NSRunAbortedResponse), @"NSRunAbortedResponse",
    PLNG2SINT(NSRunContinuesResponse), @"NSRunContinuesResponse",

    // NSAttributedString\Underlining
    PLNG2SINT(NSUnderlinePatternSolid), @"NSUnderlinePatternSolid",
    PLNG2SINT(NSUnderlinePatternDot), @"NSUnderlinePatternDot",
    PLNG2SINT(NSUnderlinePatternDash), @"NSUnderlinePatternDash",
    PLNG2SINT(NSUnderlinePatternDashDot), @"NSUnderlinePatternDashDot",
    PLNG2SINT(NSUnderlinePatternDashDotDot), @"NSUnderlinePatternDashDotDot",

    // NSAttributedString\Underlining
    PLNG2SINT(NSUnderlineStyleNone), @"NSUnderlineStyleNone",
    PLNG2SINT(NSUnderlineStyleSingle), @"NSUnderlineStyleSingle",
    PLNG2SINT(NSUnderlineStyleThick), @"NSUnderlineStyleThick",
    PLNG2SINT(NSUnderlineStyleDouble), @"NSUnderlineStyleDouble",

    // NSCell\Data
    PLNG2SINT(NSAnyType), @"NSAnyType",
    PLNG2SINT(NSIntType), @"NSIntType",
    PLNG2SINT(NSPositiveIntType), @"NSPositiveIntType",
    PLNG2SINT(NSFloatType), @"NSFloatType",
    PLNG2SINT(NSPositiveFloatType), @"NSPositiveFloatType",
    PLNG2SINT(NSDoubleType), @"NSDoubleType",
    PLNG2SINT(NSPositiveDoubleType), @"NSPositiveDoubleType",

    // NSCell\State
    PLNG2SINT(NSNoCellMask), @"NSNoCellMask",
    PLNG2SINT(NSContentsCellMask), @"NSContentsCellMask",
    PLNG2SINT(NSPushInCellMask), @"NSPushInCellMask",
    PLNG2SINT(NSChangeGrayCellMask), @"NSChangeGrayCellMask",
    PLNG2SINT(NSChangeBackgroundCellMask), @"NSChangeBackgroundCellMask",

    // NSColorPanel\Modes
    PLNG2SINT(NSGrayModeColorPanel), @"NSGrayModeColorPanel",
    PLNG2SINT(NSRGBModeColorPanel), @"NSRGBModeColorPanel",
    PLNG2SINT(NSCMYKModeColorPanel), @"NSCMYKModeColorPanel",
    PLNG2SINT(NSHSBModeColorPanel), @"NSHSBModeColorPanel",
    PLNG2SINT(NSCustomPaletteModeColorPanel), @"NSCustomPaletteModeColorPanel",
    PLNG2SINT(NSColorListModeColorPanel), @"NSColorListModeColorPanel",
    PLNG2SINT(NSWheelModeColorPanel), @"NSWheelModeColorPanel",
    PLNG2SINT(NSCrayonModeColorPanel), @"NSCrayonModeColorPanel",

    // NSColorPanel\Mode
    PLNG2SINT(NSColorPanelGrayModeMask), @"NSColorPanelGrayModeMask",
    PLNG2SINT(NSColorPanelRGBModeMask), @"NSColorPanelRGBModeMask",
    PLNG2SINT(NSColorPanelCMYKModeMask), @"NSColorPanelCMYKModeMask",
    PLNG2SINT(NSColorPanelHSBModeMask), @"NSColorPanelHSBModeMask",
    PLNG2SINT(NSColorPanelCustomPaletteModeMask), @"NSColorPanelCustomPaletteModeMask",
    PLNG2SINT(NSColorPanelColorListModeMask), @"NSColorPanelColorListModeMask",
    PLNG2SINT(NSColorPanelWheelModeMask), @"NSColorPanelWheelModeMask",
    PLNG2SINT(NSColorPanelCrayonModeMask), @"NSColorPanelCrayonModeMask",
    PLNG2SINT(NSColorPanelAllModesMask), @"NSColorPanelAllModesMask",

    // NSDragging\Operations
    PLNG2SINT(NSDragOperationNone), @"NSDragOperationNone",
    PLNG2SINT(NSDragOperationCopy), @"NSDragOperationCopy",
    PLNG2SINT(NSDragOperationLink), @"NSDragOperationLink",
    PLNG2SINT(NSDragOperationGeneric), @"NSDragOperationGeneric",
    PLNG2SINT(NSDragOperationPrivate), @"NSDragOperationPrivate",
    PLNG2SINT(NSDragOperationMove), @"NSDragOperationMove",
    PLNG2SINT(NSDragOperationDelete), @"NSDragOperationDelete",
    PLNG2SINT(NSDragOperationEvery), @"NSDragOperationEvery",

    // NSEvent\Action
    PLNG2SINT(NSLeftMouseDownMask), @"NSLeftMouseDownMask",
    PLNG2SINT(NSLeftMouseUpMask), @"NSLeftMouseUpMask",
    PLNG2SINT(NSRightMouseDownMask), @"NSRightMouseDownMask",
    PLNG2SINT(NSRightMouseUpMask), @"NSRightMouseUpMask",
    PLNG2SINT(NSMouseMovedMask), @"NSMouseMovedMask",
    PLNG2SINT(NSLeftMouseDraggedMask), @"NSLeftMouseDraggedMask",
    PLNG2SINT(NSRightMouseDraggedMask), @"NSRightMouseDraggedMask",
    PLNG2SINT(NSMouseEnteredMask), @"NSMouseEnteredMask",
    PLNG2SINT(NSMouseExitedMask), @"NSMouseExitedMask",
    PLNG2SINT(NSKeyDownMask), @"NSKeyDownMask",
    PLNG2SINT(NSKeyUpMask), @"NSKeyUpMask",
    PLNG2SINT(NSFlagsChangedMask), @"NSFlagsChangedMask",
    PLNG2SINT(NSAppKitDefinedMask), @"NSAppKitDefinedMask",
    PLNG2SINT(NSSystemDefinedMask), @"NSSystemDefinedMask",
    PLNG2SINT(NSApplicationDefinedMask), @"NSApplicationDefinedMask",
    PLNG2SINT(NSPeriodicMask), @"NSPeriodicMask",
    PLNG2SINT(NSCursorUpdateMask), @"NSCursorUpdateMask",
    PLNG2SINT(NSScrollWheelMask), @"NSScrollWheelMask",
    PLNG2SINT(NSOtherMouseDownMask), @"NSOtherMouseDownMask",
    PLNG2SINT(NSOtherMouseUpMask), @"NSOtherMouseUpMask",
    PLNG2SINT(NSOtherMouseDraggedMask), @"NSOtherMouseDraggedMask",
    PLNG2SINT(NSAnyEventMask), @"NSAnyEventMask",

    // NSEvent\Function-Key
    PLNG2SINT(NSUpArrowFunctionKey), @"NSUpArrowFunctionKey",
    PLNG2SINT(NSDownArrowFunctionKey), @"NSDownArrowFunctionKey",
    PLNG2SINT(NSLeftArrowFunctionKey), @"NSLeftArrowFunctionKey",
    PLNG2SINT(NSRightArrowFunctionKey), @"NSRightArrowFunctionKey",
    PLNG2SINT(NSF1FunctionKey), @"NSF1FunctionKey",
    PLNG2SINT(NSF2FunctionKey), @"NSF2FunctionKey",
    PLNG2SINT(NSF3FunctionKey), @"NSF3FunctionKey",
    PLNG2SINT(NSF4FunctionKey), @"NSF4FunctionKey",
    PLNG2SINT(NSF5FunctionKey), @"NSF5FunctionKey",
    PLNG2SINT(NSF6FunctionKey), @"NSF6FunctionKey",
    PLNG2SINT(NSF7FunctionKey), @"NSF7FunctionKey",
    PLNG2SINT(NSF8FunctionKey), @"NSF8FunctionKey",
    PLNG2SINT(NSF9FunctionKey), @"NSF9FunctionKey",
    PLNG2SINT(NSF10FunctionKey), @"NSF10FunctionKey",
    PLNG2SINT(NSF11FunctionKey), @"NSF11FunctionKey",
    PLNG2SINT(NSF12FunctionKey), @"NSF12FunctionKey",
    PLNG2SINT(NSF13FunctionKey), @"NSF13FunctionKey",
    PLNG2SINT(NSF14FunctionKey), @"NSF14FunctionKey",
    PLNG2SINT(NSF15FunctionKey), @"NSF15FunctionKey",
    PLNG2SINT(NSF16FunctionKey), @"NSF16FunctionKey",
    PLNG2SINT(NSF17FunctionKey), @"NSF17FunctionKey",
    PLNG2SINT(NSF18FunctionKey), @"NSF18FunctionKey",
    PLNG2SINT(NSF19FunctionKey), @"NSF19FunctionKey",
    PLNG2SINT(NSF20FunctionKey), @"NSF20FunctionKey",
    PLNG2SINT(NSF21FunctionKey), @"NSF21FunctionKey",
    PLNG2SINT(NSF22FunctionKey), @"NSF22FunctionKey",
    PLNG2SINT(NSF23FunctionKey), @"NSF23FunctionKey",
    PLNG2SINT(NSF24FunctionKey), @"NSF24FunctionKey",
    PLNG2SINT(NSF25FunctionKey), @"NSF25FunctionKey",
    PLNG2SINT(NSF26FunctionKey), @"NSF26FunctionKey",
    PLNG2SINT(NSF27FunctionKey), @"NSF27FunctionKey",
    PLNG2SINT(NSF28FunctionKey), @"NSF28FunctionKey",
    PLNG2SINT(NSF29FunctionKey), @"NSF29FunctionKey",
    PLNG2SINT(NSF30FunctionKey), @"NSF30FunctionKey",
    PLNG2SINT(NSF31FunctionKey), @"NSF31FunctionKey",
    PLNG2SINT(NSF32FunctionKey), @"NSF32FunctionKey",
    PLNG2SINT(NSF33FunctionKey), @"NSF33FunctionKey",
    PLNG2SINT(NSF34FunctionKey), @"NSF34FunctionKey",
    PLNG2SINT(NSF35FunctionKey), @"NSF35FunctionKey",
    PLNG2SINT(NSInsertFunctionKey), @"NSInsertFunctionKey",
    PLNG2SINT(NSDeleteFunctionKey), @"NSDeleteFunctionKey",
    PLNG2SINT(NSHomeFunctionKey), @"NSHomeFunctionKey",
    PLNG2SINT(NSBeginFunctionKey), @"NSBeginFunctionKey",
    PLNG2SINT(NSEndFunctionKey), @"NSEndFunctionKey",
    PLNG2SINT(NSPageUpFunctionKey), @"NSPageUpFunctionKey",
    PLNG2SINT(NSPageDownFunctionKey), @"NSPageDownFunctionKey",
    PLNG2SINT(NSPrintScreenFunctionKey), @"NSPrintScreenFunctionKey",
    PLNG2SINT(NSScrollLockFunctionKey), @"NSScrollLockFunctionKey",
    PLNG2SINT(NSPauseFunctionKey), @"NSPauseFunctionKey",
    PLNG2SINT(NSSysReqFunctionKey), @"NSSysReqFunctionKey",
    PLNG2SINT(NSBreakFunctionKey), @"NSBreakFunctionKey",
    PLNG2SINT(NSResetFunctionKey), @"NSResetFunctionKey",
    PLNG2SINT(NSStopFunctionKey), @"NSStopFunctionKey",
    PLNG2SINT(NSMenuFunctionKey), @"NSMenuFunctionKey",
    PLNG2SINT(NSUserFunctionKey), @"NSUserFunctionKey",
    PLNG2SINT(NSSystemFunctionKey), @"NSSystemFunctionKey",
    PLNG2SINT(NSPrintFunctionKey), @"NSPrintFunctionKey",
    PLNG2SINT(NSClearLineFunctionKey), @"NSClearLineFunctionKey",
    PLNG2SINT(NSClearDisplayFunctionKey), @"NSClearDisplayFunctionKey",
    PLNG2SINT(NSInsertLineFunctionKey), @"NSInsertLineFunctionKey",
    PLNG2SINT(NSDeleteLineFunctionKey), @"NSDeleteLineFunctionKey",
    PLNG2SINT(NSInsertCharFunctionKey), @"NSInsertCharFunctionKey",
    PLNG2SINT(NSDeleteCharFunctionKey), @"NSDeleteCharFunctionKey",
    PLNG2SINT(NSPrevFunctionKey), @"NSPrevFunctionKey",
    PLNG2SINT(NSNextFunctionKey), @"NSNextFunctionKey",
    PLNG2SINT(NSSelectFunctionKey), @"NSSelectFunctionKey",
    PLNG2SINT(NSExecuteFunctionKey), @"NSExecuteFunctionKey",
    PLNG2SINT(NSUndoFunctionKey), @"NSUndoFunctionKey",
    PLNG2SINT(NSRedoFunctionKey), @"NSRedoFunctionKey",
    PLNG2SINT(NSFindFunctionKey), @"NSFindFunctionKey",
    PLNG2SINT(NSHelpFunctionKey), @"NSHelpFunctionKey",
    PLNG2SINT(NSModeSwitchFunctionKey), @"NSModeSwitchFunctionKey",

    // NSEvent\Modifier
    PLNG2SINT(NSAlphaShiftKeyMask), @"NSAlphaShiftKeyMask",
    PLNG2SINT(NSShiftKeyMask), @"NSShiftKeyMask",
    PLNG2SINT(NSControlKeyMask), @"NSControlKeyMask",
    PLNG2SINT(NSAlternateKeyMask), @"NSAlternateKeyMask",
    PLNG2SINT(NSCommandKeyMask), @"NSCommandKeyMask",
    PLNG2SINT(NSNumericPadKeyMask), @"NSNumericPadKeyMask",
    PLNG2SINT(NSHelpKeyMask), @"NSHelpKeyMask",
    PLNG2SINT(NSFunctionKeyMask), @"NSFunctionKeyMask",

    // NSEvent\Types
    PLNG2SINT(NSWindowExposedEventType), @"NSWindowExposedEventType",
    PLNG2SINT(NSApplicationActivatedEventType), @"NSApplicationActivatedEventType",
    PLNG2SINT(NSApplicationDeactivatedEventType), @"NSApplicationDeactivatedEventType",
    PLNG2SINT(NSWindowMovedEventType), @"NSWindowMovedEventType",
    PLNG2SINT(NSScreenChangedEventType), @"NSScreenChangedEventType",
    PLNG2SINT(NSAWTEventType), @"NSAWTEventType",

    // NSEvent\Types
    PLNG2SINT(NSPowerOffEventType), @"NSPowerOffEventType",

    // NSFont\Traits
    PLNG2SINT(NSItalicFontMask), @"NSItalicFontMask",
    PLNG2SINT(NSBoldFontMask), @"NSBoldFontMask",
    PLNG2SINT(NSUnboldFontMask), @"NSUnboldFontMask",
    PLNG2SINT(NSNonStandardCharacterSetFontMask), @"NSNonStandardCharacterSetFontMask",
    PLNG2SINT(NSNarrowFontMask), @"NSNarrowFontMask",
    PLNG2SINT(NSExpandedFontMask), @"NSExpandedFontMask",
    PLNG2SINT(NSCondensedFontMask), @"NSCondensedFontMask",
    PLNG2SINT(NSSmallCapsFontMask), @"NSSmallCapsFontMask",
    PLNG2SINT(NSPosterFontMask), @"NSPosterFontMask",
    PLNG2SINT(NSCompressedFontMask), @"NSCompressedFontMask",
    PLNG2SINT(NSFixedPitchFontMask), @"NSFixedPitchFontMask",
    PLNG2SINT(NSUnitalicFontMask), @"NSUnitalicFontMask",

    // NSFontManager\Font Collection Mask
    PLNG2SINT(NSFontCollectionApplicationOnlyMask),
                       @"NSFontCollectionApplicationOnlyMask",

    // NSFontPanel\Mode Masks
    PLNG2SINT(NSFontPanelFaceModeMask), @"NSFontPanelFaceModeMask",
    PLNG2SINT(NSFontPanelSizeModeMask), @"NSFontPanelSizeModeMask",
    PLNG2SINT(NSFontPanelCollectionModeMask), @"NSFontPanelCollectionModeMask",
    PLNG2SINT(NSFontPanelStandardModesMask), @"NSFontPanelStandardModesMask",
    PLNG2SINT(NSFontPanelAllModesMask), @"NSFontPanelAllModesMask",

    // NSGlyph\Reserved
    PLNG2SINT(NSControlGlyph), @"NSControlGlyph",
    PLNG2SINT(NSNullGlyph), @"NSNullGlyph",

    // NSGlyphStorage\Layout
    PLNG2SINT(NSShowControlGlyphs), @"NSShowControlGlyphs",
    PLNG2SINT(NSShowInvisibleGlyphs), @"NSShowInvisibleGlyphs",
    PLNG2SINT(NSWantsBidiLevels), @"NSWantsBidiLevels",

    // NSImageRep\Display
    PLNG2SINT(NSImageRepMatchesDevice), @"NSImageRepMatchesDevice",

    // NSOutlineView\Drop
    PLNG2SINT(NSOutlineViewDropOnItemIndex), @"NSOutlineViewDropOnItemIndex",

    // NSPanel\Alert
    PLNG2SINT(NSAlertDefaultReturn), @"NSAlertDefaultReturn",
    PLNG2SINT(NSAlertAlternateReturn), @"NSAlertAlternateReturn",
    PLNG2SINT(NSAlertOtherReturn), @"NSAlertOtherReturn",
    PLNG2SINT(NSAlertErrorReturn), @"NSAlertErrorReturn",

    // NSPanel\Modal
    PLNG2SINT(NSOKButton), @"NSOKButton",
    PLNG2SINT(NSCancelButton), @"NSCancelButton",

    // NSPanel\Style
    PLNG2SINT(NSUtilityWindowMask), @"NSUtilityWindowMask",
    PLNG2SINT(NSDocModalWindowMask), @"NSDocModalWindowMask",
    PLNG2SINT(NSNonactivatingPanelMask), @"NSNonactivatingPanelMask",

    // NSRunLoop\Ordering
    PLNG2SINT(NSUpdateWindowsRunLoopOrdering), @"NSUpdateWindowsRunLoopOrdering",

    // NSRunLoop\Ordering
    PLNG2SINT(NSDisplayWindowRunLoopOrdering), @"NSDisplayWindowRunLoopOrdering,",
    PLNG2SINT(NSResetCursorRectsRunLoopOrdering), @"NSResetCursorRectsRunLoopOrdering",

    // NSSavePanel\Tags
    PLNG2SINT(NSFileHandlingPanelCancelButton), @"NSFileHandlingPanelCancelButton",
    PLNG2SINT(NSFileHandlingPanelOKButton), @"NSFileHandlingPanelOKButton",

    // NSTableView\Grid
    PLNG2SINT(NSTableViewGridNone), @"NSTableViewGridNone",
    PLNG2SINT(NSTableViewSolidVerticalGridLineMask), @"NSTableViewSolidVerticalGridLineMask",
    PLNG2SINT(NSTableViewSolidHorizontalGridLineMask), @"NSTableViewSolidHorizontalGridLineMask",

    // NSTextAttachment\Attachment
    PLNG2SINT(NSAttachmentCharacter), @"NSAttachmentCharacter",

    // NSText\Important
    PLNG2SINT(NSParagraphSeparatorCharacter), @"NSParagraphSeparatorCharacter",
    PLNG2SINT(NSLineSeparatorCharacter), @"NSLineSeparatorCharacter",
    PLNG2SINT(NSTabCharacter), @"NSTabCharacter",
    PLNG2SINT(NSFormFeedCharacter), @"NSFormFeedCharacter",
    PLNG2SINT(NSNewlineCharacter), @"NSNewlineCharacter",
    PLNG2SINT(NSCarriageReturnCharacter), @"NSCarriageReturnCharacter",
    PLNG2SINT(NSEnterCharacter), @"NSEnterCharacter",
    PLNG2SINT(NSBackspaceCharacter), @"NSBackspaceCharacter",
    PLNG2SINT(NSBackTabCharacter), @"NSBackTabCharacter",
    PLNG2SINT(NSDeleteCharacter), @"NSDeleteCharacter",

    // NSText\Movement
    PLNG2SINT(NSIllegalTextMovement), @"NSIllegalTextMovement",
    PLNG2SINT(NSReturnTextMovement), @"NSReturnTextMovement",
    PLNG2SINT(NSTabTextMovement), @"NSTabTextMovement",
    PLNG2SINT(NSBacktabTextMovement), @"NSBacktabTextMovement",
    PLNG2SINT(NSLeftTextMovement), @"NSLeftTextMovement",
    PLNG2SINT(NSRightTextMovement), @"NSRightTextMovement",
    PLNG2SINT(NSUpTextMovement), @"NSUpTextMovement",
    PLNG2SINT(NSDownTextMovement), @"NSDownTextMovement",
    PLNG2SINT(NSCancelTextMovement), @"NSCancelTextMovement",
    PLNG2SINT(NSOtherTextMovement), @"NSOtherTextMovement",

    // NSTextStorage\Editing
    PLNG2SINT(NSTextStorageEditedAttributes), @"NSTextStorageEditedAttributes",
    PLNG2SINT(NSTextStorageEditedCharacters), @"NSTextStorageEditedCharacters",

    // NSView\Resizing
    PLNG2SINT(NSViewNotSizable), @"NSViewNotSizable",
    PLNG2SINT(NSViewMinXMargin), @"NSViewMinXMargin",
    PLNG2SINT(NSViewWidthSizable), @"NSViewWidthSizable",
    PLNG2SINT(NSViewMaxXMargin), @"NSViewMaxXMargin",
    PLNG2SINT(NSViewMinYMargin), @"NSViewMinYMargin",
    PLNG2SINT(NSViewHeightSizable), @"NSViewHeightSizable",
    PLNG2SINT(NSViewMaxYMargin), @"NSViewMaxYMargin",

    // NSWindow\Border
    PLNG2SINT(NSBorderlessWindowMask), @"NSBorderlessWindowMask",
    PLNG2SINT(NSTitledWindowMask), @"NSTitledWindowMask",
    PLNG2SINT(NSClosableWindowMask), @"NSClosableWindowMask",
    PLNG2SINT(NSMiniaturizableWindowMask), @"NSMiniaturizableWindowMask",
    PLNG2SINT(NSResizableWindowMask), @"NSResizableWindowMask",
    PLNG2SINT(NSTexturedBackgroundWindowMask), @"NSTexturedBackgroundWindowMask",

    // NSWorkspace\Launch
    PLNG2SINT(NSWorkspaceLaunchAndPrint), @"NSWorkspaceLaunchAndPrint",
    PLNG2SINT(NSWorkspaceLaunchInhibitingBackgroundOnly), @"NSWorkspaceLaunchInhibitingBackgroundOnly",
    PLNG2SINT(NSWorkspaceLaunchWithoutAddingToRecents), @"NSWorkspaceLaunchWithoutAddingToRecents",
    PLNG2SINT(NSWorkspaceLaunchWithoutActivation), @"NSWorkspaceLaunchWithoutActivation",
    PLNG2SINT(NSWorkspaceLaunchAsync), @"NSWorkspaceLaunchAsync",
    PLNG2SINT(NSWorkspaceLaunchAllowingClassicStartup), @"NSWorkspaceLaunchAllowingClassicStartup",
    PLNG2SINT(NSWorkspaceLaunchPreferringClassic), @"NSWorkspaceLaunchPreferringClassic",
    PLNG2SINT(NSWorkspaceLaunchNewInstance), @"NSWorkspaceLaunchNewInstance",
    PLNG2SINT(NSWorkspaceLaunchAndHide), @"NSWorkspaceLaunchAndHide",
    PLNG2SINT(NSWorkspaceLaunchAndHideOthers), @"NSWorkspaceLaunchAndHideOthers",
    PLNG2SINT(NSWorkspaceLaunchDefault), @"NSWorkspaceLaunchDefault",

    nil];
}

+ (NSDictionary *)applicationGlobalVariableDictionary
{
  return [NSDictionary dictionaryWithObjectsAndKeys:

    // Color Space Names
    NSCalibratedWhiteColorSpace, @"NSCalibratedWhiteColorSpace",
    NSCalibratedBlackColorSpace, @"NSCalibratedBlackColorSpace",
    NSCalibratedRGBColorSpace, @"NSCalibratedRGBColorSpace",
    NSDeviceWhiteColorSpace, @"NSDeviceWhiteColorSpace",
    NSDeviceBlackColorSpace, @"NSDeviceBlackColorSpace",
    NSDeviceRGBColorSpace, @"NSDeviceRGBColorSpace",
    NSDeviceCMYKColorSpace, @"NSDeviceCMYKColorSpace",
    NSNamedColorSpace, @"NSNamedColorSpace",
    NSPatternColorSpace, @"NSPatternColorSpace",
    NSCustomColorSpace, @"NSCustomColorSpace",

    // Display Device\Descriptions
    NSDeviceResolution, @"NSDeviceResolution",
    NSDeviceColorSpaceName, @"NSDeviceColorSpaceName",
    NSDeviceBitsPerSample, @"NSDeviceBitsPerSample",
    NSDeviceIsScreen, @"NSDeviceIsScreen",
    NSDeviceIsPrinter, @"NSDeviceIsPrinter",
    NSDeviceSize, @"NSDeviceSize",

    // Nib Loading Keys
    NSNibOwner, @"NSNibOwner",
    NSNibTopLevelObjects, @"NSNibTopLevelObjects",

    // NSAccessibility\Actions
    NSAccessibilityPressAction, @"NSAccessibilityPressAction",
    NSAccessibilityIncrementAction, @"NSAccessibilityIncrementAction",
    NSAccessibilityDecrementAction, @"NSAccessibilityDecrementAction",
    NSAccessibilityConfirmAction, @"NSAccessibilityConfirmAction",
    NSAccessibilityPickAction, @"NSAccessibilityPickAction",
    NSAccessibilityCancelAction, @"NSAccessibilityCancelAction",
    NSAccessibilityRaiseAction, @"NSAccessibilityRaiseAction",

    // NSAccessibility\Attributes
    NSAccessibilityRoleAttribute, @"NSAccessibilityRoleAttribute",
    NSAccessibilityRoleDescriptionAttribute, @"NSAccessibilityRoleDescriptionAttribute",
    NSAccessibilitySubroleAttribute, @"NSAccessibilitySubroleAttribute",
    NSAccessibilityHelpAttribute, @"NSAccessibilityHelpAttribute",
    NSAccessibilityTitleAttribute, @"NSAccessibilityTitleAttribute",
    NSAccessibilityValueAttribute, @"NSAccessibilityValueAttribute",
    NSAccessibilityMinValueAttribute, @"NSAccessibilityMinValueAttribute",
    NSAccessibilityMaxValueAttribute, @"NSAccessibilityMaxValueAttribute",
    NSAccessibilityEnabledAttribute, @"NSAccessibilityEnabledAttribute",
    NSAccessibilityFocusedAttribute, @"NSAccessibilityFocusedAttribute",
    NSAccessibilityParentAttribute, @"NSAccessibilityParentAttribute",
    NSAccessibilityChildrenAttribute, @"NSAccessibilityChildrenAttribute",
    NSAccessibilityWindowAttribute, @"NSAccessibilityWindowAttribute",
    NSAccessibilitySelectedChildrenAttribute, @"NSAccessibilitySelectedChildrenAttribute",
    NSAccessibilityVisibleChildrenAttribute, @"NSAccessibilityVisibleChildrenAttribute",
    NSAccessibilityPositionAttribute, @"NSAccessibilityPositionAttribute",
    NSAccessibilitySizeAttribute, @"NSAccessibilitySizeAttribute",
    NSAccessibilityContentsAttribute, @"NSAccessibilityContentsAttribute",
    NSAccessibilityPreviousContentsAttribute, @"NSAccessibilityPreviousContentsAttribute",
    NSAccessibilityNextContentsAttribute, @"NSAccessibilityNextContentsAttribute",
    NSAccessibilitySelectedTextAttribute, @"NSAccessibilitySelectedTextAttribute",
    NSAccessibilitySelectedTextRangeAttribute,
                       @"NSAccessibilitySelectedTextRangeAttribute",
    NSAccessibilityNumberOfCharactersAttribute,
                       @"NSAccessibilityNumberOfCharactersAttribute",
    NSAccessibilityVisibleCharacterRangeAttribute,
                       @"NSAccessibilityVisibleCharacterRangeAttribute",
    NSAccessibilityLineForIndexParameterizedAttribute,
                       @"NSAccessibilityLineForIndexParameterizedAttribute",
    NSAccessibilityRangeForLineParameterizedAttribute, 
                       @"NSAccessibilityRangeForLineParameterizedAttribute",
    NSAccessibilityStringForRangeParameterizedAttribute,
                       @"NSAccessibilityStringForRangeParameterizedAttribute",
    NSAccessibilityRangeForPositionParameterizedAttribute,
                       @"NSAccessibilityRangeForPositionParameterizedAttribute",
    NSAccessibilityRangeForIndexParameterizedAttribute,
                       @"NSAccessibilityRangeForIndexParameterizedAttribute",
    NSAccessibilityBoundsForRangeParameterizedAttribute,
                       @"NSAccessibilityBoundsForRangeParameterizedAttribute",
    NSAccessibilityRTFForRangeParameterizedAttribute,
                       @"NSAccessibilityRTFForRangeParameterizedAttribute",
    NSAccessibilityStyleRangeForIndexParameterizedAttribute,
                       @"NSAccessibilityStyleRangeForIndexParameterizedAttribute",
    NSAccessibilityMainAttribute, @"NSAccessibilityMainAttribute",
    NSAccessibilityMinimizedAttribute, @"NSAccessibilityMinimizedAttribute",
    NSAccessibilityCloseButtonAttribute, @"NSAccessibilityCloseButtonAttribute",
    NSAccessibilityZoomButtonAttribute, @"NSAccessibilityZoomButtonAttribute",
    NSAccessibilityMinimizeButtonAttribute, @"NSAccessibilityMinimizeButtonAttribute",
    NSAccessibilityToolbarButtonAttribute, @"NSAccessibilityToolbarButtonAttribute",
    NSAccessibilityProxyAttribute, @"NSAccessibilityProxyAttribute",
    NSAccessibilityGrowAreaAttribute, @"NSAccessibilityGrowAreaAttribute",
    NSAccessibilityModalAttribute, @"NSAccessibilityModalAttribute",
    NSAccessibilityDefaultButtonAttribute, @"NSAccessibilityDefaultButtonAttribute",
    NSAccessibilityCancelButtonAttribute, @"NSAccessibilityCancelButtonAttribute",
    NSAccessibilityMenuBarAttribute, @"NSAccessibilityMenuBarAttribute",
    NSAccessibilityWindowsAttribute, @"NSAccessibilityWindowsAttribute",
    NSAccessibilityFrontmostAttribute, @"NSAccessibilityFrontmostAttribute",
    NSAccessibilityHiddenAttribute, @"NSAccessibilityHiddenAttribute",
    NSAccessibilityMainWindowAttribute, @"NSAccessibilityMainWindowAttribute",
    NSAccessibilityFocusedWindowAttribute, @"NSAccessibilityFocusedWindowAttribute",
    NSAccessibilityFocusedUIElementAttribute, @"NSAccessibilityFocusedUIElementAttribute",
    NSAccessibilityHeaderAttribute, @"NSAccessibilityHeaderAttribute",
    NSAccessibilityEditedAttribute, @"NSAccessibilityEditedAttribute",
    NSAccessibilityTabsAttribute, @"NSAccessibilityTabsAttribute",
    NSAccessibilityTitleUIElementAttribute, @"NSAccessibilityTitleUIElementAttribute",
    NSAccessibilityHorizontalScrollBarAttribute, @"NSAccessibilityHorizontalScrollBarAttribute",
    NSAccessibilityVerticalScrollBarAttribute, @"NSAccessibilityVerticalScrollBarAttribute",
    NSAccessibilityOverflowButtonAttribute, @"NSAccessibilityOverflowButtonAttribute",
    NSAccessibilityIncrementButtonAttribute, @"NSAccessibilityIncrementButtonAttribute",
    NSAccessibilityDecrementButtonAttribute, @"NSAccessibilityDecrementButtonAttribute",
    NSAccessibilityFilenameAttribute, @"NSAccessibilityFilenameAttribute",
    NSAccessibilityExpandedAttribute, @"NSAccessibilityExpandedAttribute",
    NSAccessibilitySelectedAttribute, @"NSAccessibilitySelectedAttribute",
    NSAccessibilityColumnTitlesAttribute, @"NSAccessibilityColumnTitlesAttribute",
    NSAccessibilitySearchButtonAttribute, @"NSAccessibilitySearchButtonAttribute",
    NSAccessibilitySearchMenuAttribute, @"NSAccessibilitySearchMenuAttribute",
    NSAccessibilityClearButtonAttribute, @"NSAccessibilityClearButtonAttribute",
    NSAccessibilitySplittersAttribute, @"NSAccessibilitySplittersAttribute",
    NSAccessibilityDocumentAttribute, @"NSAccessibilityDocumentAttribute",
    NSAccessibilityOrientationAttribute, @"NSAccessibilityOrientationAttribute",
    NSAccessibilityRowsAttribute, @"NSAccessibilityRowsAttribute",
    NSAccessibilityVisibleRowsAttribute, @"NSAccessibilityVisibleRowsAttribute",
    NSAccessibilitySelectedRowsAttribute, @"NSAccessibilitySelectedRowsAttribute",
    NSAccessibilityColumnsAttribute, @"NSAccessibilityColumnsAttribute",
    NSAccessibilityVisibleColumnsAttribute, @"NSAccessibilityVisibleColumnsAttribute",
    NSAccessibilitySelectedColumnsAttribute, @"NSAccessibilitySelectedColumnsAttribute",
    NSAccessibilitySortDirectionAttribute, @"NSAccessibilitySortDirectionAttribute",
    NSAccessibilityDisclosingAttribute, @"NSAccessibilityDisclosingAttribute",
    NSAccessibilityDisclosedRowsAttribute, @"NSAccessibilityDisclosedRowsAttribute",
    NSAccessibilityDisclosedByRowAttribute, @"NSAccessibilityDisclosedByRowAttribute",

    // NSAccessibility\Exception Error Code Key
    NSAccessibilityErrorCodeExceptionInfo, @"NSAccessibilityErrorCodeExceptionInfo",

    // NSAccessibility\Orientations
    NSAccessibilityHorizontalOrientationValue, @"NSAccessibilityHorizontalOrientationValue",
    NSAccessibilityVerticalOrientationValue, @"NSAccessibilityVerticalOrientationValue",

    // NSAccessibility\Roles
    NSAccessibilityUnknownRole, @"NSAccessibilityUnknownRole",
    NSAccessibilityButtonRole, @"NSAccessibilityButtonRole",
    NSAccessibilityRadioButtonRole, @"NSAccessibilityRadioButtonRole",
    NSAccessibilityCheckBoxRole, @"NSAccessibilityCheckBoxRole",
    NSAccessibilitySliderRole, @"NSAccessibilitySliderRole",
    NSAccessibilityTabGroupRole, @"NSAccessibilityTabGroupRole",
    NSAccessibilityTextFieldRole, @"NSAccessibilityTextFieldRole",
    NSAccessibilityStaticTextRole, @"NSAccessibilityStaticTextRole",
    NSAccessibilityTextAreaRole, @"NSAccessibilityTextAreaRole",
    NSAccessibilityScrollAreaRole, @"NSAccessibilityScrollAreaRole",
    NSAccessibilityPopUpButtonRole, @"NSAccessibilityPopUpButtonRole",
    NSAccessibilityMenuButtonRole, @"NSAccessibilityMenuButtonRole",
    NSAccessibilityTableRole, @"NSAccessibilityTableRole",
    NSAccessibilityApplicationRole, @"NSAccessibilityApplicationRole",
    NSAccessibilityGroupRole, @"NSAccessibilityGroupRole",
    NSAccessibilityRadioGroupRole, @"NSAccessibilityRadioGroupRole",
    NSAccessibilityListRole, @"NSAccessibilityListRole",
    NSAccessibilityScrollBarRole, @"NSAccessibilityScrollBarRole",
    NSAccessibilityValueIndicatorRole, @"NSAccessibilityValueIndicatorRole",
    NSAccessibilityImageRole, @"NSAccessibilityImageRole",
    NSAccessibilityMenuBarRole, @"NSAccessibilityMenuBarRole",
    NSAccessibilityMenuRole, @"NSAccessibilityMenuRole",
    NSAccessibilityMenuItemRole, @"NSAccessibilityMenuItemRole",
    NSAccessibilityColumnRole, @"NSAccessibilityColumnRole",
    NSAccessibilityRowRole, @"NSAccessibilityRowRole",
    NSAccessibilityToolbarRole, @"NSAccessibilityToolbarRole",
    NSAccessibilityBusyIndicatorRole, @"NSAccessibilityBusyIndicatorRole",
    NSAccessibilityProgressIndicatorRole, @"NSAccessibilityProgressIndicatorRole",
    NSAccessibilityWindowRole, @"NSAccessibilityWindowRole",
    NSAccessibilityDrawerRole, @"NSAccessibilityDrawerRole",
    NSAccessibilitySystemWideRole, @"NSAccessibilitySystemWideRole",
    NSAccessibilityOutlineRole, @"NSAccessibilityOutlineRole",
    NSAccessibilityIncrementorRole, @"NSAccessibilityIncrementorRole",
    NSAccessibilityBrowserRole, @"NSAccessibilityBrowserRole",
    NSAccessibilityComboBoxRole, @"NSAccessibilityComboBoxRole",
    NSAccessibilitySplitGroupRole, @"NSAccessibilitySplitGroupRole",
    NSAccessibilitySplitterRole, @"NSAccessibilitySplitterRole",
    NSAccessibilityColorWellRole, @"NSAccessibilityColorWellRole",
    NSAccessibilityGrowAreaRole, @"NSAccessibilityGrowAreaRole",
    NSAccessibilitySheetRole, @"NSAccessibilitySheetRole",


    // NSAccessibility\Subroles
    NSAccessibilityUnknownSubrole, @"NSAccessibilityUnknownSubrole",
    NSAccessibilityCloseButtonSubrole, @"NSAccessibilityCloseButtonSubrole",
    NSAccessibilityZoomButtonSubrole, @"NSAccessibilityZoomButtonSubrole",
    NSAccessibilityMinimizeButtonSubrole, @"NSAccessibilityMinimizeButtonSubrole",
    NSAccessibilityToolbarButtonSubrole, @"NSAccessibilityToolbarButtonSubrole",
    NSAccessibilityTableRowSubrole, @"NSAccessibilityTableRowSubrole",
    NSAccessibilityOutlineRowSubrole, @"NSAccessibilityOutlineRowSubrole",
    NSAccessibilitySecureTextFieldSubrole, @"NSAccessibilitySecureTextFieldSubrole",
    NSAccessibilityStandardWindowSubrole, @"NSAccessibilityStandardWindowSubrole",
    NSAccessibilityDialogSubrole, @"NSAccessibilityDialogSubrole",
    NSAccessibilitySystemDialogSubrole, @"NSAccessibilitySystemDialogSubrole",
    NSAccessibilityFloatingWindowSubrole, @"NSAccessibilityFloatingWindowSubrole",
    NSAccessibilitySystemFloatingWindowSubrole, @"NSAccessibilitySystemFloatingWindowSubrole",
    NSAccessibilityIncrementArrowSubrole, @"NSAccessibilityIncrementArrowSubrole",
    NSAccessibilityDecrementArrowSubrole, @"NSAccessibilityDecrementArrowSubrole",
    NSAccessibilityIncrementPageSubrole, @"NSAccessibilityIncrementPageSubrole",
    NSAccessibilityDecrementPageSubrole, @"NSAccessibilityDecrementPageSubrole",
    NSAccessibilitySearchFieldSubrole, @"NSAccessibilitySearchFieldSubrole",

    // NSAttributedString\Attributes
    NSFontAttributeName, @"NSFontAttributeName",
    NSParagraphStyleAttributeName, @"NSParagraphStyleAttributeName",
    NSForegroundColorAttributeName, @"NSForegroundColorAttributeName",
    NSUnderlineStyleAttributeName, @"NSUnderlineStyleAttributeName",
    NSSuperscriptAttributeName, @"NSSuperscriptAttributeName",
    NSBackgroundColorAttributeName, @"NSBackgroundColorAttributeName",
    NSAttachmentAttributeName, @"NSAttachmentAttributeName",
    NSLigatureAttributeName, @"NSLigatureAttributeName",
    NSBaselineOffsetAttributeName, @"NSBaselineOffsetAttributeName",
    NSKernAttributeName, @"NSKernAttributeName",
    NSLinkAttributeName, @"NSLinkAttributeName",
    NSStrokeWidthAttributeName, @"NSStrokeWidthAttributeName",
    NSStrokeColorAttributeName, @"NSStrokeColorAttributeName",
    NSUnderlineColorAttributeName, @"NSUnderlineColorAttributeName",
    NSStrikethroughStyleAttributeName, @"NSStrikethroughStyleAttributeName",
    NSStrikethroughColorAttributeName, @"NSStrikethroughColorAttributeName",
    NSShadowAttributeName, @"NSShadowAttributeName",
    NSObliquenessAttributeName, @"NSObliquenessAttributeName",
    NSExpansionAttributeName, @"NSExpansionAttributeName",
    NSCursorAttributeName, @"NSCursorAttributeName",
    NSToolTipAttributeName, @"NSToolTipAttributeName",

    // NSAttributedString\Character Shape Attribute
    NSCharacterShapeAttributeName, @"NSCharacterShapeAttributeName",

    // NSAttributedString\Document Type
    NSPlainTextDocumentType, @"NSPlainTextDocumentType",
    NSRTFTextDocumentType, @"NSRTFTextDocumentType",
    NSRTFDTextDocumentType, @"NSRTFDTextDocumentType",
    NSMacSimpleTextDocumentType, @"NSMacSimpleTextDocumentType",
    NSHTMLTextDocumentType, @"NSHTMLTextDocumentType",
    NSDocFormatTextDocumentType, @"NSDocFormatTextDocumentType",
    NSWordMLTextDocumentType, @"NSWordMLTextDocumentType",

    // NSAttributedString\Glyph Info Attribute
    NSGlyphInfoAttributeName, @"NSGlyphInfoAttributeName",

    // NSAttributedString\Underline Masks
     PLNG2SINT(NSUnderlineByWordMask), @"NSUnderlineByWordMask",

    // NSBitmapImageRep\Attributes
    NSImageCompressionMethod, @"NSImageCompressionMethod", 
    NSImageCompressionFactor, @"NSImageCompressionFactor",
    NSImageDitherTransparency, @"NSImageDitherTransparency",
    NSImageRGBColorTable, @"NSImageRGBColorTable",
    NSImageInterlaced, @"NSImageInterlaced", 
    NSImageColorSyncProfileData, @"NSImageColorSyncProfileData",
    NSImageFrameCount, @"NSImageFrameCount",
    NSImageCurrentFrame, @"NSImageCurrentFrame",
    NSImageCurrentFrameDuration, @"NSImageCurrentFrameDuration",
    NSImageLoopCount, @"NSImageLoopCount",

    // NSColor\Grayscale Values
    PFLT2FLT(NSWhite), @"NSWhite",
    PFLT2FLT(NSLightGray), @"NSLightGray",
    PFLT2FLT(NSDarkGray), @"NSDarkGray",
    PFLT2FLT(NSBlack), @"NSBlack",

    // NSFont\Keys to the AFM Dictionary
    NSAFMFamilyName, @"NSAFMFamilyName",
    NSAFMFontName, @"NSAFMFontName",
    NSAFMFormatVersion, @"NSAFMFormatVersion",
    NSAFMFullName, @"NSAFMFullName",
    NSAFMNotice, @"NSAFMNotice",
    NSAFMVersion, @"NSAFMVersion",
    NSAFMWeight, @"NSAFMWeight",
    NSAFMEncodingScheme, @"NSAFMEncodingScheme",
    NSAFMCharacterSet, @"NSAFMCharacterSet",
    NSAFMCapHeight, @"NSAFMCapHeight",
    NSAFMXHeight, @"NSAFMXHeight",
    NSAFMAscender, @"NSAFMAscender",
    NSAFMDescender, @"NSAFMDescender",
    NSAFMUnderlinePosition, @"NSAFMUnderlinePosition",
    NSAFMUnderlineThickness, @"NSAFMUnderlineThickness",
    NSAFMItalicAngle, @"NSAFMItalicAngle",
    NSAFMMappingScheme, @"NSAFMMappingScheme",

    // NSFontDescriptor\Font Attributes
    NSFontFamilyAttribute, @"NSFontFamilyAttribute",
    NSFontNameAttribute, @"NSFontNameAttribute",
    NSFontFaceAttribute, @"NSFontFaceAttribute",
    NSFontSizeAttribute, @"NSFontSizeAttribute", 
    NSFontVisibleNameAttribute, @"NSFontVisibleNameAttribute", 
    NSFontColorAttribute, @"NSFontColorAttribute", 

    // NSGraphicsContext\Attributes
    NSGraphicsContextDestinationAttributeName, @"NSGraphicsContextDestinationAttributeName",
    NSGraphicsContextRepresentationFormatAttributeName, @"NSGraphicsContextRepresentationFormatAttributeName",
    NSGraphicsContextPSFormat, @"NSGraphicsContextPSFormat",
    NSGraphicsContextPDFFormat, @"NSGraphicsContextPDFFormat",

    // NSKeyValueBinding Markers
    NSMultipleValuesMarker, @"NSMultipleValuesMarker",
    NSNoSelectionMarker, @"NSNoSelectionMarker",
    NSNotApplicableMarker, @"NSNotApplicableMarker",


    // NSInterfaceStyleDefault
    NSInterfaceStyleDefault, @"NSInterfaceStyleDefault",

    // NSPasteboard\Names
    NSGeneralPboard, @"NSGeneralPboard",
    NSFontPboard, @"NSFontPboard",
    NSRulerPboard, @"NSRulerPboard",
    NSFindPboard, @"NSFindPboard",
    NSDragPboard, @"NSDragPboard",

    // NSPasteboard\Types for Sound Data
    NSSoundPboardType, @"NSSoundPboardType",

    // NSPasteboard\Types for Standard Data
    NSStringPboardType, @"NSStringPboardType",
    NSFilenamesPboardType, @"NSFilenamesPboardType",
    NSPostScriptPboardType, @"NSPostScriptPboardType",
    NSTIFFPboardType, @"NSTIFFPboardType",
    NSRTFPboardType, @"NSRTFPboardType",
    NSTabularTextPboardType, @"NSTabularTextPboardType",
    NSFontPboardType, @"NSFontPboardType",
    NSRulerPboardType, @"NSRulerPboardType",
    NSFileContentsPboardType, @"NSFileContentsPboardType",
    NSColorPboardType, @"NSColorPboardType",
    NSRTFDPboardType, @"NSRTFDPboardType",
    NSHTMLPboardType, @"NSHTMLPboardType",
    NSPICTPboardType, @"NSPICTPboardType",
    NSURLPboardType, @"NSURLPboardType",
    NSPDFPboardType, @"NSPDFPboardType",
    NSVCardPboardType, @"NSVCardPboardType",
    NSFilesPromisePboardType, @"NSFilesPromisePboardType",

    // NSPrintInfo\Dictionary Keys
    NSPrintPaperName, @"NSPrintPaperName",
    NSPrintPaperSize, @"NSPrintPaperSize",
    NSPrintMustCollate, @"NSPrintMustCollate",
    NSPrintOrientation, @"NSPrintOrientation",
    NSPrintLeftMargin, @"NSPrintLeftMargin",
    NSPrintRightMargin, @"NSPrintRightMargin",
    NSPrintTopMargin, @"NSPrintTopMargin",
    NSPrintBottomMargin, @"NSPrintBottomMargin",
    NSPrintHorizontallyCentered, @"NSPrintHorizontallyCentered",
    NSPrintVerticallyCentered, @"NSPrintVerticallyCentered",
    NSPrintHorizontalPagination, @"NSPrintHorizontalPagination",
    NSPrintVerticalPagination, @"NSPrintVerticalPagination",
    NSPrintScalingFactor, @"NSPrintScalingFactor",
    NSPrintAllPages, @"NSPrintAllPages",
    NSPrintReversePageOrder, @"NSPrintReversePageOrder",
    NSPrintFirstPage, @"NSPrintFirstPage",
    NSPrintLastPage, @"NSPrintLastPage",
    NSPrintCopies, @"NSPrintCopies",
    NSPrintPrinter, @"NSPrintPrinter",
    NSPrintJobDisposition, @"NSPrintJobDisposition",
    NSPrintSavePath, @"NSPrintSavePath",
    NSPrintSpoolJob, @"NSPrintSpoolJob",
    NSPrintPreviewJob, @"NSPrintPreviewJob",
    NSPrintSaveJob, @"NSPrintSaveJob",
    NSPrintCancelJob, @"NSPrintCancelJob",

    // NSPrintPanel\Job Style Hints
    NSPrintPhotoJobStyleHint, @"NSPrintPhotoJobStyleHint",

    // NSRunLoop\Modes
    NSModalPanelRunLoopMode, @"NSModalPanelRunLoopMode",
    NSEventTrackingRunLoopMode, @"NSEventTrackingRunLoopMode",

    // NSSearchFieldCell\Menu tags
    PLNG2SINT(NSSearchFieldRecentsTitleMenuItemTag),
                       @"NSSearchFieldRecentsTitleMenuItemTag",
    PLNG2SINT(NSSearchFieldRecentsMenuItemTag),
                       @"NSSearchFieldRecentsMenuItemTag",
    PLNG2SINT(NSSearchFieldClearRecentsMenuItemTag),
                       @"NSSearchFieldClearRecentsMenuItemTag",
    PLNG2SINT(NSSearchFieldNoRecentsMenuItemTag),
                       @"NSSearchFieldNoRecentsMenuItemTag",

    // NSSpeechSynthesizer\Voice Attributes
    NSVoiceName, @"NSVoiceName",
    NSVoiceIdentifier, @"NSVoiceIdentifier",
    NSVoiceAge, @"NSVoiceAge",
    NSVoiceGender, @"NSVoiceGender",
    NSVoiceDemoText, @"NSVoiceDemoText",
    NSVoiceLanguage, @"NSVoiceLanguage",

    // NSSpeechSynthesizer\Voice Genders
    NSVoiceGenderNeuter, @"NSVoiceGenderNeuter",
    NSVoiceGenderMale, @"NSVoiceGenderMale",
    NSVoiceGenderFemale, @"NSVoiceGenderFemale",

    // NSTabColumnTerminatorsAttributeName
    NSTabColumnTerminatorsAttributeName, @"NSTabColumnTerminatorsAttributeName",

    // NSToolbarItem\Standard Identifiers
    NSToolbarSeparatorItemIdentifier, @"NSToolbarSeparatorItemIdentifier",
    NSToolbarSpaceItemIdentifier, @"NSToolbarSpaceItemIdentifier",
    NSToolbarFlexibleSpaceItemIdentifier, @"NSToolbarFlexibleSpaceItemIdentifier",
    NSToolbarShowColorsItemIdentifier, @"NSToolbarShowColorsItemIdentifier",
    NSToolbarShowFontsItemIdentifier, @"NSToolbarShowFontsItemIdentifier",
    NSToolbarCustomizeToolbarItemIdentifier, @"NSToolbarCustomizeToolbarItemIdentifier",
    NSToolbarPrintItemIdentifier, @"NSToolbarPrintItemIdentifier",

    // NSWindow\Window Levels
    NSNormalWindowLevel, @"NSNormalWindowLevel",
    NSFloatingWindowLevel, @"NSFloatingWindowLevel",
    NSSubmenuWindowLevel, @"NSSubmenuWindowLevel",
    NSTornOffMenuWindowLevel, @"NSTornOffMenuWindowLevel",
    NSMainMenuWindowLevel, @"NSMainMenuWindowLevel",
    NSStatusWindowLevel, @"NSStatusWindowLevel",
    NSModalPanelWindowLevel, @"NSModalPanelWindowLevel",
    NSPopUpMenuWindowLevel, @"NSPopUpMenuWindowLevel",
    NSScreenSaverWindowLevel, @"NSScreenSaverWindowLevel",

    // NSWorkspace\File Operation Constants
    NSWorkspaceMoveOperation, @"NSWorkspaceMoveOperation",
    NSWorkspaceCopyOperation, @"NSWorkspaceCopyOperation",
    NSWorkspaceLinkOperation, @"NSWorkspaceLinkOperation",
    NSWorkspaceCompressOperation, @"NSWorkspaceCompressOperation",
    NSWorkspaceDecompressOperation, @"NSWorkspaceDecompressOperation",
    NSWorkspaceEncryptOperation, @"NSWorkspaceEncryptOperation",
    NSWorkspaceDecryptOperation, @"NSWorkspaceDecryptOperation",
    NSWorkspaceDestroyOperation, @"NSWorkspaceDestroyOperation",
    NSWorkspaceRecycleOperation, @"NSWorkspaceRecycleOperation",
    NSWorkspaceDuplicateOperation, @"NSWorkspaceDuplicateOperation",

    // NSWorkspace\File Types
    NSPlainFileType, @"NSPlainFileType",
    NSDirectoryFileType, @"NSDirectoryFileType",
    NSApplicationFileType, @"NSApplicationFileType",
    NSFilesystemFileType, @"NSFilesystemFileType",
    NSShellCommandFileType, @"NSShellCommandFileType",

    // Notifications
    // NSAccessibility\Notification Names
    NSAccessibilityMainWindowChangedNotification, @"NSAccessibilityMainWindowChangedNotification",
    NSAccessibilityFocusedUIElementChangedNotification, @"NSAccessibilityFocusedUIElementChangedNotification",
    NSAccessibilityApplicationActivatedNotification, @"NSAccessibilityApplicationActivatedNotification",
    NSAccessibilityApplicationDeactivatedNotification, @"NSAccessibilityApplicationDeactivatedNotification",
    NSAccessibilityApplicationHiddenNotification, @"NSAccessibilityApplicationHiddenNotification",
    NSAccessibilityApplicationShownNotification, @"NSAccessibilityApplicationShownNotification",
    NSAccessibilityWindowCreatedNotification, @"NSAccessibilityWindowCreatedNotification",
    NSAccessibilityWindowMovedNotification, @"NSAccessibilityWindowMovedNotification",
    NSAccessibilityWindowResizedNotification, @"NSAccessibilityWindowResizedNotification",
    NSAccessibilityWindowMiniaturizedNotification, @"NSAccessibilityWindowMiniaturizedNotification",
    NSAccessibilityWindowDeminiaturizedNotification, @"NSAccessibilityWindowDeminiaturizedNotification",
    NSAccessibilityValueChangedNotification, @"NSAccessibilityValueChangedNotification",
    NSAccessibilityUIElementDestroyedNotification, @"NSAccessibilityUIElementDestroyedNotification",
    NSAccessibilityDrawerCreatedNotification, @"NSAccessibilityDrawerCreatedNotification",
    NSAccessibilitySheetCreatedNotification, @"NSAccessibilitySheetCreatedNotification",

    // NSApplication Notification Names
    NSApplicationDidBecomeActiveNotification, @"NSApplicationDidBecomeActiveNotification",
    NSApplicationDidFinishLaunchingNotification, @"NSApplicationDidFinishLaunchingNotification",
    NSApplicationDidHideNotification, @"NSApplicationDidHideNotification",
    NSApplicationDidResignActiveNotification, @"NSApplicationDidResignActiveNotification",
    NSApplicationDidUnhideNotification, @"NSApplicationDidUnhideNotification",
    NSApplicationDidUpdateNotification, @"NSApplicationDidUpdateNotification",
    NSApplicationWillBecomeActiveNotification, @"NSApplicationWillBecomeActiveNotification",
    NSApplicationWillFinishLaunchingNotification, @"NSApplicationWillFinishLaunchingNotification",
    NSApplicationWillHideNotification, @"NSApplicationWillHideNotification",
    NSApplicationWillResignActiveNotification, @"NSApplicationWillResignActiveNotification",
    NSApplicationWillUnhideNotification, @"NSApplicationWillUnhideNotification",
    NSApplicationWillUpdateNotification, @"NSApplicationWillUpdateNotification",
    NSApplicationWillTerminateNotification, @"NSApplicationWillTerminateNotification",
    NSApplicationDidChangeScreenParametersNotification, @"NSApplicationDidChangeScreenParametersNotification",

    // NSBrowser Notification Names
    NSBrowserColumnConfigurationDidChangeNotification, @"NSBrowserColumnConfigurationDidChangeNotification",

    // NSCell Notification Names
    NSControlTintDidChangeNotification, @"NSControlTintDidChangeNotification",

    // NSColor Notification Names
    NSSystemColorsDidChangeNotification, @"NSSystemColorsDidChangeNotification",

    // NSColorList Notification Names
    NSColorListDidChangeNotification, @"NSColorListDidChangeNotification",

    // NSColorPanel Notification Names
    NSColorPanelColorDidChangeNotification, @"NSColorPanelColorDidChangeNotification",

    // NSComboBox Notification Names
    NSComboBoxWillPopUpNotification, @"NSComboBoxWillPopUpNotification",
    NSComboBoxWillDismissNotification, @"NSComboBoxWillDismissNotification",
    NSComboBoxSelectionDidChangeNotification, @"NSComboBoxSelectionDidChangeNotification",
    NSComboBoxSelectionIsChangingNotification, @"NSComboBoxSelectionIsChangingNotification",

    // NSControl Notification Names
    NSControlTextDidBeginEditingNotification, @"NSControlTextDidBeginEditingNotification",
    NSControlTextDidEndEditingNotification, @"NSControlTextDidEndEditingNotification",
    NSControlTextDidChangeNotification, @"NSControlTextDidChangeNotification",

    // NSDrawer Notification Names
    NSDrawerWillOpenNotification, @"NSDrawerWillOpenNotification", 
    NSDrawerDidOpenNotification, @"NSDrawerDidOpenNotification",
    NSDrawerWillCloseNotification, @"NSDrawerWillCloseNotification",
    NSDrawerDidCloseNotification, @"NSDrawerDidCloseNotification",

    // NSHelpManager Notification Names
    NSContextHelpModeDidActivateNotification, @"NSContextHelpModeDidActivateNotification",
    NSContextHelpModeDidDeactivateNotification, @"NSContextHelpModeDidDeactivateNotification",

    // NSImageRep Notification Names
    NSImageRepRegistryDidChangeNotification, @"NSImageRepRegistryDidChangeNotification",

    // NSMenu Notification Names
    NSMenuWillSendActionNotification, @"NSMenuWillSendActionNotification",
    NSMenuDidSendActionNotification, @"NSMenuDidSendActionNotification",
    NSMenuDidAddItemNotification, @"NSMenuDidAddItemNotification",
    NSMenuDidRemoveItemNotification, @"NSMenuDidRemoveItemNotification",
    NSMenuDidChangeItemNotification, @"NSMenuDidChangeItemNotification",

    // NSOutlineView Notification Names
    NSOutlineViewSelectionDidChangeNotification, @"NSOutlineViewSelectionDidChangeNotification", 
    NSOutlineViewColumnDidMoveNotification, @"NSOutlineViewColumnDidMoveNotification",
    NSOutlineViewColumnDidResizeNotification, @"NSOutlineViewColumnDidResizeNotification",
    NSOutlineViewSelectionIsChangingNotification, @"NSOutlineViewSelectionIsChangingNotification",
    NSOutlineViewItemWillExpandNotification, @"NSOutlineViewItemWillExpandNotification",
    NSOutlineViewItemDidExpandNotification, @"NSOutlineViewItemDidExpandNotification",
    NSOutlineViewItemWillCollapseNotification, @"NSOutlineViewItemWillCollapseNotification",
    NSOutlineViewItemDidCollapseNotification, @"NSOutlineViewItemDidCollapseNotification",

    // NSPopUpButton Notification Names
    NSPopUpButtonWillPopUpNotification, @"NSPopUpButtonWillPopUpNotification",

    // NSPopUpButtonCell Notification Names
    NSPopUpButtonCellWillPopUpNotification, @"NSPopUpButtonCellWillPopUpNotification",

    // NSSplitView Notification Names
    NSSplitViewDidResizeSubviewsNotification, @"NSSplitViewDidResizeSubviewsNotification",
    NSSplitViewWillResizeSubviewsNotification, @"NSSplitViewWillResizeSubviewsNotification",

    // NSTableView Notification Names
    NSTableViewSelectionDidChangeNotification, @"NSTableViewSelectionDidChangeNotification",
    NSTableViewColumnDidMoveNotification, @"NSTableViewColumnDidMoveNotification",
    NSTableViewColumnDidResizeNotification, @"NSTableViewColumnDidResizeNotification",
    NSTableViewSelectionIsChangingNotification, @"NSTableViewSelectionIsChangingNotification",

    // NSText Notification Names
    NSTextDidBeginEditingNotification, @"NSTextDidBeginEditingNotification",
    NSTextDidEndEditingNotification, @"NSTextDidEndEditingNotification",
    NSTextDidChangeNotification, @"NSTextDidChangeNotification",

    // NSTextStorage Notification Names
    NSTextStorageWillProcessEditingNotification, @"NSTextStorageWillProcessEditingNotification",
    NSTextStorageDidProcessEditingNotification, @"NSTextStorageDidProcessEditingNotification",

    // NSTextView Notification Names
    NSTextViewWillChangeNotifyingTextViewNotification, @"NSTextViewWillChangeNotifyingTextViewNotification",
    NSTextViewDidChangeSelectionNotification, @"NSTextViewDidChangeSelectionNotification",
    NSTextViewDidChangeTypingAttributesNotification, @"NSTextViewDidChangeTypingAttributesNotification",

    // NSToolbar Notification Names
    NSToolbarWillAddItemNotification, @"NSToolbarWillAddItemNotification",
    NSToolbarDidRemoveItemNotification, @"NSToolbarDidRemoveItemNotification",

    // NSView Notification Names
    NSViewFrameDidChangeNotification, @"NSViewFrameDidChangeNotification",
    NSViewFocusDidChangeNotification, @"NSViewFocusDidChangeNotification",
    NSViewBoundsDidChangeNotification, @"NSViewBoundsDidChangeNotification",
    NSViewGlobalFrameDidChangeNotification, @"NSViewGlobalFrameDidChangeNotification",

    // NSWindow Notification Names
    NSWindowDidBecomeKeyNotification, @"NSWindowDidBecomeKeyNotification",
    NSWindowDidBecomeMainNotification, @"NSWindowDidBecomeMainNotification",
    NSWindowDidChangeScreenNotification, @"NSWindowDidChangeScreenNotification",
    NSWindowDidDeminiaturizeNotification, @"NSWindowDidDeminiaturizeNotification",
    NSWindowDidExposeNotification, @"NSWindowDidExposeNotification",
    NSWindowDidMiniaturizeNotification, @"NSWindowDidMiniaturizeNotification",
    NSWindowDidMoveNotification, @"NSWindowDidMoveNotification",
    NSWindowDidResignKeyNotification, @"NSWindowDidResignKeyNotification",
    NSWindowDidResignMainNotification, @"NSWindowDidResignMainNotification",
    NSWindowDidResizeNotification, @"NSWindowDidResizeNotification",
    NSWindowDidUpdateNotification, @"NSWindowDidUpdateNotification",
    NSWindowWillCloseNotification, @"NSWindowWillCloseNotification",
    NSWindowWillMiniaturizeNotification, @"NSWindowWillMiniaturizeNotification",
    NSWindowWillMoveNotification, @"NSWindowWillMoveNotification",
    NSWindowWillBeginSheetNotification, @"NSWindowWillBeginSheetNotification",
    NSWindowDidEndSheetNotification, @"NSWindowDidEndSheetNotification",

    // NSWorkspace Notification Names
    NSWorkspaceDidLaunchApplicationNotification, @"NSWorkspaceDidLaunchApplicationNotification",
    NSWorkspaceDidMountNotification, @"NSWorkspaceDidMountNotification",
    NSWorkspaceDidPerformFileOperationNotification, @"NSWorkspaceDidPerformFileOperationNotification",
    NSWorkspaceDidTerminateApplicationNotification, @"NSWorkspaceDidTerminateApplicationNotification",
    NSWorkspaceDidUnmountNotification, @"NSWorkspaceDidUnmountNotification",
    NSWorkspaceWillLaunchApplicationNotification, @"NSWorkspaceWillLaunchApplicationNotification",
    NSWorkspaceWillPowerOffNotification, @"NSWorkspaceWillPowerOffNotification",
    NSWorkspaceWillUnmountNotification, @"NSWorkspaceWillUnmountNotification",
    NSWorkspaceWillSleepNotification, @"NSWorkspaceWillSleepNotification",
    NSWorkspaceDidWakeNotification, @"NSWorkspaceDidWakeNotification",
    NSWorkspaceSessionDidBecomeActiveNotification, @"NSWorkspaceSessionDidBecomeActiveNotification",
    NSWorkspaceSessionDidResignActiveNotification, @"NSWorkspaceSessionDidResignActiveNotification",

    // Exceptions
    // Application Kit Exception Names
    NSTextLineTooLongException, @"NSTextLineTooLongException",
    NSTextNoSelectionException, @"NSTextNoSelectionException",
    NSWordTablesWriteException, @"NSWordTablesWriteException",
    NSWordTablesReadException, @"NSWordTablesReadException",
    NSTextReadException, @"NSTextReadException",
    NSTextWriteException, @"NSTextWriteException",
    NSPasteboardCommunicationException, @"NSPasteboardCommunicationException",
    NSPrintingCommunicationException, @"NSPrintingCommunicationException",
    NSAbortModalException, @"NSAbortModalException",
    NSAbortPrintingException, @"NSAbortPrintingException",
    NSIllegalSelectorException, @"NSIllegalSelectorException",
    NSAppKitVirtualMemoryException, @"NSAppKitVirtualMemoryException",
    NSBadRTFDirectiveException, @"NSBadRTFDirectiveException",
    NSBadRTFFontTableException, @"NSBadRTFFontTableException",
    NSBadRTFStyleSheetException, @"NSBadRTFStyleSheetException",
    NSTypedStreamVersionException, @"NSTypedStreamVersionException",
    NSTIFFException, @"NSTIFFException",
    NSPrintPackageException, @"NSPrintPackageException",
    NSBadRTFColorTableException, @"NSBadRTFColorTableException",
    NSDraggingException, @"NSDraggingException",
    NSColorListIOException, @"NSColorListIOException",
    NSColorListNotEditableException, @"NSColorListNotEditableException",
    NSBadBitmapParametersException, @"NSBadBitmapParametersException",
    NSWindowServerCommunicationException, @"NSWindowServerCommunicationException",
    NSFontUnavailableException, @"NSFontUnavailableException",
    NSPPDIncludeNotFoundException, @"NSPPDIncludeNotFoundException",
    NSPPDParseException, @"NSPPDParseException",
    NSPPDIncludeStackOverflowException, @"NSPPDIncludeStackOverflowException",
    NSPPDIncludeStackUnderflowException, @"NSPPDIncludeStackUnderflowException",
    NSRTFPropertyStackOverflowException, @"NSRTFPropertyStackOverflowException",
    NSAppKitIgnoredException, @"NSAppKitIgnoredException",
    NSBadComparisonException, @"NSBadComparisonException",
    NSImageCacheException, @"NSImageCacheException",
    NSNibLoadingException, @"NSNibLoadingException",
    NSBrowserIllegalDelegateException, @"NSBrowserIllegalDelegateException",
    NSAccessibilityException, @"NSAccessibilityException",

    // NSPrintOperation Exception Names
    NSPrintOperationExistsException, @"NSPrintOperationExistsException",

    nil];
}

@end
