#import "common.h"
#import "CMDigitNode.h"


@implementation CMDigitNode

+ (id)nodeWithString:(NSString *)aString
{
  return [[[self alloc] initWithString:aString] autorelease];
}

- (id)initWithString:(NSString *)aString
{
  [self init];
  digitString = [[NSString alloc] initWithString:aString];
  return self;
}

- (void)dealloc
{
  [digitString release];
  [super dealloc];
}

- (NSString *)digitString { return digitString; }

- (NSString *)ownDescription
{
  return digitString;
}

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitDigitNode");
  [aVisitor visitDigitNode:self];
  LOG(@"<== visitDigitNode");
}

@end
