#import <Cocoa/Cocoa.h>
#import "CMVariableStore.h"

#define CMExceptionKey  @"CMExceptionKey"
#define CMFileNameKey    @"CMFileNameKey"
#define CMLineNumberKey  @"CMLineNumberKey"
#define CMExceptionsKey  @"CMExceptionsKey"
#define CMMethodNameKey  @"CMMethodNameKey"
#define CMSyntaxExceptionName @"CMSyntaxException"
#define CMSyntaxExceptionReason @"syntax error"
#define CMSenderKey @"sender"

@class CMMethod, CMVariable, CMBlock, CMNode;

@interface CMContext : CMVariableStore {
  id sender, receiver, returnValue, objectToResume, visitor;
  CMNode *node, *resumePoint;
  CMBlock *blockToRetry;
  CMMethod *method;
  NSArray *args;
  NSString *currentFileName;
  int currentLineNumber, preLineNumber;
  BOOL continuesVisitation, passesException, doesRetry, isSuspended;
  CMVariable *returnVariable;
}

//
// managing context
//

+ (id)sender;
+ (void)setSender:(id)aSender;
+ (void)revertSender;
+ (id)setInstanceMethodSenderWithReceiver:(id)aReceiver
                                arguments:(NSArray *)arguments
                                 selector:(SEL)aSelector
                                 forClass:(Class)aClass;
+ (id)setClassMethodSenderWithReceiver:(id)aReceiver
                              arguments:(NSArray *)arguments
                               selector:(SEL)aSelector
                               forClass:(Class)aClass;
+ (id)setSenderWithReceiver:(id)aReceiver
                  arguments:(NSArray *)arguments
                   selector:(SEL)aSelector
                   forClass:(Class)aClass
           isInstanceMethod:(BOOL)flag;
+ (void)flushSender;
- (void)registerSender;


+ (id)contextWithSender:(id)aSender
               receiver:(id)aReceiver
                 method:(id)aMethod
              arguments:(NSArray *)arguments;

- (id)initWithSender:(id)aSender
            receiver:(id)aReceiver
              method:(id)aMethod
           arguments:(NSArray *)arguments;

// metaclass or metaobject
- (id)metaObject;

- (id)sender;
- (void)setSender:(id)aSender;
- (id)receiver;
- (void)setReceiver:(id)anReceiver;
- (id)methodReceiver;
- (NSArray *)arguments;
- (void)setArguments:(NSArray *)objects;
- (CMMethod *)method;
- (CMNode *)node;
- (void)setNode:(CMNode *)aNode;
- (CMNode *)resumePoint;
- (void)setResumePoint:(CMNode *)aNode;

- (BOOL)continuesVisitation;
- (void)setContinuesVisitation:(BOOL)flag;
- (void)setContinuesVisitationForMethodContext:(BOOL)flag;
- (BOOL)passesException;
- (void)setPassesException:(BOOL)flag;
- (BOOL)doesRetry;
- (void)setDoesRetry:(BOOL)flag;
- (CMBlock *)blockToRetry;
- (void)setBlockToRetry:(CMBlock *)aBlock;
- (BOOL)isSuspended;
- (void)setIsSuspended:(BOOL)flag;
- (id)objectToResume;
- (void)setObjectToResume:(id)anObject;
- (CMVariable *)returnVariable;
- (void)setReturnVariable:(id)aVariable;
- (id)returnValue;
- (void)setReturnValue:(id)aValue;
- (unsigned int)numberOfArguments;
- (void)clearFlags;

- (void)evaluate;
- (void)stop;
- (void)resume;

- (NSString *)currentFileName;
- (void)setCurrentFileName:(NSString *)aName;

- (int)currentLineNumber;
- (void)setCurrentLineNumber:(int)number;
- (void)incrementCurrentLineNumber;
- (void)incrementCurrentLineNumberWithLength:(unsigned int)length;
- (void)decrementCurrentLineNumber;
- (void)clearCurrentLineNumber;

- (void)displayException:(NSException *)anException;
- (NSArray *)stacktracesWithException:(NSException *)anException;
+ (NSString *)errorStringWithFileName:(NSString *)fileName
                                 line:(int)lineNumber
                           methodName:(NSString *)methodName
                        exceptionName:(NSString *)exceptionName
                      exceptionReason:(NSString *)exceptionReason;
+ (NSString *)errorStringWithFileName:(NSString *)fileName
                                 line:(int)lineNumber
                           methodName:(NSString *)methodName;

- (void)raiseSyntaxException;
- (NSMutableDictionary *)userInfo;
- (NSMutableDictionary *)preLineUserInfo;

@end

