#import "common.h"
#import "CMClassNode.h"
#import "CMNodeVisitor.h"
#import "CMClass.h"
#import "CMContext.h"

@implementation CMClassNode

- (void)dealloc
{
  [name release];
  [super dealloc];
}

- (NSString *)name { return name; }

- (void)setName:(NSString *)aName
{
  [aName retain];
  [name release];
  name = aName;
}

- (NSString *)superclassName { return superclassName; }

- (void)setSuperclassName:(NSString *)aName
{
  [aName retain];
  [superclassName release];
  superclassName = aName;
}

- (CMClass *)metaClass
{
  return [CMClass classNamed:name];
}

- (BOOL)isNamed
{
  return ((name != nil) && (superclassName != nil));
}

- (NSString *)ownDescription
{
  return [NSString stringWithFormat:@"%@:%@", name, superclassName];
}

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitClassNode");
  [aVisitor visitClassNode:self];
  LOG(@"<== visitClassNode");
}

- (NSString *)comment { return comment; }
- (void)setComment:(NSString *)aComment { ASSIGN(comment, aComment); }

// generate source code
- (NSString *)sourceCode
{
  return nil;
}

@end
