#import "common.h"
#import "CMClass.h"
#import "CMMethod.h"
#import "CMObjCMethod.h"
#import "CMVariable.h"
#import <objc/objc-runtime.h>

static NSMutableDictionary *classDict = nil;

@implementation CMClass

+ (NSMutableDictionary *)classDictionary
{
  if (classDict == nil)
    classDict = [[NSMutableDictionary alloc] init];
  return classDict;
}

+ (id)classNamed:(NSString *)aName
{
  id obj, existClass;
  obj = [[self classDictionary] objectForKey:aName];
  if ((obj == nil) &&
      ((existClass = NSClassFromString(aName)) != nil)) {
    obj = [[self alloc] initWithClass:existClass];
  }
  return obj;
}

+ (id)classForObject:(id)anObject
{
  return [self classNamed:NSStringFromClass([anObject class])];
}

+ (id)classForClass:(Class)aClass
{
  return [self classNamed:NSStringFromClass(aClass)];
}

+ (void)addClass:(CMClass *)aClass
{
  [[self classDictionary]
    setObject:aClass forKey:[aClass name]];
}

+ (id)addClassWithName:(NSString *)aName
        superclassName:(NSString *)aSuperclassName
{
  id obj = [[CMClass alloc] initWithName:aName
                            superclassName:aSuperclassName];
  [self addClass:obj];
  return obj;
}


- (id)init
{
  [super init];
  classVariableNames = [[NSMutableArray alloc] initWithCapacity:1];
  instanceVariableNames = [[NSMutableArray alloc] initWithCapacity:1];
  classMethods = [[NSMutableDictionary alloc] initWithCapacity:1];
  instanceMethods = [[NSMutableDictionary alloc] initWithCapacity:1];
  return self;
}

- (id)initWithClass:(Class)aClass
{
  [self init];
  objCClass = aClass;
  return self;
}

- (id)initWithName:(NSString *)aName
    superclassName:(NSString *)aSuperclassName
{
  [self init];

  Class isRegisterd = NSClassFromString(aName);
  [self registerWithName:aName superclassName:aSuperclassName];
  objCClass = NSClassFromString(aName);

  if (!isRegisterd) {
    [self addInstanceMethod:[CMObjCMethod deallocMethod]];
    [self addInstanceMethod:[CMObjCMethod valueForKeyMethod]];
    [self addInstanceMethod:[CMObjCMethod setValueForKeyMethod]];
  }

  return self;
    
}
    
- (void)registerWithName:(NSString *)aName
          superclassName:(NSString *)aSuperclassName
{
  struct objc_class *meta_class;
  struct objc_class *super_class;
  struct objc_class *new_class;
  struct objc_class *root_class;
  const char *name = [aName cString];
  const char *superclassName = [aSuperclassName cString];
    
  //
  // Ensure that the superclass exists and that someone
  // hasn't already implemented a class with the same name
  //
  super_class = (struct objc_class *)objc_lookUpClass (superclassName);
  if (super_class == nil)
    {
      return;
    }
        
  if (objc_lookUpClass (name) != nil) 
    {
      return;
    }

  // Find the root class
  root_class = super_class;
  while( root_class->super_class != nil )
    {
      root_class = root_class->super_class;
    }
  // Allocate space for the class and its metaclass
  new_class = calloc(2, sizeof(struct objc_class));
  meta_class = &new_class[1];

  // setup class
  new_class->isa      = meta_class;
  new_class->info     = CLS_CLASS;
  meta_class->info    = CLS_META;
  //
  // Create a copy of the class name.
  // For efficiency, we have the metaclass and the class itself 
  // to share this copy of the name, but this is not a requirement
  // imposed by the runtime.
  //
  new_class->name = malloc(strlen (name) + 1);
  strcpy ((char*)new_class->name, name);
  meta_class->name = new_class->name;

  //
  // Allocate empty method lists.
  // We can add methods later.
  //
  new_class->methodLists = calloc( 1, sizeof(struct objc_method_list *));
  *new_class->methodLists = -1;
  meta_class->methodLists = calloc( 1, sizeof(struct objc_method_list *));
  *meta_class->methodLists = -1;

  //
  // Connect the class definition to the class hierarchy:
  // Connect the class to the superclass.
  // Connect the metaclass to the metaclass of the superclass.
  // Connect the metaclass of the metaclass to
  //      the metaclass of the root class.
  new_class->super_class  = super_class;
  meta_class->super_class = super_class->isa;
  meta_class->isa         = (void *)root_class->isa;

  // Finally, register the class with the runtime.
  objc_addClass( new_class ); 
}

- (void)addClassMethod:(CMMethod *)aMethod
{
  [self addMethod:aMethod withIsInstanceMethod:NO];
}

- (void)addInstanceMethod:(CMMethod *)aMethod
{
  [self addMethod:aMethod withIsInstanceMethod:YES];
}

- (void)addMethod:(CMMethod *)aMethod withIsInstanceMethod:(BOOL)flag
{
  struct objc_method_list *list;
  list = calloc(1, sizeof(struct objc_method_list)+sizeof(struct objc_method));
  list->method_count = 1;
  list->method_list[0] = *[aMethod objCMethod];
  if (flag == YES) {
    [instanceMethods setObject:aMethod forKey:[aMethod name]];
    class_addMethods(objCClass, list);
    LOG(@"* add method -[%@ %@]", objCClass, [aMethod name]);
  } else {
    [classMethods setObject:aMethod forKey:[aMethod name]];
    class_addMethods(objCClass->isa, list);
    LOG(@"* add method +[%@ %@]", objCClass, [aMethod name]);
  }
}

- (void)addClassVariableName:(NSString *)aName
{
  CMVariable *variable = [CMVariable variableWithName:aName];
  if (![classVariableNames containsObject:aName]) {
    [classVariableNames addObject:aName];
    [self addClassMethod:[variable getterMethodForInstanceVariable]];
    [self addClassMethod:[variable setterMethodForInstanceVariable]];
  }
}

- (void)addInstanceVariableName:(NSString *)aName
{
  CMVariable *variable = [CMVariable variableWithName:aName];
  if (![instanceVariableNames containsObject:aName]) {
    [instanceVariableNames addObject:aName];
    [self addInstanceMethod:[variable getterMethodForInstanceVariable]];
    [self addInstanceMethod:[variable setterMethodForInstanceVariable]];
  }
}

- (NSString *)name { return NSStringFromClass(objCClass); }
- (NSString *)description { return [self name]; }
- (Class)objCClass { return objCClass; }
- (NSArray *)classVariableNames { return classVariableNames; }
- (NSArray *)instanceVariableNames { return instanceVariableNames; }

- (CMMethod *)classMethodNamed:(NSString *)aName
{
  return [classMethods objectForKey:aName];
}

- (CMMethod *)instanceMethodNamed:(NSString *)aName
{
  return [instanceMethods objectForKey:aName];
}

- (void)dealloc
{
  [classVariableNames release];
  [instanceVariableNames release];
  [classMethods release];
  [instanceMethods release];
  [super dealloc];
}

@end
