#import <Foundation/Foundation.h>
#import "CMSourceCode.h"

@class CMMethod;

@interface CMClass : NSObject <CMSourceCode> {
    Class objCClass;
    NSMutableArray *classVariableNames, *instanceVariableNames;
    NSMutableDictionary *classMethods, *instanceMethods;
}

+ (NSMutableDictionary *)classDictionary;
+ (id)classNamed:(NSString *)aName;
+ (id)classForObject:(id)anObject;
+ (id)classForClass:(Class)aClass;
+ (void)addClass:(CMClass *)aClass;
+ (id)addClassWithName:(NSString *)aName
        superclassName:(NSString *)aSuperclassName;

- (id)init;
- (id)initWithClass:(Class)aClass;
- (id)initWithName:(NSString *)aName
superclassName:(NSString *)aSuperclassName;

- (void)registerWithName:(NSString *)aName
superclassName:(NSString *)aSuperclassName;
- (void)addClassMethod:(CMMethod *)aMethod;
- (void)addInstanceMethod:(CMMethod *)aMethod;
- (void)addMethod:(CMMethod *)aMethod withIsInstanceMethod:(BOOL)flag;
- (void)addClassVariableName:(NSString *)aName;
- (void)addInstanceVariableName:(NSString *)aName;

- (NSString *)name;
- (NSString *)description;
- (Class)objCClass;
- (NSArray *)classVariableNames;
- (NSArray *)instanceVariableNames;
- (CMMethod *)classMethodNamed:(NSString *)aName;
- (CMMethod *)instanceMethodNamed:(NSString *)aName;

- (void)dealloc;

@end
