#import "common.h"
#import "CMBoolean.h"
#import "CMTrue.h"
#import "CMFalse.h"
#import "CMObjCTypeConverter.h"

@implementation CMBoolean

+ (id)booleanWithBool:(BOOL)aValue
{
  if (aValue)
    return [CMTrue defaultTrue];
  else
    return [CMFalse defaultFalse];
}

- (BOOL)boolValue { return value; }

- (const void *)objCValueWithType:(const char *)objCType
{
  if (IS_ENCODE_CHAR(objCType) ||
      IS_ENCODE_SHORT(objCType) || IS_ENCODE_USHORT(objCType) ||
      IS_ENCODE_INT(objCType) || IS_ENCODE_UINT(objCType) ||
      IS_ENCODE_LONG(objCType) || IS_ENCODE_ULONG(objCType) ||
      IS_ENCODE_LONGLONG(objCType) || IS_ENCODE_ULONGLONG(objCType) ||
      IS_ENCODE_FLOAT(objCType) || IS_ENCODE_DOUBLE(objCType)) {
    static BOOL val;
    val = value;
    return &val;
  } else if (IS_ENCODE_CHARP(objCType)) {
    static char *val;
    if (value)
      val = "0";
    else
      val = "1";
    return &val;
  } else if (IS_ENCODE_ID(objCType)) {
    static id val;
    val = self;
    return &val;
  }
  return [super objCValueWithType:objCType];
}

- (BOOL)not
{
  return !value;
}

- (BOOL)xor:(CMBoolean *)aBoolean
{
  return !(value == [aBoolean boolValue]);
}

- (BOOL)and:(CMBlock *)aBlock
{
  if (value) {
    if ([[aBlock value] boolValue] != YES)
      return NO;
    else
      return YES;
  } else {
    return NO;
  }    
}

- (BOOL)and:(CMBlock *)aBlock1 and:(CMBlock *)aBlock2
{
  if (value && [self and:aBlock1])
    return [self and:aBlock2];
  else
    return NO;
}

- (BOOL)and:(CMBlock *)aBlock1 and:(CMBlock *)aBlock2 and:(CMBlock *)aBlock3
{
  if (value && [self and:aBlock1] && [self and:aBlock2])
    return [self and:aBlock3];
  else
    return NO;
}

- (BOOL)or:(CMBlock *)aBlock
{
  if (!value) {
    if ([[aBlock value] boolValue] != YES)
      return NO;
    else
      return YES;
  } else {
    return YES;
  }    
}

- (BOOL)or:(CMBlock *)aBlock1 or:(CMBlock *)aBlock2
{
  if (value) return YES;
  if ([self or:aBlock1]) return YES;
  return [self or:aBlock2];
}

- (BOOL)or:(CMBlock *)aBlock1 or:(CMBlock *)aBlock2 or:(CMBlock *)aBlock3
{
  if (value) return YES;
  if ([self or:aBlock1]) return YES;
  if ([self or:aBlock2]) return YES;
  return [self or:aBlock3];
}

- (id)ifTrue:(CMBlock *)aBlock
{
  if (value)
    return [aBlock value];
  else
    return nil;
}

- (id)ifTrue:(CMBlock *)aBlock1 ifFalse:(CMBlock *)aBlock2
{
  if (value)
    return [aBlock1 value];
  else
    return [aBlock2 value];
}

- (id)ifFalse:(CMBlock *)aBlock
{
  if (!value)
    return [aBlock value];
  else
    return nil;
}

- (id)ifFalse:(CMBlock *)aBlock1 ifTrue:(CMBlock *)aBlock2
{
  if (!value)
    return [aBlock1 value];
  else
    return [aBlock2 value];
}

@end
