#import "common.h"
#import "CMBlockNode.h"
#import "CMBlock.h"

@implementation CMBlockNode

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitBlockNode");
  [aVisitor visitBlockNode:self];
  LOG(@"<== visitBlockNode");
}


- (void)dealloc
{
  [block release];
  [sourceCode release];
  [super dealloc];
}

- (CMBlock *)block
{
  return block;
}

- (void)setBlock:(CMBlock *)aBlock
{
  ASSIGN(block, aBlock);
}

- (NSString *)comment
{
  return @"";
}

- (NSString *)sourceCode { return sourceCode; }
- (void)setSourceCode:(NSString *)aCode { ASSIGN(sourceCode, aCode); }

@end
