//
//  CMBlockContext.m
//  CocoaMill
//

#import "common.h"
#import "CMBlockContext.h"
#import "CMBlock.h"
#import "CMContext.h"


@implementation CMBlockContext

- (id)initWithSender:(id)aSender
            receiver:(id)aReceiver
              method:(id)aMethod
           arguments:(NSArray *)arguments
{
  [super initWithSender:aSender
         receiver:aReceiver
         method:aMethod
         arguments:arguments];
  int i;
  NSArray *names = [aReceiver argumentNames];
  for (i = 0; i < [aReceiver numberOfArguments]; i++) {
    [self setObject:[arguments objectAtIndex:i]
          forNewVariableNamed:[names objectAtIndex:i]];
  }
  return self;
}

- (NSString *)description
{
  return [NSString stringWithFormat:@"<%@ in %@>", [self class], [sender class]];
}

- (CMContext *)outerContext
{
  return [receiver outerContext];
}

- (CMVariable *)variableNamed:(NSString *)aName
{
  CMVariable *var;

  // local variable
  if (var = [super variableNamed:aName]) return var;

  // variables in outer context
  return [[self outerContext] variableNamed:aName];
}

@end
