#import "common.h"
#import "CMBlockArgumentsNode.h"


@implementation CMBlockArgumentsNode

- (void)acceptVisitor:(id <CMNodeVisitor>)aVisitor
{
  LOG(@"==> visitBlockArgumentsNode");
  [aVisitor visitBlockArgumentsNode:self];
  LOG(@"<== visitBlockArgumentsNode");
}

- (NSString *)description
{
  NSMutableString *desc = [NSMutableString stringWithFormat:@"(%@ '(",
                                           [[self class] nodeName]];
    
  id e = [nodes objectEnumerator];
  id obj;
  NSMutableArray *nodesDesc = [NSMutableArray arrayWithCapacity:[nodes count]];
  while (obj = [e nextObject]) {
    [nodesDesc addObject:[NSString stringWithFormat:@"\"%@\"",
                                   [obj ownDescription]]];
  }
  [desc appendString:[nodesDesc componentsJoinedByString:@" "]];
  [desc appendString:@"))"];
  return desc;
}

+ (NSString *)nodeName { return @"block-args"; }

@end
