#import "common.h"
#import "CMBlock.h"
#import "CMNode.h"
#import "CMBlockContext.h"
#import "CMEvaluateNodeVisitor.h"
#import "CMBlockNode.h"
#import "CMExpressionNode.h"
#import "CMBlockArgumentsNode.h"
#import "CMNil.h"
#import "CMTrue.h"
#import "CMFalse.h"

@implementation CMBlock

+ (id)blockWithNode:(CMNode *)aNode
{
  return [[((CMBlock *)[self alloc]) initWithNode:aNode] autorelease];
}

- (id)initWithNode:(CMNode *)aNode
{
  [self init];
  node = [aNode retain];
  return self;
}

- (void)dealloc
{
  [node release];
  [outerContext release];
  [super dealloc];
}

- (CMNode *)node { return node; }
- (CMContext *)outerContext { return outerContext; }
- (void)setOuterContext:(CMContext *)aContext { ASSIGN(outerContext, aContext); }

- (id)value
{
  return [self valueWithObjects:nil];
}

- (id)value:(id)anObject
{
  return [self valueWithObjects:anObject, nil];
}

- (id)value:(id)anObject value:(id)anotherObject
{
  return [self valueWithObjects:anObject, anotherObject, nil];
}

- (id)value:(id)firstObject value:(id)secondObject value:(id)thirdObject
{
  return [self valueWithObjects:firstObject, secondObject, thirdObject, nil];
}

- (id)valueWithObjects:(id)anObject, ...
{
  va_list ap;
  id arg;
  NSMutableArray *objects = [NSMutableArray arrayWithCapacity:1];
  if (anObject) {
    [objects addObject:anObject];
    va_start(ap, anObject);
    while (arg = va_arg(ap, id)) {
      [objects addObject:arg];
    }
    va_end(ap);
  }
  return [self valueWithArray:objects];
}

- (id)valueWithArray:(NSArray *)anArray
{
  CMBlockContext *context;
  context = [CMBlockContext contextWithSender:[CMContext sender]
                            receiver:self
                            method:nil
                            arguments:anArray];
  [CMContext setSender:context];
  [context setNode:node];
  [context evaluate];
  [CMContext revertSender];
  return [context returnValue];
}

- (id)on:(id)names do:(CMBlock *)aBlock
{
  id value = nil, blockToRetry, sender, block;

  if ([names isKindOfClass:[NSString class]])
    names = [NSArray arrayWithObject:names];
  block = self;
  while (1) {
    NS_DURING
      if ([[CMContext sender] isSuspended]) {
        [[CMContext sender] setNode:node];
        [(CMContext *)[CMContext sender] resume];
      } else {
        [block value];
      }

    NS_HANDLER
      if (!names || [names containsObject:[localException name]]) {
        value = [aBlock value:localException];
        if ([[CMContext sender] passesException])
          [localException raise];
      } else {
        [localException raise];
      }
    
    NS_ENDHANDLER;

    sender = [CMContext sender];
    if ([sender doesRetry]) {
      blockToRetry = [sender blockToRetry];
      [sender clearFlags];
      if (blockToRetry)
        block = blockToRetry;
    } else if (![sender isSuspended]) {
      break;
    }
  }

  return value;
}

- (void)ensure:(CMBlock *)aBlock
{
  NS_DURING
    [self value];
  NS_HANDLER
  NS_ENDHANDLER;
  [aBlock value];
}

- (id)whileTrue
{
  return [self whileTrue:nil];
}

- (id)whileTrue:(CMBlock *)aBlock
{
  id value = nil;
  while ([[self value] isMemberOfClass:[CMTrue class]]) {
    value = [aBlock value];
    if (![[CMContext sender] continuesVisitation])
      break;
  }
  return value;
}

- (id)whileFalse
{
  return [self whileFalse:nil];
}

- (id)whileFalse:(CMBlock *)aBlock
{
  id value = nil;
  while ([[self value] isMemberOfClass:[CMFalse class]]) {
    value = [aBlock value];
    if (![[CMContext sender] continuesVisitation])
      break;
  }
  return value;
}

- (void)repeat
{
  while (1) {
    [self value];
    if ([[CMContext sender] continuesVisitation])
      break;
  }
}

- (NSString *)comment
{
  return @"";
}

- (NSString *)sourceCode
{
  return [(CMBlockNode *)node sourceCode];
}

- (CMBlockArgumentsNode *)blockArgumentsNode
{
  id e, blockNode, blockArgsNode = nil;

  // block -> expr -> exprs ... 
  e = [[[[node nodes] lastObject] nodes] objectEnumerator];
  while (blockNode = [e nextObject]) {
    if ([blockNode isMemberOfClass:[CMBlockArgumentsNode class]]) {
      blockArgsNode = blockNode;
      break;
    }
  }
  return blockArgsNode;
}

- (NSArray *)argumentNames
{
  return [[[self blockArgumentsNode] nodes] valueForKey:@"name"];
}

- (unsigned)numberOfArguments
{
  return [[[self blockArgumentsNode] nodes] count];
}

@end

