#import <Cocoa/Cocoa.h>
#import "CMSourceCode.h"

@class CMNode, CMBlock, CMContext, CMBlockArgumentsNode;

@interface CMBlock : NSObject <CMSourceCode> {
  CMNode *node;
  CMContext *outerContext;
}

+ (id)blockWithNode:(CMNode *)aNode;

- (id)initWithNode:(CMNode *)aNode;
- (void)dealloc;
- (CMNode *)node;
- (CMContext *)outerContext;
- (void)setOuterContext:(CMContext *)aContext;
- (CMBlockArgumentsNode *)blockArgumentsNode;
- (NSArray *)argumentNames;
- (unsigned)numberOfArguments;
- (NSString *)comment;
- (NSString *)sourceCode;

- (id)value;
- (id)value:(id)anObject;
- (id)value:(id)anObject value:(id)anotherObject;
- (id)value:(id)firstObject value:(id)secondObject value:(id)thirdObject;
- (id)valueWithObjects:(id)anObject, ...;
- (id)valueWithArray:(NSArray *)anArray;

- (id)on:(id)names do:(CMBlock *)aBlock;
- (void)ensure:(CMBlock *)aBlock;

- (id)whileTrue;
- (id)whileTrue:(CMBlock *)aBlock;
- (id)whileFalse;
- (id)whileFalse:(CMBlock *)aBlock;
- (void)repeat;

@end
