#import <Cocoa/Cocoa.h>

extern NSString *CMVersion;
extern NSString *CMPathExtension;
extern NSString *CMEnvironmentLibraryKey;
extern NSString *CMApplicationVariableName;
extern NSString *CMFileNameVariableName;
extern NSString *CMLineNumberVariableName;
extern NSString *CMArgumentsVariableName;
extern NSString *CMStandardInputVariableName;
extern NSString *CMStandardOuputVariableName;
extern NSString *CMStandardErrorVariableName;
extern NSString *CMEnvironmentVariableName;
extern NSString *CMDefaultFileName;
extern NSString *CMLibraryDirectoryName;
extern NSString *CMSiteDirectoryName;

@class CMContext, CMRuntime, CMEnvironment;


int CMApplicationMain(const char* cm_main_name, int argc, const char* argv[]);


@interface CMApplication : NSObject {
  CMRuntime *runtime;
  NSMutableArray *arguments;
  CMEnvironment *environment;
  NSStringEncoding encoding;
  BOOL debug, terminationStatus, checkSytaxOnly;
}

+ (id)defaultApplication;
+ (NSStringEncoding)defaultEncoding;
+ (void)setDefaultEncoding:(NSStringEncoding)anEncoding;

- (id)init;
- (void)dealloc;

- (void)runWithArguments:(const char **)argv count:(int)argc;

- (void)displayVersion;
- (void)displayHelpWithName:(const char *)aName;

- (void)initializeRuntime:(CMRuntime *)aRuntime;
- (void)setVariablesForContext:(CMContext *)aContext;

- (NSString *)pathExtension;
- (NSString *)version;
- (NSStringEncoding)encoding;
- (NSArray *)arguments;
- (CMEnvironment *)environment;
- (BOOL)debug;
- (void)setDebug:(BOOL)flag;
- (BOOL)terminationStatus;

// path utilities
- (NSString *)currentDirectoryPath;
- (NSString *)fullUserName;
- (NSString *)userName;
- (NSString *)homeDirectoryPath;
- (NSString *)homeDirectoryPathForUser:(NSString *)aName;
- (NSString *)userLibrarySiteVersionPath;
- (NSString *)userLibrarySitePath;
- (NSString *)userLibraryVersionPath;
- (NSString *)localLibrarySiteVersionPath;
- (NSString *)localLibrarySitePath;
- (NSString *)localLibraryVersionPath;

- (void)exit;
- (void)exitWithStatus:(int)status;

@end

