%% > Sync
%% < ReadyForQuery
-module(cloudi_x_epgsql_cmd_sync).
-behaviour(cloudi_x_epgsql_command).
-export([init/1, execute/2, handle_message/4]).
-export_type([response/0]).

-type response() :: ok | {error, cloudi_x_epgsql:query_error()}.

-include("cloudi_x_epgsql.hrl").
-include("cloudi_x_epgsql_protocol.hrl").


init(_) ->
    undefined.

execute(Sock, St) ->
    cloudi_x_epgsql_sock:send(Sock, ?SYNC, []),
    Sock1 = cloudi_x_epgsql_sock:set_attr(sync_required, false, Sock),
    {ok, Sock1, St}.

handle_message(?READY_FOR_QUERY, _, Sock, _State) ->
    {finish, ok, ok, Sock};
handle_message(?ERROR, Error, _Sock, _State) ->
    {sync_required, {error, Error}};
handle_message(_, _, _, _) ->
    unknown.
