-module(cloudi_x_lager_msg).

-export([new/4, new/5]).
-export([message/1]).
-export([timestamp/1]).
-export([datetime/1]).
-export([severity/1]).
-export([severity_as_int/1]).
-export([metadata/1]).
-export([destinations/1]).

-record(cloudi_x_lager_msg,{
        destinations :: list(),
        metadata :: [tuple()],
        severity :: cloudi_x_lager:log_level(),
        datetime :: {string(), string()},
        timestamp :: erlang:timestamp(),
        message :: list()
    }).

-opaque cloudi_x_lager_msg() :: #cloudi_x_lager_msg{}.
-export_type([cloudi_x_lager_msg/0]).

%% create with provided timestamp, handy for testing mostly
-spec new(list(), erlang:timestamp(), cloudi_x_lager:log_level(), [tuple()], list()) -> cloudi_x_lager_msg().
new(Msg, Timestamp, Severity, Metadata, Destinations) ->
    {Date, Time} = cloudi_x_lager_util:format_time(cloudi_x_lager_util:maybe_utc(cloudi_x_lager_util:localtime_ms(Timestamp))),
    #cloudi_x_lager_msg{message=Msg, datetime={Date, Time}, timestamp=Timestamp, severity=Severity,
        metadata=Metadata, destinations=Destinations}.

-spec new(list(), cloudi_x_lager:log_level(), [tuple()], list()) -> cloudi_x_lager_msg().
new(Msg, Severity, Metadata, Destinations) ->
    Now = os:timestamp(),
    new(Msg, Now, Severity, Metadata, Destinations).

-spec message(cloudi_x_lager_msg()) -> list().
message(Msg) ->
    Msg#cloudi_x_lager_msg.message.

-spec timestamp(cloudi_x_lager_msg()) -> erlang:timestamp().
timestamp(Msg) ->
    Msg#cloudi_x_lager_msg.timestamp.

-spec datetime(cloudi_x_lager_msg()) -> {string(), string()}.
datetime(Msg) ->
    Msg#cloudi_x_lager_msg.datetime.

-spec severity(cloudi_x_lager_msg()) -> cloudi_x_lager:log_level().
severity(Msg) ->
    Msg#cloudi_x_lager_msg.severity.

-spec severity_as_int(cloudi_x_lager_msg()) -> cloudi_x_lager:log_level_number().
severity_as_int(Msg) ->
    cloudi_x_lager_util:level_to_num(Msg#cloudi_x_lager_msg.severity).

-spec metadata(cloudi_x_lager_msg()) -> [tuple()].
metadata(Msg) ->
    Msg#cloudi_x_lager_msg.metadata.

-spec destinations(cloudi_x_lager_msg()) -> list().
destinations(Msg) ->
    Msg#cloudi_x_lager_msg.destinations.


