/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce4;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.AbstractMapper;
import org.apache.wicket.request.resource.PackageResourceReference;

public class TinyMceRequestMapper
extends AbstractMapper {
    private static final List<String> KNOWN_SEGMENTS = Arrays.asList("themes", "skins", "langs", "plugins", "utils", "tinymce.js", "tinymce.min.js");

    @Override
    public IRequestHandler mapRequest(Request request) {
        String url = request.getUrl().toString();
        List<String> segments = request.getUrl().getSegments();
        for (String prefix : KNOWN_SEGMENTS) {
            String path;
            if (!segments.contains(prefix) || TinyMceRequestMapper.class.getResource(path = "tinymce/" + url.substring(url.indexOf(prefix))) == null) continue;
            PackageResourceReference resourceReference = new PackageResourceReference(TinyMceRequestMapper.class, path);
            return new ResourceReferenceRequestHandler(resourceReference, null);
        }
        return null;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        return Integer.MAX_VALUE;
    }

    @Override
    public Url mapHandler(IRequestHandler requestHandler) {
        return null;
    }
}

