/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce4;

import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import wicket.contrib.tinymce4.TinyMceBehavior;
import wicket.contrib.tinymce4.settings.TinyMCESettings;

public class InPlaceEditComponent
extends AbstractTextComponent<String> {
    private static final long serialVersionUID = 1L;
    private TinyMCESettings settings;

    public InPlaceEditComponent(String id, IModel<String> model) {
        super(id, model);
        this.init(this);
    }

    public InPlaceEditComponent(String id, IModel<String> model, Component triggerComponent) {
        super(id, model);
        this.init(triggerComponent);
    }

    public InPlaceEditComponent(String id, String text) {
        super(id, new Model<String>(text));
        this.init(this);
    }

    public InPlaceEditComponent(String id, String text, Component triggerComponent) {
        super(id, new Model<String>(text));
        this.init(triggerComponent);
    }

    private void init(Component triggerComponent) {
        this.setEscapeModelStrings(false);
        this.setOutputMarkupId(true);
        this.settings = new TinyMCESettings(TinyMCESettings.Theme.modern);
        this.settings.setInLine(true);
        triggerComponent.add(new TinyMceBehavior(this.settings));
    }

    public TinyMCESettings getSettings() {
        return this.settings;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("name");
    }

    @Override
    public String getInputName() {
        return this.getMarkupId();
    }

    @Override
    public final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, this.getValue());
    }
}

