/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.zzdeplicated.server;

import javax.servlet.ServletContext;
import org.apache.wicket.markup.html.WebPage;
import org.clearfy.ClearfyApplication;
import org.clearfy.zzdeplicated.server.Glassfish;
import org.clearfy.zzdeplicated.server.Tomcat;
import org.clearfy.zzdeplicated.server.Unknown;

public abstract class AppServer {
    public static final int SERVER_TYPE_TOMCAT = 1;
    public static final int SERVER_TYPE_GLASSFISH = 2;
    public static final int SERVER_TYPE_JETTY = 3;
    private String serverInfo;
    private String rootPath;
    private String baseUrl;

    public static AppServer createEnvironment(String contextRootPath) {
        AppServer rvalue = new Unknown();
        ServletContext sc = ClearfyApplication.get().getServletContext();
        String serverInfo = sc.getServerInfo();
        if (serverInfo.contains("Tomcat")) {
            rvalue = new Tomcat();
        }
        if (serverInfo.contains("GlassFish")) {
            rvalue = new Glassfish();
        }
        super.setContextRootPath(contextRootPath);
        rvalue.setServerInfo(serverInfo);
        return rvalue;
    }

    private void setUrl(String url) {
        this.baseUrl = url;
    }

    private void setContextRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    protected String getContextRootPath() {
        return this.rootPath;
    }

    private void setServerInfo(String info) {
        this.serverInfo = info;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public abstract void reload(WebPage var1);
}

