/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.timcard.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.timcard.client.CardReader;
import org.clearfy.timcard.client.Communicator;
import org.clearfy.timcard.client.ICardReaderProcedure;
import org.clearfy.timcard.client.TimeCardClient;
import org.clearfy.timcard.client.data.Attributes;
import org.clearfy.timcard.client.data.EmployeeAtClient;
import org.clearfy.timcard.client.data.TimeRecordAtClient;

public class TimeRecorder
extends JPanel
implements ICardReaderProcedure {
    private EmployeeAtClient employee;
    private IJdbcSupplier supplier;
    private Communicator communicator;
    private Clock clock = new Clock();
    private CardReader cardReader;
    private TimeRecordAtClient timeRecord;
    private Attributes attributes;
    private String shopId = "";
    private TimeCardClient parentForm;
    private JToggleButton btnOvernight;
    private JLabel dateField;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JLabel lblMessage;
    private JLabel lblShopName;
    private JLabel signal;
    private JLabel timeField;
    private JTable timeRecordToday;

    public Communicator getCommunicator() {
        return this.communicator;
    }

    public void setCommunicator(Communicator communicator) {
        this.communicator = communicator;
    }

    public TimeRecorder() {
        this.initComponents();
        this.timeRecordToday.setAutoResizeMode(0);
        this.timeRecordToday.getColumn("\u65e5\u6642").setPreferredWidth(200);
        this.timeRecordToday.getColumn("\u6253\u523b\u8005").setPreferredWidth(150);
        this.timeRecordToday.getColumn("\u72b6\u614b").setPreferredWidth(75);
        this.clock.setDateField(this.dateField);
        this.clock.setTimeField(this.timeField);
        this.clock.start();
        this.timeRecordToday.getTableHeader().setFont(this.timeRecordToday.getFont());
        this.onVisible();
    }

    @Override
    public void bindSignalLabel() {
        if (this.cardReader != null) {
            this.cardReader.setSignal(this.signal);
        }
    }

    @Override
    public void doProcess(String cardId) {
        System.out.println(this.getClass().getName() + "<-" + cardId);
        LocalDateTime now = LocalDateTime.now();
        short status = 0;
        String msg = "";
        String employeeName = "";
        EmployeeAtClient employee = new EmployeeAtClient();
        employee.setJdbcSupplier(this.supplier);
        try {
            ResultSet rs;
            if (employee.getCount(employee.ScardId.sameValueOf(cardId)) > 0 && (rs = employee.select(employee.ScardId.sameValueOf(cardId))).next()) {
                employeeName = rs.getString(employee.EmployeeName.getName());
            }
        }
        catch (SQLException | ClearfyDatabaseException ex) {
            Logger.getLogger(TimeRecorder.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.communicator.touch()) {
            String employeeNameAtServer;
            JsonNode node = this.communicator.getJsonNode(this.communicator.getUserInfo(cardId));
            if (node.get("STATUS").asText().equals("SUCCESS") && node.get("RESULT").asText().equals("EXIST") && !(employeeNameAtServer = node.get("EMPLOYEE_NAME").asText()).equals(employeeName)) {
                employeeName = employeeNameAtServer;
                employee.clearValues();
                employee.merge(employee.ScardId.setValue(cardId), employee.Mdate.setValue(Timestamp.valueOf(now)), employee.EmployeeName.setValue(employeeNameAtServer));
            }
        } else {
            msg = "\u30b5\u30fc\u30d0\u30fc\u3068\u901a\u4fe1\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u8a2d\u5b9a\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            status = 1;
        }
        if (employeeName.length() > 0) {
            String currentTime = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            short checkType = -1;
            if (this.btnOvernight.isSelected()) {
                checkType = 3;
                this.btnOvernight.setSelected(false);
            }
            this.lblMessage.setText(currentTime + " \u6253\u523b\u3057\u307e\u3057\u305f");
            String messageKey = "";
            if (this.communicator.isAlived()) {
                status = 2;
                this.timeRecord.clearValues();
                this.timeRecord.insert(this.timeRecord.Mdate.setValue(Timestamp.valueOf(now)), this.timeRecord.ScardId.setValue(cardId), this.timeRecord.OrganizationId.setValue(Integer.valueOf(this.shopId)), this.timeRecord.CheckDateTime.setValue(Timestamp.valueOf(currentTime)), this.timeRecord.CheckType.setValue(checkType), this.timeRecord.Status.setValue(status), this.timeRecord.MessageKey.calculateMD5());
                messageKey = (String)this.timeRecord.MessageKey.getValue();
                if (!this.communicator.record(cardId, this.shopId, currentTime, String.valueOf(checkType), messageKey)) {
                    status = 1;
                    msg = "\u6253\u523b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n%s";
                    msg = String.format(msg, this.communicator.getErrorMessage());
                } else {
                    status = 0;
                }
                this.timeRecord.clearValues();
                this.timeRecord.Status.setValue(status);
                try {
                    this.timeRecord.update(this.timeRecord.MessageKey.sameValueOf(messageKey));
                }
                catch (ClearfyDatabaseException ex) {
                    Logger.getLogger(TimeRecorder.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                this.lblMessage.setText(this.lblMessage.getText() + " (\u30b5\u30fc\u30d0\u672a\u9001\u4fe1\uff09");
            }
        } else {
            msg = "\u30ab\u30fc\u30c9\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            status = 1;
        }
        if (status == 1) {
            JOptionPane.showMessageDialog(this, msg, "\u6253\u523b\u5931\u6557", 0);
        }
        this.showTimeRecordAtClient();
    }

    @Override
    public void setParentForm(TimeCardClient form) {
        this.parentForm = form;
    }

    public void showTimeRecordAtClient() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime from = now.withHour(0).withMinute(0).withSecond(0).withNano(0);
        String szFrom = from.format(DateTimeFormatter.ofPattern("''yyyy-MM-dd HH:mm:ss''"));
        LocalDateTime to = now.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        String szTo = to.format(DateTimeFormatter.ofPattern("''yyyy-MM-dd HH:mm:ss''"));
        this.timeRecord.selectAllColumn();
        EmployeeAtClient employee = new EmployeeAtClient();
        ResultSet rs = this.timeRecord.select(employee.EmployeeName.setSelectable(true), this.timeRecord.Status.differentValueOf(String.valueOf(-1)).setSelectable(true), this.timeRecord.CheckDateTime.greaterEqual(szFrom), this.timeRecord.CheckDateTime.lower(szTo), this.timeRecord.CheckDateTime.desc());
        try {
            DefaultTableModel dtm = (DefaultTableModel)this.timeRecordToday.getModel();
            while (dtm.getRowCount() > 0) {
                dtm.removeRow(0);
            }
            while (rs.next()) {
                String employeeName = employee.EmployeeName.of(rs);
                Timestamp checktime = (Timestamp)this.timeRecord.CheckDateTime.of(rs);
                short status = this.timeRecord.Status.of(rs);
                String statusTxt = "";
                switch (status) {
                    case 0: {
                        statusTxt = "\u9001\u4fe1\u6e08";
                        break;
                    }
                    case 1: {
                        statusTxt = "\u672a\u9001\u4fe1";
                    }
                }
                System.out.println(employeeName + " " + checktime);
                dtm.addRow(new Object[]{checktime, employeeName, statusTxt});
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TimeRecorder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void setCardReader(CardReader reader) {
        this.cardReader = reader;
    }

    @Override
    public void setJdbcSupplier(IJdbcSupplier supplier) {
        this.supplier = supplier;
        this.initializeTables(this.supplier);
        this.initalizePanel();
    }

    public void initalizePanel() {
        this.communicator = new Communicator(this.supplier);
        this.shopId = this.attributes.getAttributeValue("shopid");
        this.lblShopName.setText(this.attributes.getAttributeValue("shopName"));
    }

    public void initializeTables(IJdbcSupplier supplier) {
        this.attributes = new Attributes();
        this.attributes.alterOrCreateTable(supplier);
        this.timeRecord = new TimeRecordAtClient();
        this.timeRecord.alterOrCreateTable(supplier);
        this.showTimeRecordAtClient();
    }

    public JLabel getSignal() {
        return this.signal;
    }

    public void onVisible() {
        this.btnOvernight.setSelected(false);
        DefaultTableModel tablemodel = (DefaultTableModel)this.timeRecordToday.getModel();
        while (tablemodel.getRowCount() > 0) {
            tablemodel.removeRow(0);
        }
        if (this.timeRecord != null) {
            this.showTimeRecordAtClient();
        }
    }

    public void sendUnsyncedData() {
        this.timeRecord.selectAllColumn();
        ResultSet rs = this.timeRecord.select(this.timeRecord.Status.sameValueOf(String.valueOf(1)));
        try {
            while (rs.next()) {
                String messageKey;
                String checkType;
                String checkTime;
                String orgId;
                String scardId = this.timeRecord.ScardId.of(rs);
                if (!this.communicator.record(scardId, orgId = String.valueOf(this.timeRecord.OrganizationId.of(rs)), checkTime = String.valueOf(this.timeRecord.CheckDateTime.of(rs)), checkType = String.valueOf(this.timeRecord.CheckType.of(rs)), messageKey = (String)this.timeRecord.MessageKey.of(rs))) continue;
                this.timeRecord.clearValues();
                this.timeRecord.Status.setValue((short)0);
                this.timeRecord.update(this.timeRecord.ScardId.sameValueOf(scardId), this.timeRecord.OrganizationId.sameValueOf(orgId), this.timeRecord.CheckDateTime.sameValueOf("'" + checkTime + "'"));
            }
            this.onVisible();
        }
        catch (SQLException | ClearfyDatabaseException ex) {
            Logger.getLogger(TimeRecorder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.dateField = new JLabel();
        this.timeField = new JLabel();
        this.jLabel3 = new JLabel();
        this.lblMessage = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.timeRecordToday = new JTable();
        this.signal = new JLabel();
        this.lblShopName = new JLabel();
        this.btnOvernight = new JToggleButton();
        this.setBackground(new Color(0, 0, 0));
        this.setPreferredSize(new Dimension(678, 430));
        this.dateField.setFont(this.dateField.getFont().deriveFont(40.0f));
        this.dateField.setForeground(new Color(255, 255, 255));
        this.dateField.setHorizontalAlignment(0);
        this.dateField.setText("yyyy-mm-dd");
        this.timeField.setFont(this.timeField.getFont().deriveFont(40.0f));
        this.timeField.setForeground(new Color(255, 255, 255));
        this.timeField.setHorizontalAlignment(0);
        this.timeField.setText("HH:MM:SS");
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont((float)this.jLabel3.getFont().getSize() + 12.0f));
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText("\u6253\u523b\u8a18\u9332");
        this.lblMessage.setFont(this.lblMessage.getFont().deriveFont((float)this.lblMessage.getFont().getSize() + 12.0f));
        this.lblMessage.setForeground(new Color(255, 255, 255));
        this.lblMessage.setHorizontalAlignment(0);
        this.timeRecordToday.setFont(new Font("MS UI Gothic", 0, 18));
        this.timeRecordToday.setModel(new DefaultTableModel(new Object[][]{{"1", "2", "3"}}, new String[]{"\u65e5\u6642", "\u6253\u523b\u8005", "\u72b6\u614b"}));
        this.timeRecordToday.setAutoResizeMode(3);
        this.timeRecordToday.setGridColor(new Color(255, 255, 255));
        this.timeRecordToday.setRowHeight(20);
        this.jScrollPane1.setViewportView(this.timeRecordToday);
        this.signal.setFont(new Font("MS UI Gothic", 1, 18));
        this.signal.setForeground(new Color(255, 255, 255));
        this.signal.setIcon(new ImageIcon(this.getClass().getResource("/red.png")));
        this.signal.setText("jLabel5");
        this.lblShopName.setFont(new Font("MS UI Gothic", 0, 24));
        this.lblShopName.setForeground(new Color(255, 255, 255));
        this.lblShopName.setHorizontalAlignment(0);
        this.lblShopName.setText("jLabel1");
        this.lblShopName.setHorizontalTextPosition(0);
        this.btnOvernight.setBackground(new Color(102, 102, 102));
        this.btnOvernight.setFont(new Font("MS UI Gothic", 0, 18));
        this.btnOvernight.setForeground(new Color(204, 204, 255));
        this.btnOvernight.setText("\u591c\u52e4\u660e\u3051");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timeField, GroupLayout.Alignment.TRAILING, -1, 309, Short.MAX_VALUE).addComponent(this.dateField, GroupLayout.Alignment.TRAILING, -1, 309, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.signal).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.lblShopName, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnOvernight, -2, 131, -2)).addComponent(this.jScrollPane1, -1, 413, Short.MAX_VALUE)).addGap(15, 15, 15))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 31, -2).addComponent(this.signal)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.lblShopName, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dateField, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeField, -2, 83, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOvernight, -2, 48, -2).addGap(18, 18, 18).addComponent(this.lblMessage, -2, 43, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public class Clock
    extends Thread {
        private LocalDateTime currentTime = LocalDateTime.now();
        private boolean keep = true;
        private JLabel dateField;
        private JLabel timeField;

        public void setDateField(JLabel field) {
            this.dateField = field;
        }

        public void setTimeField(JLabel field) {
            this.timeField = field;
        }

        public LocalDateTime getCurrentTime() {
            return this.currentTime;
        }

        @Override
        public void run() {
            while (this.keep) {
                this.currentTime = LocalDateTime.now();
                String date = String.format("%04d-%02d-%02d", this.currentTime.getYear(), this.currentTime.getMonthValue(), this.currentTime.getDayOfMonth());
                this.dateField.setText(date);
                String time = String.format("%02d:%02d:%02d", this.currentTime.getHour(), this.currentTime.getMinute(), this.currentTime.getSecond());
                this.timeField.setText(time);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(TimeRecorder.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

