/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.timcard.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.datawrapper.Jdbc;
import org.clearfy.timcard.client.CardReader;
import org.clearfy.timcard.client.Communicator;
import org.clearfy.timcard.client.ControlPanel;
import org.clearfy.timcard.client.DayButton;
import org.clearfy.timcard.client.ICardReaderProcedure;
import org.clearfy.timcard.client.ICommunicatorContainer;
import org.clearfy.timcard.client.ModifyPanel;
import org.clearfy.timcard.client.Monitor;
import org.clearfy.timcard.client.TimeRecorder;
import org.clearfy.timcard.client.data.Attributes;
import org.clearfy.timcard.client.data.EmployeeAtClient;
import org.clearfy.timcard.client.data.TimeRecordAtClient;
import org.h2.tools.Server;

public class TimeCardClient
extends JFrame
implements IJdbcSupplier,
ICommunicatorContainer,
ActionListener {
    public static final String JDBC_DRIVER = "org.h2.Driver";
    public static final int PORT_HTTP = 9990;
    public static final int PORT_TCP = 9991;
    private CardReader cardReader;
    private Communicator communicator;
    private Server httpDbServer;
    private Server tcpDbServer;
    private boolean dbRunning = false;
    private Attributes attribute;
    private ControlPanel controlPanel1;
    private ICardReaderProcedure targetProcedure;
    private Monitor monitor;
    private JButton btnQuit;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTabbedPane jTabbedPane1;
    private ModifyPanel modifyPanel1;
    private TimeRecorder timeRecorder1;

    public TimeCardClient() {
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TimeCardClient.this.closing(e);
            }
        });
        try {
            Class.forName(JDBC_DRIVER);
            this.httpDbServer = Server.createWebServer("-webPort", String.valueOf(9990), "-webAllowOthers").start();
            this.tcpDbServer = Server.createTcpServer("-tcpPort", "9991", "-tcpAllowOthers").start();
            this.dbRunning = true;
            this.controlPanel1 = new ControlPanel(){

                @Override
                public void onSettingChanged() {
                    TimeCardClient.this.loadSetting();
                }
            };
            this.jPanel3.add(this.controlPanel1);
            EmployeeAtClient employee = new EmployeeAtClient();
            employee.alterOrCreateTable(this);
            TimeRecordAtClient timeRecord = new TimeRecordAtClient();
            timeRecord.alterOrCreateTable(this);
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(TimeCardClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.cardReader = new CardReader(){

            @Override
            public void onIdRead(String id) {
                TimeCardClient.this.onIdGet(id);
            }
        };
        this.cardReader.setSignal(this.timeRecorder1.getSignal());
        this.timeRecorder1.setCardReader(this.cardReader);
        this.modifyPanel1.setCardReader(this.cardReader);
        this.controlPanel1.setCardReader(this.cardReader);
        this.timeRecorder1.setParentForm(this);
        this.modifyPanel1.setParentForm(this);
        this.controlPanel1.setParentForm(this);
        this.controlPanel1.initializeCardInfo();
        this.modifyPanel1.addActionListener(this);
        this.monitor = new Monitor(){

            @Override
            public void afterSending() {
                TimeCardClient.this.toTimeRecorder();
            }
        };
    }

    @Override
    public Communicator getCommunicator() {
        return this.communicator;
    }

    @Override
    public void setCommunicator(Communicator communicator) {
        this.communicator = communicator;
    }

    public void onIdGet(String Id2) {
        this.setTitle(Id2);
        if (this.targetProcedure != null) {
            this.targetProcedure.doProcess(Id2);
        }
    }

    public void closing(WindowEvent e) {
        this.httpDbServer.stop();
        this.tcpDbServer.stop();
        this.cardReader.killProcess();
        this.monitor.done();
        this.setVisible(false);
        System.exit(0);
    }

    public void loadSetting() {
        String path = this.controlPanel1.findAttribute("nfcpy_path");
        if (this.cardReader.isAlive()) {
            this.cardReader.killProcess();
        }
        this.cardReader.setNfcpyPath(path);
        if (!this.cardReader.isAlive()) {
            this.cardReader.start();
        }
        this.modifyPanel1.setOrgId(this.controlPanel1.getShopId());
        this.modifyPanel1.setComunicator(this.communicator);
        this.monitor.setJdbcSupplier(this);
        this.monitor.setCommunicatior(this.communicator);
        this.monitor.start();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.timeRecorder1 = new TimeRecorder();
        this.jPanel2 = new JPanel();
        this.modifyPanel1 = new ModifyPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.btnQuit = new JButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setBackground(new Color(0, 0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                TimeCardClient.this.formWindowOpened(evt);
            }
        });
        this.jTabbedPane1.setBackground(new Color(0, 0, 0));
        this.jTabbedPane1.setTabLayoutPolicy(1);
        this.jTabbedPane1.setFont(this.jTabbedPane1.getFont().deriveFont((float)this.jTabbedPane1.getFont().getSize() + 2.0f));
        this.jTabbedPane1.setMaximumSize(new Dimension(800, 480));
        this.jTabbedPane1.setMinimumSize(new Dimension(800, 480));
        this.jTabbedPane1.setPreferredSize(new Dimension(800, 480));
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimeCardClient.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.timeRecorder1, "Center");
        this.jTabbedPane1.addTab("\u6253\u523b\u8a18\u9332", new ImageIcon(this.getClass().getResource("/time.png")), this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.add((Component)this.modifyPanel1, "Center");
        this.jTabbedPane1.addTab("\u6253\u523b\u8a02\u6b63", new ImageIcon(this.getClass().getResource("/Modify.png")), this.jPanel2);
        this.jPanel3.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("\u8a2d\u5b9a\u5909\u66f4", new ImageIcon(this.getClass().getResource("/Setting.png")), this.jPanel3);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont((float)this.jLabel1.getFont().getSize() + 12.0f));
        this.jLabel1.setText("\u30a2\u30d7\u30ea\u3092\u7d42\u4e86\u3057\u307e\u3059\u304b\uff1f");
        this.btnQuit.setFont(this.btnQuit.getFont().deriveFont((float)this.btnQuit.getFont().getSize() + 12.0f));
        this.btnQuit.setIcon(new ImageIcon(this.getClass().getResource("/exit.png")));
        this.btnQuit.setText("\u7d42\u4e86\u3059\u308b");
        this.btnQuit.setHorizontalTextPosition(0);
        this.btnQuit.setVerticalTextPosition(3);
        this.btnQuit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TimeCardClient.this.btnQuitMouseClicked(evt);
            }
        });
        this.jLabel2.setText("sounds powerd by  (c) http://pocket-se.info");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap(283, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.btnQuit, -1, -1, Short.MAX_VALUE)).addContainerGap(297, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addGap(219, 219, 219).addComponent(this.jLabel2, -2, 237, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(82, 82, 82).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnQuit, -2, 152, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 122, Short.MAX_VALUE).addComponent(this.jLabel2).addGap(34, 34, 34)));
        this.jTabbedPane1.addTab("\u7d42\u4e86", new ImageIcon(this.getClass().getResource("/exit.png")), this.jPanel4);
        this.getContentPane().add((Component)this.jTabbedPane1, "First");
        this.pack();
    }

    private void btnQuitMouseClicked(MouseEvent evt) {
        this.closing(new WindowEvent(this, 0));
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.cardReader == null) {
            return;
        }
        int selectedPanel = this.jTabbedPane1.getSelectedIndex();
        switch (selectedPanel) {
            case 0: {
                this.cardReader.setCardReaderProcedure(this.timeRecorder1);
                this.timeRecorder1.onVisible();
                break;
            }
            case 1: {
                this.cardReader.setCardReaderProcedure(this.modifyPanel1);
                this.modifyPanel1.setcContainer(this);
                this.modifyPanel1.onVisible();
                break;
            }
            case 2: {
                this.cardReader.setCardReaderProcedure(this.controlPanel1);
                break;
            }
            case 3: {
                this.targetProcedure = null;
            }
        }
        if (this.targetProcedure != null) {
            this.cardReader.getCardReaderProcedure().bindSignalLabel();
        }
    }

    private void formWindowOpened(WindowEvent evt) {
        this.attribute = new Attributes();
        this.attribute.alterOrCreateTable(this);
        this.controlPanel1.setJdbcSupplier(this);
        this.modifyPanel1.setJdbcSupplier(this);
        this.timeRecorder1.setJdbcSupplier(this);
        this.communicator = new Communicator(this);
        this.controlPanel1.setCommunicator(this.communicator);
        this.controlPanel1.loadSetting();
        if (this.controlPanel1.getNfcpyPath().trim().length() < 1) {
            this.jTabbedPane1.setSelectedIndex(2);
            JOptionPane.showMessageDialog(this, "\u30ab\u30fc\u30c9\u30ea\u30fc\u30c0\u30fc\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.cardReader.setCardReaderProcedure(this.timeRecorder1);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                System.out.println(info.getName());
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(TimeCardClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> {
            TimeCardClient app = new TimeCardClient();
            app.dispose();
            app.setSize(800, 480);
            app.setLocation(0, 0);
            app.setUndecorated(true);
            app.setVisible(true);
            app.setBackground(Color.BLACK);
        });
    }

    public String getJdbcUrl() {
        File f = new File("TimeCardClient");
        String realpath = f.getAbsolutePath();
        String fmt = "jdbc:h2:tcp:localhost:%d/%s";
        fmt = String.format(fmt, 9991, realpath).trim();
        System.out.println(fmt);
        return fmt;
    }

    public void toTimeRecorder() {
        this.timeRecorder1.onVisible();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    @Override
    public Jdbc getJdbc() {
        Jdbc controller = new Jdbc(this.getJdbcUrl());
        return controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DayButton selected = (DayButton)e.getSource();
        if (selected.getDate() != null) {
            this.modifyPanel1.showRecordsOf(selected.getDate());
        }
    }
}

