/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.timcard.client;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.timcard.client.Communicator;
import org.clearfy.timcard.client.data.TimeRecordAtClient;

public abstract class Monitor
extends Thread {
    private Communicator communicator = null;
    private IJdbcSupplier jdbcsupplier;
    private boolean keep = true;
    private TimeRecordAtClient timeRecord;

    public void setCommunicatior(Communicator comm) {
        this.communicator = comm;
    }

    public void setJdbcSupplier(IJdbcSupplier supplier) {
        this.jdbcsupplier = supplier;
        this.timeRecord = new TimeRecordAtClient();
        this.timeRecord.setJdbcSupplier(supplier);
    }

    public void done() {
        this.keep = false;
    }

    @Override
    public void run() {
        System.out.println("MONITOR STARTED!!");
        if (this.communicator == null) {
            return;
        }
        while (this.keep) {
            if (this.communicator.touch()) {
                try {
                    ResultSet rs = this.timeRecord.select(this.timeRecord.Status.sameValueOf(String.valueOf(1)));
                    while (rs.next()) {
                        String messageKey;
                        String checkType;
                        LocalDateTime check;
                        String checkTime;
                        String orgId;
                        String scardId = this.timeRecord.ScardId.of(rs);
                        if (!this.communicator.record(scardId, orgId = String.valueOf(this.timeRecord.OrganizationId.of(rs)), checkTime = (check = ((Timestamp)this.timeRecord.CheckDateTime.of(rs)).toLocalDateTime()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), checkType = String.valueOf(this.timeRecord.CheckType.of(rs)), messageKey = (String)this.timeRecord.MessageKey.of(rs))) continue;
                        this.timeRecord.clearValues();
                        this.timeRecord.Status.setValue((short)0);
                        this.timeRecord.update(this.timeRecord.ScardId.sameValueOf(scardId), this.timeRecord.OrganizationId.sameValueOf(orgId), this.timeRecord.CheckDateTime.sameValueOf("'" + checkTime + "'"));
                    }
                }
                catch (SQLException | ClearfyDatabaseException ex) {
                    Logger.getLogger(Monitor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            System.out.println("KEEP = " + this.keep);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Monitor.class.getName()).log(Level.SEVERE, null, ex);
                this.keep = false;
            }
        }
    }

    public abstract void afterSending();
}

