/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.timcard.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.timcard.client.BigCalendar;
import org.clearfy.timcard.client.CardReader;
import org.clearfy.timcard.client.Communicator;
import org.clearfy.timcard.client.ICardReaderProcedure;
import org.clearfy.timcard.client.ICommunicatorContainer;
import org.clearfy.timcard.client.TimeCardClient;
import org.clearfy.timcard.client.data.TimeRecordAtClient;

public class ModifyPanel
extends JPanel
implements ICardReaderProcedure {
    private Communicator comunicator;
    private String selectedRecordTime = "";
    private TimeCardClient parentForm;
    public String selectedRecordId = "";
    private int employeeId = -1;
    private int authorId = -1;
    private IJdbcSupplier supplier;
    private CardReader cardReader;
    private ICommunicatorContainer cContainer;
    private String orgId;
    private int step = 0;
    private static final int STEP_MYID = 0;
    private static final int STEP_AUTHORID = 1;
    private String userCardId = "";
    private String authorCardId = "";
    private BigCalendar bigCalendar1;
    private JToggleButton btnAdd;
    private JToggleButton btnModify;
    private JToggleButton btnOvernight;
    private JToggleButton btnRemove;
    private JButton btnSendModifyInfo;
    private ButtonGroup buttonGroup1;
    private JComboBox<String> hourSelecter;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JLabel lblAuthorName;
    private JLabel lblEmployeeName;
    private JComboBox<String> minSelecter;
    private JLabel signal;
    private JTable timeRecordView;
    private JLabel txtSelectedTime;

    @Override
    public void setParentForm(TimeCardClient form) {
        this.parentForm = form;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public ICommunicatorContainer getcContainer() {
        return this.cContainer;
    }

    public void setcContainer(ICommunicatorContainer cContainer) {
        this.cContainer = cContainer;
    }

    public ModifyPanel() {
        int i;
        this.initComponents();
        this.bigCalendar1.selectDate(LocalDate.now());
        for (i = 0; i < 24; ++i) {
            this.hourSelecter.addItem(String.valueOf(i));
        }
        for (i = 0; i < 60; i += 15) {
            this.minSelecter.addItem(String.valueOf(i));
        }
        this.timeRecordView.setAutoResizeMode(0);
        this.timeRecordView.getColumn("ID").setPreferredWidth(75);
        this.timeRecordView.getColumn("\u6253\u523b\u65e5\u6642").setPreferredWidth(150);
        this.timeRecordView.getColumn("\u5834\u6240").setPreferredWidth(200);
        this.timeRecordView.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.onSelectionRowChanged(e);
        });
        this.timeRecordView.getTableHeader().setFont(this.timeRecordView.getFont());
    }

    @Override
    public void bindSignalLabel() {
        this.cardReader.setSignal(this.signal);
    }

    public String getUserCardId() {
        return this.userCardId;
    }

    public String getAuthorCardId() {
        return this.authorCardId;
    }

    public void showRecordsOf(LocalDate date) {
        DefaultTableModel model = (DefaultTableModel)this.timeRecordView.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(model.getRowCount() - 1);
        }
        if (this.getUserCardId().length() < 1) {
            return;
        }
        String json = this.cContainer.getCommunicator().getRecordsOf(this.getUserCardId(), date);
        JsonNode node = this.comunicator.getJsonNode(json);
        if (node.get("STATUS").asText().equals("SUCCESS")) {
            node = node.get("RESULT");
            int recordCount = node.get("RECORD_COUNT").asInt();
            node = node.get("RECORD");
            for (int i = 0; i < recordCount; ++i) {
                JsonNode rec = node.get(i);
                String recordId = rec.get("RECORD_ID").asText();
                String recordTime = rec.get("RECORD_TIME").asText();
                String orgId = rec.get("ORG_ID").asText();
                String orgName = rec.get("ORG_NAME").asText();
                System.out.println(recordId + " " + recordTime + " " + orgName);
                model.addRow(new String[]{recordId, recordTime, orgName});
            }
        }
    }

    @Override
    public void doProcess(String cardId) {
        switch (this.step) {
            case 0: {
                String userInfo = this.getcContainer().getCommunicator().getUserInfo(cardId);
                if (!this.isSuccessed(userInfo)) break;
                if (this.hasNode(userInfo, "EMPLOYEE_NAME")) {
                    String userName = this.getNodeValue(userInfo, "EMPLOYEE_NAME");
                    this.lblEmployeeName.setText(userName);
                    this.userCardId = cardId;
                    this.authorCardId = "";
                    this.lblAuthorName.setText("");
                    this.step = 1;
                    break;
                }
                JOptionPane.showMessageDialog(this, "ID\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u306a\u3044\u30ab\u30fc\u30c9\u3067\u3059\u3002", "\u8b66\u544a", 2);
                break;
            }
            case 1: {
                String authorInfo = this.getcContainer().getCommunicator().getUserInfo(cardId);
                if (cardId.equals(this.userCardId)) {
                    JOptionPane.showMessageDialog(this, "\u5f93\u696d\u8005\u3068\u627f\u8a8d\u8005\u306f\u7570\u306a\u308b\u30e1\u30f3\u30d0\u30fc\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002", "\u8b66\u544a", 1);
                    break;
                }
                if (!this.isSuccessed(authorInfo)) break;
                if (this.hasNode(authorInfo, "EMPLOYEE_NAME")) {
                    String authorName = this.getNodeValue(authorInfo, "EMPLOYEE_NAME");
                    this.lblAuthorName.setText(authorName);
                    this.authorCardId = cardId;
                    this.step = 0;
                    break;
                }
                JOptionPane.showMessageDialog(this, "ID\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u306a\u3044\u30ab\u30fc\u30c9\u3067\u3059\u3002", "\u8b66\u544a", 2);
            }
        }
    }

    public boolean isSuccessed(String json) {
        boolean rvalue = false;
        if (this.getNodeValue(json, "STATUS").equals("SUCCESS")) {
            rvalue = true;
        }
        return rvalue;
    }

    public boolean hasNode(String json, String nodeName) {
        boolean rvalue = false;
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(json);
            rvalue = node.has(nodeName);
        }
        catch (IOException ex) {
            Logger.getLogger(ModifyPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public String getNodeValue(String json, String nodeName) {
        String rvalue = "";
        JsonNode node = this.comunicator.getJsonNode(json);
        rvalue = node.get(nodeName).asText();
        return rvalue;
    }

    @Override
    public void setCardReader(CardReader reader) {
        this.cardReader = reader;
    }

    @Override
    public void setJdbcSupplier(IJdbcSupplier supplier) {
        this.supplier = supplier;
    }

    public void onVisible() {
        this.step = 0;
        LocalDateTime currentTime = LocalDateTime.now();
        int hour = currentTime.getHour();
        int min = currentTime.getMinute() / 15;
        this.hourSelecter.setSelectedIndex(hour);
        this.minSelecter.setSelectedIndex(min);
        this.employeeId = -1;
        this.userCardId = "";
        this.lblEmployeeName.setText("");
        this.authorId = -1;
        this.authorCardId = "";
        this.lblAuthorName.setText("");
        this.selectedRecordId = "";
        DefaultTableModel tablemodel = (DefaultTableModel)this.timeRecordView.getModel();
        while (tablemodel.getRowCount() > 0) {
            tablemodel.removeRow(0);
        }
        this.btnAdd.setSelected(false);
        this.btnModify.setSelected(false);
        this.btnModify.setSelected(false);
        if (!this.comunicator.isAlived()) {
            JOptionPane.showMessageDialog(this, "\u30b5\u30fc\u30d0\u30fc\u3068\u901a\u4fe1\u304c\u3067\u304d\u308b\u307e\u3067\u3001\u8a02\u6b63\u6a5f\u80fd\u306f\u4f7f\u3048\u307e\u305b\u3093\u3002", "\u901a\u4fe1\u30a8\u30e9\u30fc", 0);
            this.parentForm.toTimeRecorder();
        }
    }

    public void addActionListener(ActionListener listener) {
        this.bigCalendar1.addActionListener(listener);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.bigCalendar1 = new BigCalendar();
        this.jLabel1 = new JLabel();
        this.lblEmployeeName = new JLabel();
        this.jLabel3 = new JLabel();
        this.lblAuthorName = new JLabel();
        this.jLabel5 = new JLabel();
        this.signal = new JLabel();
        this.hourSelecter = new JComboBox();
        this.jLabel7 = new JLabel();
        this.minSelecter = new JComboBox();
        this.btnSendModifyInfo = new JButton();
        this.txtSelectedTime = new JLabel();
        this.btnAdd = new JToggleButton();
        this.btnModify = new JToggleButton();
        this.btnRemove = new JToggleButton();
        this.jScrollPane1 = new JScrollPane();
        this.timeRecordView = new JTable();
        this.btnOvernight = new JToggleButton();
        this.setBackground(new Color(0, 102, 153));
        this.setPreferredSize(new Dimension(650, 450));
        this.jLabel1.setFont(new Font("MS UI Gothic", 0, 18));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("\u4fee\u6b63\u5bfe\u8c61\u8005");
        this.lblEmployeeName.setFont(new Font("MS UI Gothic", 0, 18));
        this.lblEmployeeName.setForeground(new Color(255, 255, 255));
        this.lblEmployeeName.setText("jLabel2");
        this.jLabel3.setFont(new Font("MS UI Gothic", 0, 18));
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText("\u627f\u8a8d\u8005");
        this.lblAuthorName.setFont(new Font("MS UI Gothic", 0, 18));
        this.lblAuthorName.setForeground(new Color(255, 255, 255));
        this.lblAuthorName.setText("jLabel4");
        this.jLabel5.setFont(new Font("MS UI Gothic", 0, 18));
        this.jLabel5.setForeground(new Color(255, 255, 255));
        this.jLabel5.setText("\u6253\u523b\u8a18\u9332");
        this.signal.setFont(new Font("MS UI Gothic", 0, 18));
        this.signal.setForeground(new Color(255, 255, 255));
        this.signal.setIcon(new ImageIcon(this.getClass().getResource("/red.png")));
        this.signal.setText("\u51e6\u7406\u4e2d");
        this.hourSelecter.setFont(new Font("MS UI Gothic", 0, 18));
        this.jLabel7.setFont(new Font("MS UI Gothic", 0, 18));
        this.jLabel7.setForeground(new Color(255, 255, 255));
        this.jLabel7.setText("\uff1a");
        this.minSelecter.setFont(new Font("MS UI Gothic", 0, 18));
        this.btnSendModifyInfo.setFont(new Font("MS UI Gothic", 0, 18));
        this.btnSendModifyInfo.setText("\u767b\u9332");
        this.btnSendModifyInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyPanel.this.btnSendModifyInfoActionPerformed(evt);
            }
        });
        this.txtSelectedTime.setFont(new Font("MS UI Gothic", 1, 18));
        this.txtSelectedTime.setForeground(new Color(255, 255, 255));
        this.txtSelectedTime.setHorizontalAlignment(0);
        this.btnAdd.setBackground(new Color(0, 153, 153));
        this.buttonGroup1.add(this.btnAdd);
        this.btnAdd.setFont(new Font("MS UI Gothic", 0, 18));
        this.btnAdd.setText("\u8ffd\u52a0");
        this.btnModify.setBackground(new Color(0, 153, 153));
        this.buttonGroup1.add(this.btnModify);
        this.btnModify.setFont(new Font("MS UI Gothic", 0, 18));
        this.btnModify.setText("\u4fee\u6b63");
        this.btnRemove.setBackground(new Color(0, 153, 153));
        this.buttonGroup1.add(this.btnRemove);
        this.btnRemove.setFont(new Font("MS UI Gothic", 0, 18));
        this.btnRemove.setText("\u524a\u9664");
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setFont(new Font("MS UI Gothic", 0, 18));
        this.timeRecordView.setFont(new Font("MS UI Gothic", 0, 18));
        this.timeRecordView.setModel(new DefaultTableModel(new Object[][]{{"1", "2", "3"}}, new String[]{"ID", "\u6253\u523b\u65e5\u6642", "\u5834\u6240"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.timeRecordView.setGridColor(new Color(0, 102, 153));
        this.timeRecordView.setRowHeight(20);
        this.jScrollPane1.setViewportView(this.timeRecordView);
        if (this.timeRecordView.getColumnModel().getColumnCount() > 0) {
            this.timeRecordView.getColumnModel().getColumn(0).setMinWidth(100);
            this.timeRecordView.getColumnModel().getColumn(1).setMinWidth(250);
            this.timeRecordView.getColumnModel().getColumn(2).setMinWidth(300);
        }
        this.btnOvernight.setBackground(new Color(0, 153, 153));
        this.btnOvernight.setFont(new Font("MS UI Gothic", 0, 14));
        this.btnOvernight.setText("\u7fcc\u65e5");
        this.btnOvernight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyPanel.this.btnOvernightActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.signal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEmployeeName, -2, 168, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAuthorName, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.bigCalendar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.txtSelectedTime, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel5, -2, 258, -2).addGap(0, 88, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.btnOvernight, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hourSelecter, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.minSelecter, -2, 91, -2)).addGroup(layout.createSequentialGroup().addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnModify).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove))))).addGap(12, 12, 12)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addContainerGap()))))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnSendModifyInfo, -2, 108, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.signal, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.lblEmployeeName).addComponent(this.jLabel3).addComponent(this.lblAuthorName))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bigCalendar1, -2, 275, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 202, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSelectedTime, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAdd).addComponent(this.btnModify).addComponent(this.btnRemove)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minSelecter, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.hourSelecter, -2, -1, -2).addComponent(this.btnOvernight, -1, 25, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSendModifyInfo, -2, 37, -2).addGap(14, 14, 14)));
    }

    private void btnSendModifyInfoActionPerformed(ActionEvent evt) {
        if (this.userCardId.length() < 1 || this.authorCardId.length() < 1) {
            JOptionPane.showMessageDialog(this, "\u5f93\u696d\u54e1ID\u307e\u305f\u306f\u627f\u8a8d\u8005ID\u304c\u8aad\u307f\u8fbc\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (this.btnAdd.isSelected()) {
            this.addTimeRecord();
        }
        if (this.btnModify.isSelected()) {
            this.modifyTimeRecord();
        }
        if (this.btnRemove.isSelected()) {
            this.removeTimeRecord();
        }
    }

    private void btnOvernightActionPerformed(ActionEvent evt) {
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
    }

    private void removeTimeRecord() {
        LocalDateTime datetime = this.getSelectedDatetime();
        if (this.comunicator.removeTimeRecord(this.authorCardId, this.selectedRecordId)) {
            JOptionPane.showMessageDialog(this, "\u524a\u9664\u3057\u307e\u3057\u305f\u3002");
            this.showRecordsOf(datetime.toLocalDate());
        }
        TimeRecordAtClient timerecord = new TimeRecordAtClient();
        timerecord.setJdbcSupplier(this.supplier);
        timerecord.clearValues();
        timerecord.Status.setValue((short)-1);
        timerecord.Mdate.setValue(Timestamp.valueOf(LocalDateTime.now()));
        try {
            timerecord.update(timerecord.CheckDateTime.sameValueOf("'" + this.selectedRecordTime + "'"), timerecord.ScardId.sameValueOf(this.userCardId));
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(ModifyPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void modifyTimeRecord() {
        LocalDateTime datetime = this.getSelectedDatetime();
        if (this.comunicator.modifyTimeRecord(this.authorCardId, this.orgId, this.selectedRecordId, this.getNormalizedDateTimeString(datetime))) {
            JOptionPane.showMessageDialog(this, "\u4fee\u6b63\u3057\u307e\u3057\u305f\u3002");
            this.showRecordsOf(datetime.toLocalDate());
            TimeRecordAtClient timerecord = new TimeRecordAtClient();
            timerecord.setJdbcSupplier(this.supplier);
            timerecord.clearValues();
            timerecord.CheckDateTime.setValue(Timestamp.valueOf(datetime));
            timerecord.Mdate.setValue(Timestamp.valueOf(LocalDateTime.now()));
            if (this.btnOvernight.isSelected()) {
                timerecord.CheckType.setValue((short)3);
            } else {
                timerecord.CheckType.setValue((short)-1);
            }
            try {
                timerecord.update(timerecord.ScardId.sameValueOf(this.userCardId), timerecord.AuthorCardId.sameValueOf(this.authorCardId), timerecord.OrganizationId.sameValueOf(this.orgId));
            }
            catch (ClearfyDatabaseException ex) {
                Logger.getLogger(ModifyPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void addTimeRecord() {
        LocalDateTime datetime = this.getSelectedDatetime();
        short status = 1;
        if (this.comunicator.addTimeRecord(this.userCardId, this.authorCardId, this.orgId, this.getNormalizedDateTimeString(datetime))) {
            JOptionPane.showMessageDialog(this, "\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002");
            this.showRecordsOf(datetime.toLocalDate());
            status = 0;
        }
        TimeRecordAtClient timerecord = new TimeRecordAtClient();
        timerecord.setJdbcSupplier(this.supplier);
        timerecord.clearValues();
        timerecord.ScardId.setValue(this.userCardId);
        timerecord.AuthorCardId.setValue(this.authorCardId);
        timerecord.OrganizationId.setValue(Integer.valueOf(this.orgId));
        if (this.btnOvernight.isSelected()) {
            timerecord.CheckType.setValue((short)3);
        } else {
            timerecord.CheckType.setValue((short)-1);
        }
        timerecord.CheckDateTime.setValue(Timestamp.valueOf(datetime));
        timerecord.Status.setValue(status);
        timerecord.insert();
    }

    public LocalDateTime getSelectedDatetime() {
        LocalDate date = this.bigCalendar1.getSelectedDate();
        LocalTime time = LocalTime.of(Integer.valueOf((String)this.hourSelecter.getSelectedItem()), Integer.valueOf((String)this.minSelecter.getSelectedItem()), 0);
        LocalDateTime datetime = LocalDateTime.of(date, time);
        return datetime;
    }

    public String getNormalizedDateTimeString(LocalDateTime datetime) {
        String rvalue = datetime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return rvalue;
    }

    private void onSelectionRowChanged(ListSelectionEvent e) {
        int index;
        boolean selectionOk = false;
        DefaultTableModel model = (DefaultTableModel)this.timeRecordView.getModel();
        if (model.getRowCount() > 0 && (index = this.timeRecordView.getSelectedRow()) < model.getRowCount() && index > -1) {
            String recid;
            this.selectedRecordId = recid = (String)model.getValueAt(index, 0);
            String recTime = (String)model.getValueAt(index, 1);
            this.txtSelectedTime.setText(recTime);
            this.selectedRecordTime = recTime;
            selectionOk = true;
        }
        if (!selectionOk) {
            this.txtSelectedTime.setText("");
        }
    }

    public Communicator getComunicator() {
        return this.comunicator;
    }

    public void setComunicator(Communicator comunicator) {
        this.comunicator = comunicator;
    }
}

