/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.timcard.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.timcard.client.CardReader;
import org.clearfy.timcard.client.Communicator;
import org.clearfy.timcard.client.ICardReaderProcedure;
import org.clearfy.timcard.client.ICommunicatorContainer;
import org.clearfy.timcard.client.TimeCardClient;
import org.clearfy.timcard.client.data.Attributes;

public abstract class ControlPanel
extends JPanel
implements ICardReaderProcedure,
ICommunicatorContainer {
    private CardReader cardReader;
    private Attributes attributes;
    private IJdbcSupplier supplier;
    private Properties shopList;
    private Communicator communicator;
    private String shopId;
    private String shopName;
    private TimeCardClient parentForm;
    private JButton btnCommit;
    private JButton btnConnect;
    private JButton btnDirSelect;
    private JComboBox<String> cmbShop;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField txtApi;
    private JTextField txtNfcpyPath;
    private JTextField txtUrl;

    public ControlPanel() {
        this.initComponents();
        this.cmbShop.removeAllItems();
    }

    @Override
    public Communicator getCommunicator() {
        return this.communicator;
    }

    @Override
    public void setCommunicator(Communicator communicator) {
        this.communicator = communicator;
    }

    @Override
    public void setJdbcSupplier(IJdbcSupplier supplier) {
        this.supplier = supplier;
    }

    @Override
    public void doProcess(String cardId) {
        System.out.println(this.getClass().getName() + "<-" + cardId);
    }

    @Override
    public void bindSignalLabel() {
    }

    public void loadSetting() {
        this.attributes = new Attributes();
        this.attributes.setJdbcSupplier(this.supplier);
        String api = this.findAttribute("api");
        this.txtApi.setText(api);
        String url = this.findAttribute("url");
        this.txtUrl.setText(url);
        String nfcpyPath = this.findAttribute("nfcpy_path");
        this.txtNfcpyPath.setText(nfcpyPath);
        this.shopId = this.findAttribute("shopid");
        this.shopName = this.findAttribute("shopName");
        this.cmbShop.removeAllItems();
        this.cmbShop.addItem(this.shopName);
        this.cmbShop.setSelectedItem(this.shopName);
        this.communicator = new Communicator(this.supplier);
        this.onSettingChanged();
    }

    public String getNfcpyPath() {
        return this.txtNfcpyPath.getText();
    }

    public String findAttribute(String key) {
        String rvalue = "";
        ResultSet rs = this.attributes.select(this.attributes.AttributeKey.sameValueOf(key));
        if (rs != null) {
            try {
                if (rs.next()) {
                    rvalue = rs.getString(this.attributes.AttributeValue.getName());
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ControlPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return rvalue;
    }

    @Override
    public void setCardReader(CardReader reader) {
        this.cardReader = reader;
    }

    public void initializeCardInfo() {
    }

    public boolean isNfcpyFind() {
        return false;
    }

    public String getShopId() {
        return this.shopId;
    }

    @Override
    public void setParentForm(TimeCardClient form) {
        this.parentForm = form;
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.txtUrl = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.cmbShop = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtNfcpyPath = new JTextField();
        this.btnDirSelect = new JButton();
        this.jLabel4 = new JLabel();
        this.txtApi = new JTextField();
        this.btnCommit = new JButton();
        this.btnConnect = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.jLabel3.setFont(new Font("SansSerif", 1, 14));
        this.jLabel3.setText("URL");
        this.txtUrl.setFont(new Font("SansSerif", 1, 14));
        this.jLabel5.setFont(new Font("SansSerif", 1, 14));
        this.jLabel5.setText("\u30b5\u30fc\u30d0\u30fc");
        this.jLabel6.setFont(new Font("SansSerif", 1, 14));
        this.jLabel6.setText("\u4f1a\u793e/\u5e97\u8217");
        this.cmbShop.setFont(new Font("SansSerif", 1, 14));
        this.cmbShop.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ControlPanel.this.cmbShopItemStateChanged(evt);
            }
        });
        this.cmbShop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.cmbShopActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("SansSerif", 1, 14));
        this.jLabel1.setText("\u30ab\u30fc\u30c9\u30ea\u30fc\u30c0");
        this.jLabel2.setFont(new Font("SansSerif", 1, 14));
        this.jLabel2.setText("nfcpy\u306e\u30d1\u30b9");
        this.txtNfcpyPath.setFont(new Font("SansSerif", 1, 14));
        this.btnDirSelect.setFont(new Font("SansSerif", 1, 14));
        this.btnDirSelect.setText("...");
        this.btnDirSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.btnDirSelectActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("SansSerif", 1, 14));
        this.jLabel4.setText("API\u30ad\u30fc");
        this.txtApi.setFont(new Font("SansSerif", 1, 14));
        this.btnCommit.setFont(new Font("SansSerif", 1, 14));
        this.btnCommit.setText("\u9069\u7528");
        this.btnCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.btnCommitActionPerformed(evt);
            }
        });
        this.btnConnect.setFont(new Font("SansSerif", 1, 14));
        this.btnConnect.setText("\u63a5\u7d9a");
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.btnConnectActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.txtApi)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -2, 0, Short.MAX_VALUE)))).addGap(377, 377, 377)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.txtUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnConnect, -2, 76, -2)))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel2)).addComponent(this.jLabel4, -2, 78, -2)).addGap(0, 345, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.txtNfcpyPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnCommit, -1, 81, Short.MAX_VALUE).addComponent(this.btnDirSelect, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.cmbShop, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtApi, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtUrl, -2, -1, -2).addComponent(this.btnConnect)).addGap(6, 6, 6).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbShop, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtNfcpyPath, -2, -1, -2).addComponent(this.btnDirSelect)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnCommit, -2, 30, -2).addContainerGap()));
    }

    private void btnDirSelectActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showOpenDialog(this) == 0) {
            String filePath = chooser.getSelectedFile().getAbsolutePath();
            this.txtNfcpyPath.setText(filePath);
        }
    }

    public abstract void onSettingChanged();

    private void btnCommitActionPerformed(ActionEvent evt) {
        this.attributes.merge(this.attributes.AttributeKey.setValue("api"), this.attributes.AttributeValue.setValue(this.txtApi.getText()));
        this.attributes.merge(this.attributes.AttributeKey.setValue("url"), this.attributes.AttributeValue.setValue(this.txtUrl.getText()));
        this.attributes.merge(this.attributes.AttributeKey.setValue("nfcpy_path"), this.attributes.AttributeValue.setValue(this.txtNfcpyPath.getText()));
        this.onSettingChanged();
        JOptionPane.showMessageDialog(this, "\u8a2d\u5b9a\u3092\u53cd\u6620\u3057\u307e\u3057\u305f\u3002");
    }

    private void btnConnectActionPerformed(ActionEvent evt) {
        this.communicator = new Communicator(this.supplier);
        String msg = "";
        boolean connected = false;
        if (this.communicator.touch()) {
            msg = "\u30b5\u30fc\u30d0\u30fc\u306b\u63a5\u7d9a\u3067\u304d\u307e\u3057\u305f\u3002";
            connected = true;
        } else {
            msg = "\u30b5\u30fc\u30d0\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002URL\u307e\u305f\u306fAPI\u30ad\u30fc\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044.";
        }
        JOptionPane.showMessageDialog(this, msg);
        String currentSelectedItem = (String)this.cmbShop.getSelectedItem();
        if (connected) {
            this.cmbShop.removeAllItems();
            this.shopList = this.communicator.getOrgList();
            for (int i = 0; i < this.shopList.size(); ++i) {
                String name = this.shopList.getProperty(String.valueOf(i));
                this.cmbShop.addItem(name);
            }
        }
        if (currentSelectedItem.trim().length() > 0) {
            this.cmbShop.setSelectedItem(currentSelectedItem);
        }
    }

    private void cmbShopItemStateChanged(ItemEvent evt) {
        String name = (String)evt.getItem();
        this.shopId = this.communicator.getShopId(name);
        this.attributes.merge(this.attributes.AttributeKey.setValue("shopid"), this.attributes.AttributeValue.setValue(this.shopId));
        this.attributes.merge(this.attributes.AttributeKey.setValue("shopName"), this.attributes.AttributeValue.setValue(name));
    }

    private void cmbShopActionPerformed(ActionEvent evt) {
    }
}

