/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.timcard.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.timcard.client.ModifyPanel;
import org.clearfy.timcard.client.data.Attributes;

public class Communicator {
    private String apiKey;
    private String serverUrl;
    private Properties shopList;
    private String errMessage;
    private boolean alive;

    public Communicator(IJdbcSupplier supplier) {
        this.apiKey = this.getAttributes(supplier, "api");
        this.serverUrl = this.getAttributes(supplier, "url");
        this.shopList = new Properties();
        this.touch();
    }

    public boolean isServerAlived() {
        return this.alive;
    }

    public JsonNode getJsonNode(String json) {
        JsonNode rvalue = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            rvalue = mapper.readTree(json);
        }
        catch (IOException ex) {
            Logger.getLogger(ModifyPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public Properties getShopList() {
        return this.shopList;
    }

    public String getAttributes(IJdbcSupplier supplier, String key) {
        String rvalue = "";
        Attributes attributes = new Attributes();
        attributes.setJdbcSupplier(supplier);
        try {
            ResultSet rs = attributes.select(attributes.AttributeKey.sameValueOf(key));
            if (rs.next()) {
                rvalue = rs.getString(attributes.AttributeValue.getName());
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Communicator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public boolean touch() {
        String[][] params = new String[][]{{"method", "touch"}, {"apikey", this.apiKey}};
        String json = this.getJason(params);
        if (json.contains("SUCCESS") && json.contains("\"RESULT\":\"TOUCHED\"")) {
            this.alive = true;
            return true;
        }
        this.alive = false;
        return false;
    }

    public boolean record(String userId, String orgId, String newTime, String checkType, String messageKey) {
        String[][] params = new String[][]{{"method", "record"}, {"apikey", this.apiKey}, {"cardid", userId}, {"orgid", orgId}, {"checktype", checkType}, {"datetime", newTime}, {"msgkey", messageKey}};
        String json = this.getJason(params);
        if (json.contains("SUCCESS")) {
            return true;
        }
        this.errMessage = this.getJsonNode(json).get("MESSAGE").asText();
        return false;
    }

    public boolean addTimeRecord(String userId, String authId, String orgId, String newTime) {
        String[][] params = new String[][]{{"method", "append"}, {"apikey", this.apiKey}, {"cardid", userId}, {"authorid", authId}, {"orgid", orgId}, {"newtime", newTime}};
        String json = this.getJason(params);
        return json.contains("SUCCESS");
    }

    public boolean modifyTimeRecord(String authId, String orgId, String recordId, String newTime) {
        String[][] params = new String[][]{{"method", "overwrite"}, {"apikey", this.apiKey}, {"authorid", authId}, {"orgid", orgId}, {"timerecordid", recordId}, {"newtime", newTime}};
        String json = this.getJason(params);
        return json.contains("SUCCESS");
    }

    public boolean removeTimeRecord(String authId, String recordId) {
        String[][] params = new String[][]{{"method", "remove"}, {"apikey", this.apiKey}, {"authorid", authId}, {"timerecordid", recordId}};
        String json = this.getJason(params);
        return json.contains("SUCCESS");
    }

    public boolean isCardExists(String cardId) {
        String[][] params = new String[][]{{"method", "isexist"}, {"apikey", this.apiKey}, {"cardid", cardId}};
        String json = this.getJason(params);
        return json.contains("SUCCESS");
    }

    public String getUserInfo(String cardId) {
        String[][] params = new String[][]{{"method", "isexist"}, {"apikey", this.apiKey}, {"cardid", cardId}};
        return this.getJason(params);
    }

    public String getRecordsOf(String cardId, LocalDate date) {
        String rvalue = null;
        String[][] params = new String[][]{{"method", "getrecord"}, {"apikey", this.apiKey}, {"cardid", cardId}, {"period", "day"}, {"from", date.atTime(0, 0).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))}};
        rvalue = this.getJason(params);
        return rvalue;
    }

    public Properties getOrgList() {
        this.shopList.clear();
        String rvalue = "";
        String[][] parameters = new String[][]{{"apikey", this.apiKey}, {"method", "getorglist"}};
        String json = this.getJason(parameters);
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jnode = mapper.readTree(json);
            String result = jnode.get("STATUS").asText();
            if (result.equals("SUCCESS")) {
                jnode = jnode.get("RESULT");
                for (int i = 0; i < jnode.size(); ++i) {
                    JsonNode company = jnode.get(i);
                    String orgId = company.get("ORGANIZATION_ID").asText();
                    String orgName = company.get("ORGANIZATION_NAME").asText();
                    this.shopList.setProperty(orgId, orgName);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Communicator.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println(json);
        return this.shopList;
    }

    public String getShopId(String name) {
        String rvalue = "";
        if (this.shopList.size() < 1) {
            this.shopList = this.getOrgList();
        }
        for (Object key : this.shopList.keySet()) {
            String szKey = (String)key;
            if (!this.shopList.getProperty(szKey).equals(name)) continue;
            rvalue = szKey;
        }
        return rvalue;
    }

    public String getJason(String[][] param) {
        String result = "";
        String params = this.getPostParameters(param);
        try {
            URL url = new URL(this.serverUrl);
            HttpURLConnection httpcon = (HttpURLConnection)url.openConnection();
            httpcon.setDoOutput(true);
            httpcon.setRequestMethod("POST");
            httpcon.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            try (OutputStreamWriter writer = new OutputStreamWriter(httpcon.getOutputStream());){
                writer.write(params);
                writer.flush();
            }
            httpcon.connect();
            if (httpcon.getResponseCode() == 200) {
                String line;
                InputStreamReader reader = new InputStreamReader(httpcon.getInputStream(), "UTF-8");
                BufferedReader br = new BufferedReader(reader);
                while ((line = br.readLine()) != null) {
                    result = result + line;
                }
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(Communicator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Communicator.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println(result);
        return result;
    }

    public String getPostParameters(String[][] params) {
        String rvalue = "";
        for (String[] param : params) {
            String line = "&" + param[0] + "=" + param[1];
            rvalue = rvalue + line;
        }
        rvalue = rvalue.substring(1);
        return rvalue;
    }

    public String getErrorMessage() {
        return this.errMessage;
    }

    public boolean isAlived() {
        return this.alive;
    }
}

