/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.timcard.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javazoom.jlgui.basicplayer.BasicPlayer;
import javazoom.jlgui.basicplayer.BasicPlayerException;
import org.clearfy.timcard.client.ICardReaderProcedure;

public abstract class CardReader
extends Thread {
    private String pythonPath = "/var/lib/nfcpy-master/examples/tagtool.py";
    private String currentId = "";
    private JLabel signal;
    private Process process;
    private boolean loop = true;
    private BasicPlayer player = new BasicPlayer();
    private ICardReaderProcedure cardProc;
    private int mySignal = 0;
    private static final int MYSIGNAL_RED = 0;
    private static final int MYSIGNAL_BLUE = 1;

    public void setCardReaderProcedure(ICardReaderProcedure proc) {
        this.cardProc = proc;
        this.cardProc.setCardReader(this);
        this.cardProc.bindSignalLabel();
    }

    public ICardReaderProcedure getCardReaderProcedure() {
        return this.cardProc;
    }

    public String getCurrentId() {
        return this.currentId;
    }

    public JLabel getSignal() {
        return this.signal;
    }

    public void setSignal(JLabel signal) {
        this.signal = signal;
        switch (this.mySignal) {
            case 1: {
                this.setSignalBlue();
                break;
            }
            case 0: {
                this.setSignalRed();
            }
        }
    }

    public void resetId() {
        this.currentId = "";
    }

    public List<CardTerminal> getTerminals() {
        return new ArrayList<CardTerminal>();
    }

    public String readIDm() throws CardException {
        return "";
    }

    public void killProcess() {
        if (this.process != null) {
            this.loop = false;
            this.process.destroy();
        }
    }

    public void setNfcpyPath(String path) {
        this.pythonPath = path;
    }

    @Override
    public void run() {
        while (this.loop) {
            try {
                File f = new File(this.pythonPath);
                if (f.exists()) {
                    ProcessBuilder pb = new ProcessBuilder("python", this.pythonPath);
                    System.out.println(this.pythonPath);
                    pb.redirectErrorStream(true);
                    this.setSignalBlue();
                    this.process = pb.start();
                    String id = this.getIDm(this.process.getInputStream());
                    if (id.equals("ERROR")) {
                        JOptionPane.showMessageDialog(null, "\u30ab\u30fc\u30c9\u30ea\u30fc\u30c0\u3092\u633f\u3057\u306a\u304a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    }
                    String err = this.getErrStream(this.process.getErrorStream());
                    if (id.length() > 0) {
                        this.currentId = id;
                        if (this.signal != null) {
                            this.setSignalRed();
                            try {
                                InputStream sound = this.getClass().getClassLoader().getResourceAsStream("itemgetsec.mp3");
                                System.out.println(sound.toString());
                                this.player.open(sound);
                                this.player.play();
                            }
                            catch (BasicPlayerException ex) {
                                Logger.getLogger(CardReader.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        System.out.println(id);
                        this.cardProc.doProcess(id);
                    }
                }
                Thread.sleep(1000L);
            }
            catch (IOException | InterruptedException ex) {
                Logger.getLogger(CardReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setSignalBlue() {
        this.signal.setIcon(new ImageIcon(this.getClass().getResource("/blue.png")));
        this.signal.setText("\u8aad\u53d6\u53ef");
        this.signal.repaint();
        this.mySignal = 1;
    }

    public void setSignalRed() {
        this.signal.setIcon(new ImageIcon(this.getClass().getResource("/red.png")));
        this.signal.setText("\u51e6\u7406\u4e2d");
        this.signal.repaint();
        this.mySignal = 0;
    }

    public abstract void onIdRead(String var1);

    public String getErrStream(InputStream is) throws IOException {
        return this.printInputStream(is);
    }

    public String getIDm(InputStream is) throws IOException {
        String rvalue = "";
        String data = this.printInputStream(is);
        System.out.println(data);
        if (!data.contains("ID=")) {
            if (data.contains("TypeError")) {
                return "ERROR";
            }
            return "";
        }
        int offset = data.indexOf("ID=") + "ID=".length();
        data = data.substring(offset);
        offset = data.indexOf(" ", 0);
        rvalue = data = data.substring(0, offset);
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printInputStream(InputStream is) throws IOException {
        String rvalue = "";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = br.readLine()) != null) {
                rvalue = rvalue + line + "\n";
            }
        }
        return rvalue;
    }
}

