/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.timcard.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.clearfy.timcard.client.DayButton;
import org.clearfy.timcard.client.WeekPanel;

public class BigCalendar
extends JPanel {
    private WeekPanel[] weeks = new WeekPanel[6];
    private DayButton[] dayButtons = new DayButton[42];
    private LocalDate selectedDay = LocalDateTime.now().toLocalDate();
    private JButton btnNextMonth;
    private JButton btnPrevMonth;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JComboBox<String> monthSelecter;
    private JButton toToday;
    private WeekPanel week0;
    private WeekPanel week1;
    private WeekPanel week2;
    private WeekPanel week3;
    private WeekPanel week4;
    private WeekPanel week5;
    private JComboBox<String> yearSelecter;

    public BigCalendar() {
        int i;
        this.initComponents();
        this.weeks[0] = this.week0;
        this.weeks[1] = this.week1;
        this.weeks[2] = this.week2;
        this.weeks[3] = this.week3;
        this.weeks[4] = this.week4;
        this.weeks[5] = this.week5;
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int j = 0; j < 7; ++j) {
                final DayButton button = this.get(i2, j);
                button.setMyBackColor(DayButton.otherMonthColor);
                button.toMyBackColor();
                button.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        BigCalendar.this.onButtonSelcted(button);
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        BigCalendar.this.onButtonUnselected(button);
                    }
                });
            }
        }
        LocalDateTime currentTime = LocalDateTime.now();
        int year = currentTime.getYear();
        for (i = year - 5; i < year + 6; ++i) {
            this.yearSelecter.addItem(String.valueOf(i));
        }
        for (i = 1; i < 13; ++i) {
            this.monthSelecter.addItem(String.valueOf(i));
        }
    }

    public LocalDate getSelectedDate() {
        return this.selectedDay;
    }

    public void onButtonUnselected(DayButton target) {
        target.toMyBackColor();
    }

    public void onButtonSelcted(DayButton target) {
        target.setBackground(DayButton.selectedColor);
        if (target.getText().length() > 0) {
            int year = Integer.valueOf(this.yearSelecter.getSelectedItem().toString());
            int month = Integer.valueOf(this.monthSelecter.getSelectedItem().toString());
            int day = Integer.valueOf(target.getText());
            this.selectedDay = LocalDate.of(year, month, day);
            System.out.println(this.selectedDay.toString());
        }
    }

    public DayButton get(int week, int day) {
        DayButton rvalue = null;
        if (week > -1 && week < 6 && day > -1 && day < 7) {
            rvalue = this.weeks[week].getButton(day);
        }
        if (rvalue == null) {
            throw new IndexOutOfBoundsException();
        }
        return rvalue;
    }

    public void addActionListener(ActionListener listener) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.get(i, j).addActionListener(listener);
            }
        }
    }

    public void showMonth(LocalDate yearMonth) {
        if (((String)this.yearSelecter.getSelectedItem()).equals(String.valueOf(yearMonth.getYear())) && ((String)this.monthSelecter.getSelectedItem()).equals(String.valueOf(yearMonth.getMonthValue()))) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                DayButton button = this.get(i, j);
                button.setMyBackColor(DayButton.otherMonthColor);
                button.toMyBackColor();
                button.setDate(null);
            }
        }
        this.yearSelecter.setSelectedItem(String.valueOf(yearMonth.getYear()));
        this.monthSelecter.setSelectedItem(String.valueOf(yearMonth.getMonthValue()));
        LocalDateTime targetMonth = LocalDateTime.of(yearMonth, LocalTime.of(0, 0));
        ZoneId zone = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = ZonedDateTime.of(targetMonth, zone);
        GregorianCalendar calendar = GregorianCalendar.from(zonedDateTime);
        int maxDay = calendar.getActualMaximum(5);
        int weekCount = 0;
        for (int day = 1; day <= maxDay; ++day) {
            calendar.set(5, day);
            int dayOfWeek = calendar.get(7);
            DayButton button = this.get(weekCount, dayOfWeek - 1);
            button.setDate(yearMonth.withDayOfMonth(day));
            switch (dayOfWeek) {
                case 1: {
                    button.toSundayColor();
                    break;
                }
                case 7: {
                    button.toSaturdayColor();
                    break;
                }
                default: {
                    button.toNormaldayColor();
                }
            }
            if (dayOfWeek != 7) continue;
            ++weekCount;
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.toToday = new JButton();
        this.jSeparator2 = new JSeparator();
        this.yearSelecter = new JComboBox();
        this.monthSelecter = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.btnPrevMonth = new JButton();
        this.btnNextMonth = new JButton();
        this.jPanel2 = new JPanel();
        this.week0 = new WeekPanel();
        this.week1 = new WeekPanel();
        this.week2 = new WeekPanel();
        this.week3 = new WeekPanel();
        this.week4 = new WeekPanel();
        this.week5 = new WeekPanel();
        this.setBackground(new Color(0, 153, 153));
        this.setLayout(new BorderLayout());
        this.jPanel1.setBackground(new Color(0, 0, 0));
        this.jPanel1.setLayout(new FlowLayout(1, 5, 1));
        this.toToday.setBackground(new Color(0, 153, 153));
        this.toToday.setFont(new Font("MS UI Gothic", 0, 18));
        this.toToday.setText("\u4eca\u65e5");
        this.toToday.setMargin(new Insets(2, 2, 2, 2));
        this.toToday.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BigCalendar.this.toTodayActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.toToday);
        this.jPanel1.add(this.jSeparator2);
        this.yearSelecter.setBackground(new Color(0, 153, 153));
        this.yearSelecter.setFont(new Font("MS UI Gothic", 0, 18));
        this.yearSelecter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BigCalendar.this.yearSelecterItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.yearSelecter);
        this.monthSelecter.setBackground(new Color(0, 153, 153));
        this.monthSelecter.setFont(new Font("MS UI Gothic", 0, 18));
        this.monthSelecter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BigCalendar.this.monthSelecterItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.monthSelecter);
        this.jPanel1.add(this.jSeparator1);
        this.btnPrevMonth.setBackground(new Color(0, 153, 153));
        this.btnPrevMonth.setIcon(new ImageIcon(this.getClass().getResource("/left.png")));
        this.btnPrevMonth.setMargin(new Insets(3, 5, 3, 5));
        this.btnPrevMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BigCalendar.this.btnPrevMonthActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnPrevMonth);
        this.btnNextMonth.setBackground(new Color(0, 153, 153));
        this.btnNextMonth.setIcon(new ImageIcon(this.getClass().getResource("/right.png")));
        this.btnNextMonth.setMargin(new Insets(3, 5, 3, 5));
        this.btnNextMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BigCalendar.this.btnNextMonthActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnNextMonth);
        this.add((Component)this.jPanel1, "First");
        this.jPanel2.setBackground(new Color(0, 0, 0));
        this.jPanel2.setLayout(new GridLayout(6, 1));
        this.jPanel2.add(this.week0);
        this.jPanel2.add(this.week1);
        this.jPanel2.add(this.week2);
        this.jPanel2.add(this.week3);
        this.jPanel2.add(this.week4);
        this.jPanel2.add(this.week5);
        this.add((Component)this.jPanel2, "Center");
    }

    private void btnNextMonthActionPerformed(ActionEvent evt) {
        LocalDate target = this.selectedDay.plusMonths(1L);
        this.selectDate(target);
    }

    private void btnPrevMonthActionPerformed(ActionEvent evt) {
        LocalDate target = this.selectedDay.minusMonths(1L);
        this.selectDate(target);
    }

    private void toTodayActionPerformed(ActionEvent evt) {
        LocalDate today = LocalDate.now();
        this.selectDate(today);
    }

    private void yearSelecterItemStateChanged(ItemEvent evt) {
        this.onYearMonthChanged();
    }

    private void monthSelecterItemStateChanged(ItemEvent evt) {
        this.onYearMonthChanged();
    }

    private void onYearMonthChanged() {
        if (this.yearSelecter.getSelectedItem() == null || this.monthSelecter.getSelectedItem() == null) {
            return;
        }
        LocalDate target = LocalDate.of((int)Integer.valueOf((String)this.yearSelecter.getSelectedItem()), Integer.valueOf((String)this.monthSelecter.getSelectedItem()), this.selectedDay.getDayOfMonth());
        this.selectDate(target);
    }

    public void selectDate(LocalDate targetDate) {
        this.showMonth(targetDate);
        int day = targetDate.getDayOfMonth();
        block0: for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 7; ++col) {
                int iday;
                DayButton btn = this.get(row, col);
                String dayString = btn.getText();
                if (dayString.length() <= 0 || (iday = Integer.valueOf(dayString).intValue()) != day) continue;
                btn.setBackground(DayButton.selectedColor);
                btn.requestFocus();
                continue block0;
            }
        }
        this.selectedDay = targetDate;
    }
}

