/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard.component;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;

public class WorkTimeSummary
extends ClearfyContentHolder {
    private Label workdaycount;
    private Label worktimeNormal;
    private Label overtime;
    private Label latetime;
    private Label paidholiday;
    private int employeeId = -1;
    private int year = -1;
    private int month = -1;

    public WorkTimeSummary(String id, ClearfyPage page) {
        super(id, page);
    }

    public void drawSummary(int employeeId, int year, int month) {
        try {
            LocalDate start = LocalDate.of(year, month, 1);
            LocalDate end = start.plusMonths(1L);
            String cmd = "select \n    sum(case when WORK_TIME > 0 THEN 1 else 0 end) RECCOUNT,\n    convert(SUM(WORK_TIME), decimal(18,2)) WTIME,\n    convert(SUM(OVER_TIME), decimal(18,2)) OTIME,\n    convert(SUM(LATENIGHT_TIME), decimal(18,2)) LNTIME, \n    convert(SUM(PAID_HOLIDAY), decimal(18,2)) PAIDH \n FROM WORKTIME_REPORT\n where \n    REC_DATE >= '%s' and REC_DATE < '%s' and\n    EMPLOYEE_ID =%d and (WORK_TIME > 0 or PAID_HOLIDAY > 0) ";
            cmd = String.format(cmd, start.toString(), end.toString(), employeeId);
            ResultSet rs = this.getDataController().select(cmd);
            if (rs.next()) {
                this.workdaycount.setDefaultModelObject(rs.getString("RECCOUNT"));
                if (rs.getInt("RECCOUNT") > 0) {
                    this.worktimeNormal.setDefaultModelObject(rs.getBigDecimal("WTIME").toString());
                    this.overtime.setDefaultModelObject(rs.getBigDecimal("OTIME").toString());
                    this.latetime.setDefaultModelObject(rs.getBigDecimal("LNTIME").toString());
                } else {
                    this.worktimeNormal.setDefaultModelObject("0.0");
                    this.overtime.setDefaultModelObject("0.0");
                    this.latetime.setDefaultModelObject("0.0");
                }
                BigDecimal paidh = rs.getBigDecimal("PAIDH");
                if (paidh != null) {
                    this.paidholiday.setDefaultModelObject(rs.getBigDecimal("PAIDH").toString());
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkTimeSummary.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void drawContent() {
        this.workdaycount = new Label("workdaycount", Model.of(""));
        this.add(this.workdaycount);
        this.worktimeNormal = new Label("worktimeNormal", Model.of(""));
        this.add(this.worktimeNormal);
        this.overtime = new Label("overtime", Model.of(""));
        this.add(this.overtime);
        this.latetime = new Label("latetime", Model.of(""));
        this.add(this.latetime);
        this.paidholiday = new Label("paidholiday", Model.of(""));
        this.add(this.paidholiday);
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u52e4\u52d9\u96c6\u8a08\u7d50\u679c");
    }

    @Override
    public void initializeMenu() {
    }
}

