/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard.component;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.components.tableview.Field;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.ResultSetProvider;
import org.clearfy.components.tableview.SelectableColumn;
import org.clearfy.components.tableview.TableView;

public abstract class CalendarTable
extends TableView {
    private String dayFieldName = "";

    public CalendarTable(String id, ClearfyPage page) {
        super(id, page);
    }

    public void drawCalendar(int year, int month) {
        this.clear();
        SelectableColumn reccntl = new SelectableColumn(new Model<String>(this.getSentence("\u65e5\u4ed8")), "\u65e5\u4ed8", this){

            @Override
            public void onSelected(AjaxRequestTarget target, Record selected) {
                CalendarTable.this.onRecordSelected(target, selected);
            }
        };
        this.columns.add(reccntl);
        PropertyColumn pcol = new PropertyColumn(new Model<String>(this.getSentence("\u66dc\u65e5")), "\u66dc\u65e5", "\u66dc\u65e5");
        this.columns.add(pcol);
        LocalDate targetMonth = LocalDate.of(year, month, 1);
        int dayCount = targetMonth.lengthOfMonth();
        String dayCaption = this.getSentence("\u65e5\u4ed8");
        String weekDayCaption = this.getSentence("\u66dc\u65e5");
        for (int i = 1; i <= dayCount; ++i) {
            targetMonth = targetMonth.withDayOfMonth(i);
            Field dayNum = new Field(dayCaption, String.valueOf(i));
            Field weekDay = new Field(weekDayCaption, targetMonth.getDayOfWeek().getDisplayName(TextStyle.NARROW, Locale.JAPANESE));
            this.resultSetProvider.select(new Field[]{dayNum, weekDay});
        }
    }

    @Override
    public void select(String cmd) {
        block10: {
            try {
                ResultSet rs = this.getDataController().select(cmd);
                ResultSetMetaData meta = rs.getMetaData();
                int colcount = rs.getMetaData().getColumnCount();
                ArrayList<String> captions = new ArrayList<String>();
                for (int i = 1; i < colcount; ++i) {
                    String colName = rs.getMetaData().getColumnLabel(i);
                    captions.add(this.getSentence(colName));
                    if (this.dayFieldName.equals(colName)) continue;
                    PropertyColumn pcol = new PropertyColumn(new Model<Serializable>((Serializable)captions.get(i - 1)), colName, colName);
                    this.columns.add(pcol);
                }
                if (!rs.next()) break block10;
                int cday = 0;
                while ((long)cday < this.resultSetProvider.size()) {
                    int metac;
                    Record rec = this.resultSetProvider.get(cday);
                    int iday = Integer.valueOf(rec.getField(this.dayFieldName));
                    int rsday = rs.getTimestamp(this.dayFieldName).toLocalDateTime().getDayOfMonth();
                    Field[] fields = new Field[captions.size() - 1];
                    int fc = 0;
                    if (iday == rsday) {
                        if (iday == 10) {
                            System.out.println("stop");
                        }
                        for (metac = 0; metac < captions.size(); ++metac) {
                            if (meta.getColumnLabel(metac + 1).equals(this.dayFieldName)) continue;
                            fields[fc] = new Field((String)captions.get(metac), rs.getString(metac + 1));
                            ++fc;
                        }
                        if (!rs.next()) {
                            rec.setFields(fields);
                            break;
                        }
                    } else {
                        for (metac = 0; metac < captions.size(); ++metac) {
                            if (meta.getColumnLabel(metac + 1).equals(this.dayFieldName)) continue;
                            fields[fc] = new Field((String)captions.get(metac), "");
                            ++fc;
                        }
                    }
                    rec.setFields(fields);
                    ++cday;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(CalendarTable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setDayFieldName(String name) {
        this.dayFieldName = name;
    }

    @Override
    public void afterCreateColumns(List<IColumn<Record, String>> columns) {
    }

    @Override
    public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
    }

    @Override
    public void defineSorter(ResultSetProvider resultSetProvider) {
    }

    @Override
    public void initializeMenu() {
    }
}

