/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.admin.organization.OrganizationSelecter;
import org.clearfy.components.MonthPicker;
import org.clearfy.components.tableview.DataTableView;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.ResultSetProvider;
import org.clearfy.plugin.employee.EmployeeSelecter;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDateTime;

public class WorkTimeSummary
extends ClearfySection {
    private OrganizationSelecter companySelecter;
    private EmployeeSelecter employeeSelecter;
    private Label spanSelecterLabel;
    private MonthPicker yearMonthFrom;
    private MonthPicker yearMonthTo;
    private DataTableView summaryView;
    private Label labelTotalView;
    private DataTableView totalView;
    private String employeeId;

    public WorkTimeSummary(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.companySelecter = new OrganizationSelecter("companySelecter", this.page){

            @Override
            public int getMode() {
                return 0;
            }

            @Override
            public String getTitle() {
                return this.getSentence("\u4f1a\u793e\u9078\u629e");
            }

            @Override
            public void onSelected(AjaxRequestTarget target, Record record) {
                WorkTimeSummary.this.onCompanySelected(target, record);
            }
        };
        this.companySelecter.setOutputMarkupId(true);
        this.add(this.companySelecter);
        this.employeeSelecter = new EmployeeSelecter("employeeSelecter", this.page){

            @Override
            public String getTitle() {
                return this.getSentence("\u5f93\u696d\u8005\u9078\u629e");
            }

            @Override
            public void onEmployeeSelected(AjaxRequestTarget target, Record record) {
                WorkTimeSummary.this.onEmployeeSelected(target, record);
            }
        };
        this.employeeSelecter.setOutputMarkupId(true);
        this.add(this.employeeSelecter);
        this.spanSelecterLabel = new Label("spanSelecterLabel", (Serializable)((Object)this.getSentence("\u8868\u793a\u671f\u9593")));
        this.add(this.spanSelecterLabel);
        this.yearMonthFrom = new MonthPicker("yearMonthFrom", this.page){

            @Override
            public void onYearMonthChanged(AjaxRequestTarget target) {
                WorkTimeSummary.this.select(target);
            }
        };
        this.yearMonthFrom.setYear(LocalDateTime.now().get(DateTimeFieldType.year()) - 1);
        this.yearMonthFrom.setLabelCaption("\u958b\u59cb\u5e74\u6708");
        this.yearMonthFrom.setOutputMarkupId(true);
        this.add(this.yearMonthFrom);
        this.yearMonthTo = new MonthPicker("yearMonthTo", this.page){

            @Override
            public void onYearMonthChanged(AjaxRequestTarget target) {
                WorkTimeSummary.this.select(target);
            }
        };
        this.yearMonthTo.setLabelCaption("\u7d42\u4e86\u5e74\u6708");
        this.yearMonthTo.setOutputMarkupId(true);
        this.add(this.yearMonthTo);
        this.summaryView = new DataTableView("summaryView", this.page){

            @Override
            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
            }

            @Override
            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
            }

            @Override
            public void defineSorter(ResultSetProvider resultSetProvider) {
            }

            @Override
            public void onRecordSelected(AjaxRequestTarget target, Record record) {
            }
        };
        this.summaryView.setOutputMarkupId(true);
        this.add(this.summaryView);
        this.labelTotalView = new Label("labelTotalView", Model.of(this.getSentence("\u671f\u9593\u5408\u8a08")));
        this.add(this.labelTotalView);
        this.totalView = new DataTableView("totalView", this.page){

            @Override
            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
            }

            @Override
            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
            }

            @Override
            public void defineSorter(ResultSetProvider resultSetProvider) {
            }

            @Override
            public void onRecordSelected(AjaxRequestTarget target, Record record) {
            }
        };
        this.totalView.setOutputMarkupId(true);
        this.add(this.totalView);
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u52e4\u52d9\u8a18\u9332\u30b5\u30de\u30ea\u30fc");
    }

    private void onEmployeeSelected(AjaxRequestTarget target, Record record) {
        String selectedText = record.getField(this.getSentence("\u5f93\u696d\u8005"));
        this.employeeSelecter.setAutoSelection(false);
        this.employeeSelecter.setSearchText(selectedText);
        this.employeeSelecter.setAutoSelection(true);
        target.add(this.employeeSelecter);
        this.employeeId = record.getField("ID");
        this.select(target);
    }

    private void onCompanySelected(AjaxRequestTarget target, Record record) {
        String selectedText = record.getField(this.getSentence("\u540d\u79f0"));
        this.companySelecter.setAutoSelection(false);
        this.companySelecter.setSearchText(selectedText);
        this.companySelecter.setAutoSelection(true);
        target.add(this.companySelecter);
        int companyId = Integer.valueOf(record.getField("ID"));
        this.employeeSelecter.setOrganizationId(companyId);
        this.select(target);
    }

    private void select(AjaxRequestTarget target) {
        String ymfrom = "%04d-%02d-01";
        ymfrom = String.format(ymfrom, this.yearMonthFrom.getYear(), this.yearMonthFrom.getMonth());
        LocalDate ld = LocalDate.of(this.yearMonthTo.getYear(), this.yearMonthTo.getMonth(), 1);
        ld = ld.plusMonths(1L);
        String ymto = ld.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String eid = this.employeeId;
        if (eid == null) {
            return;
        }
        String cmd = "SELECT left(REC_DATE, 7) \u5e74\u6708, cast(sum(WORK_TIME) as decimal(10, 2)) \u52e4\u52d9\u6642\u9593, cast(sum(OVER_TIME) as decimal(10, 2)) \u6b8b\u696d\u6642\u9593, cast(sum(LATENIGHT_TIME) as decimal(10, 2)) \u6df1\u591c\u6642\u9593,  cast(sum(PAID_HOLIDAY) as decimal(10,2)) \u6709\u4f11, cast(sum(SPECIAL_HOLIDAY) as decimal(10,2)) \u7279\u4f11, cast(sum(HOLIDAY_WORK) as decimal(10,2)) \u4f11\u51fa  FROM WORKTIME_REPORT\n where\n  employee_id = %s and REC_DATE >= '%s' and REC_DATE <'%s' group by \u5e74\u6708\norder by \u5e74\u6708";
        cmd = String.format(cmd, eid, ymfrom, ymto);
        System.out.println(cmd);
        this.summaryView.select(cmd);
        target.add(this.summaryView);
        cmd = "SELECT cast(sum(WORK_TIME) as decimal(10, 2)) \u52e4\u52d9\u6642\u9593, cast(sum(OVER_TIME) as decimal(10, 2)) \u6b8b\u696d\u6642\u9593, cast(sum(LATENIGHT_TIME) as decimal(10, 2)) \u6df1\u591c\u6642\u9593,  cast(sum(PAID_HOLIDAY) as decimal(10,2)) \u6709\u4f11, cast(sum(SPECIAL_HOLIDAY) as decimal(10,2)) \u7279\u4f11, cast(sum(HOLIDAY_WORK) as decimal(10,2)) \u4f11\u51fa  FROM WORKTIME_REPORT\n where\n  employee_id = %s and REC_DATE >= '%s' and REC_DATE <'%s' ";
        cmd = String.format(cmd, eid, ymfrom, ymto);
        System.out.println(cmd);
        this.totalView.select(cmd);
        target.add(this.totalView);
    }
}

