/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard;

import java.time.LocalDate;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.ClearfySession;
import org.clearfy.components.MonthPicker;
import org.clearfy.components.tableview.DataTableView;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.ResultSetProvider;
import org.clearfy.components.tableview.SelectableColumn;
import org.clearfy.plugin.timecard.component.EmployeePicker;
import org.clearfy.plugin.timecard.component.WorkTimeEdit;
import org.clearfy.plugin.timecard.component.WorkTimeSummary;
import org.clearfy.plugin.timecard.component.WorkingReportView;

public class TimeCardEmployeeRecordView
extends ClearfySection {
    private MonthPicker monthPicker;
    private EmployeePicker employeePicker;
    private WorkingReportView workingReportView;
    private DataTableView rawDataView;
    private Label rawDate;
    private WorkTimeSummary workTimeSummary;
    private WorkTimeEdit workTimeEdit;

    public TimeCardEmployeeRecordView(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.monthPicker = new MonthPicker("monthPicker", this.page){

            @Override
            public void onYearMonthChanged(AjaxRequestTarget target) {
                TimeCardEmployeeRecordView.this.workingReportView.setYear(this.getYear());
                TimeCardEmployeeRecordView.this.workingReportView.setMonth(this.getMonth());
                TimeCardEmployeeRecordView.this.workingReportView.drawWorkingReport();
                target.add(TimeCardEmployeeRecordView.this.workingReportView);
                TimeCardEmployeeRecordView.this.workTimeSummary.drawSummary(TimeCardEmployeeRecordView.this.workingReportView.getEmployeeId(), this.getYear(), this.getMonth());
                target.add(TimeCardEmployeeRecordView.this.workTimeSummary);
            }
        };
        this.monthPicker.setOutputMarkupId(true);
        this.add(this.monthPicker);
        this.employeePicker = new EmployeePicker("employeePicker", this.page){

            @Override
            public void onEmployeePickerSelected(AjaxRequestTarget target, EmployeePicker.EmployeeInfo info) {
                TimeCardEmployeeRecordView.this.loadTimeRecords(info);
                TimeCardEmployeeRecordView.this.rawDataView.clear();
                target.add(TimeCardEmployeeRecordView.this.rawDataView);
                TimeCardEmployeeRecordView.this.rawDate.setDefaultModelObject("");
                target.add(TimeCardEmployeeRecordView.this.rawDate);
                TimeCardEmployeeRecordView.this.workingReportView.setYear(TimeCardEmployeeRecordView.this.monthPicker.getYear());
                TimeCardEmployeeRecordView.this.workingReportView.setMonth(TimeCardEmployeeRecordView.this.monthPicker.getMonth());
                TimeCardEmployeeRecordView.this.workingReportView.setEmployeeId(info.getEmployeeId());
                TimeCardEmployeeRecordView.this.workingReportView.drawWorkingReport();
                target.add(TimeCardEmployeeRecordView.this.workingReportView);
                TimeCardEmployeeRecordView.this.workTimeSummary.drawSummary(TimeCardEmployeeRecordView.this.workingReportView.getEmployeeId(), TimeCardEmployeeRecordView.this.workingReportView.getYear(), TimeCardEmployeeRecordView.this.workingReportView.getMonth());
                target.add(TimeCardEmployeeRecordView.this.workTimeSummary);
            }
        };
        this.employeePicker.setOutputMarkupId(true);
        this.add(this.employeePicker);
        this.rawDate = new Label("rawDate", Model.of(""));
        this.rawDate.setOutputMarkupId(true);
        this.add(this.rawDate);
        this.workTimeEdit = new WorkTimeEdit("workTimeEdit", this.page){

            @Override
            public void afterUpdated(AjaxRequestTarget target) {
                TimeCardEmployeeRecordView.this.workingReportView.drawWorkingReport();
                target.add(TimeCardEmployeeRecordView.this.workingReportView);
                TimeCardEmployeeRecordView.this.workTimeSummary.drawSummary(TimeCardEmployeeRecordView.this.workingReportView.getEmployeeId(), TimeCardEmployeeRecordView.this.workingReportView.getYear(), TimeCardEmployeeRecordView.this.workingReportView.getMonth());
                target.add(TimeCardEmployeeRecordView.this.workTimeSummary);
            }
        };
        this.workTimeEdit.setOutputMarkupId(true);
        this.add(this.workTimeEdit);
        this.workingReportView = new WorkingReportView("workingReportView", this.page){

            @Override
            public void onRowClicked(AjaxRequestTarget target, Record row) {
                int date = Integer.parseInt(row.getField("\u65e5\u4ed8"));
                int year = this.getYear();
                int month = this.getMonth();
                LocalDate selectedDate = LocalDate.of(year, month, date);
                TimeCardEmployeeRecordView.this.rawDate.setDefaultModelObject(selectedDate.toString());
                target.add(TimeCardEmployeeRecordView.this.rawDate);
                TimeCardEmployeeRecordView.this.rawDataView.clear();
                String cmd = "select TIME_RECORD_ID ID, RECORD_DATETIME \u6253\u523b\u6642\u523b, ORGANIZATION_NAME \u5834\u6240, \ncase WHEN EMPLOYEE_NAME is not null then EMPLOYEE_NAME else '' END \u627f\u8a8d\u8005 from TIME_RECORD TR\ninner join ORGANIZATION O on O.ORGANIZATION_ID = TR.ORGANIZATION_ID\nleft join EMPLOYEE on EMPLOYEE.EMPLOYEE_ID = MODIFIER_ID\n where TR.EMPLOYEE_ID = %d and CHECK_DATE = '%s' and TR.DISABLE = 0 order by RECORD_DATETIME";
                cmd = String.format(cmd, this.getEmployeeId(), selectedDate.toString());
                TimeCardEmployeeRecordView.this.rawDataView.select(cmd);
                target.add(TimeCardEmployeeRecordView.this.rawDataView);
                TimeCardEmployeeRecordView.this.workTimeEdit.clear();
                TimeCardEmployeeRecordView.this.workTimeEdit.setSelectedDate(selectedDate);
                TimeCardEmployeeRecordView.this.workTimeEdit.setEmployeeId(this.getEmployeeId());
                target.add(TimeCardEmployeeRecordView.this.workTimeEdit);
            }
        };
        this.workingReportView.setOutputMarkupId(true);
        this.add(this.workingReportView);
        this.rawDataView = new DataTableView("rawDataView", this.page){

            @Override
            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
            }

            @Override
            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
                SelectableColumn controller = new SelectableColumn(new Model<String>(this.getSentence("")), "\u9078\u629e", TimeCardEmployeeRecordView.this.rawDataView){

                    @Override
                    public void onSelected(AjaxRequestTarget target, Record selected) {
                        this.onRecordSelected(target, selected);
                    }
                };
                columns.add(controller);
            }

            @Override
            public void defineSorter(ResultSetProvider resultSetProvider) {
            }

            @Override
            public void initializeMenu() {
            }

            @Override
            public void onRecordSelected(AjaxRequestTarget target, Record record) {
                String id = record.getField("ID");
                TimeCardEmployeeRecordView.this.clickRawData(target, Integer.valueOf(id));
            }
        };
        this.rawDataView.setOutputMarkupId(true);
        this.add(this.rawDataView);
        this.workTimeSummary = new WorkTimeSummary("workTimeSummary", this.page);
        this.workTimeSummary.setOutputMarkupId(true);
        this.add(this.workTimeSummary);
        if (((ClearfySession)this.getSession()).getRoles().hasRole("USER") || ((ClearfySession)this.getSession()).getRoles().hasRole("MANAGEMENT_USER")) {
            String userId = ((ClearfySession)this.getSession()).getUserId();
            String empId = this.employeePicker.getEmployeeIdByUserId(userId);
            this.workingReportView.setEmployeeId(Integer.parseInt(empId));
            this.workingReportView.drawWorkingReport();
            int year = this.monthPicker.getYear();
            int month = this.monthPicker.getMonth();
            this.workTimeSummary.drawSummary(Integer.parseInt(empId), year, month);
        }
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u51fa\u52e4\u7c3f");
    }

    public void loadTimeRecords(EmployeePicker.EmployeeInfo info) {
        System.out.println(info.toString());
    }

    public void clickRawData(AjaxRequestTarget target, int id) {
        this.workTimeEdit.setSelectedId(id);
        target.add(this.workTimeEdit);
    }
}

