/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.clearfy.admin.organization.data.Organization;
import org.clearfy.admin.organization.data.OrganizationUserLink;
import org.clearfy.admin.users.data.User;
import org.clearfy.admin.users.data.UserAuth;
import org.clearfy.admin.users.data.UserAuthLink;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.Condition;
import org.clearfy.json.Request;
import org.clearfy.json.RequestParameters;

public class SmartCardRequest
extends Request {
    public static final String REQUEST_METHOD = "method";
    public static final String REQUEST_METHOD_ISEXIST = "isexist";
    public static final String REQUEST_METHOD_RECORD = "record";
    public static final String REQUEST_METHOD_GET_RECORD = "getrecord";
    public static final String REQUEST_METHOD_GET_ORGINFO = "getorginfo";
    public static final String REQUEST_METHOD_GET_ORGLIST = "getorglist";
    public static final String REQUEST_METHOD_TOUCH = "touch";
    public static final String REQUEST_METHOD_APPEND = "append";
    public static final String REQUEST_METHOD_REMOVE = "remove";
    public static final String REQUEST_METHOD_OVERWRITE = "overwrite";
    public static final String REQUEST_PARAM_APIKEY = "apikey";
    public static final String REQUEST_PARAM_CARD_ID = "cardid";
    public static final String REQUEST_PARAM_ORG_ID = "orgid";
    public static final String REQUEST_PARAM_AUTHOR_ID = "authorid";
    public static final String REQUEST_PARAM_PERIOD = "period";
    public static final String REQUEST_PARAM_FROM = "from";
    public static final String REQUEST_PARAM_DATETIME = "datetime";
    public static final String REQUEST_PARAM_TIMERECORD_ID = "timerecordid";
    public static final String REQUEST_PARAM_NEWTIME = "newtime";
    public static final String REQUEST_PARAM_CHECKTYPE = "checktype";
    public static final String REQUEST_PARAM_MESSAGEKEY = "msgkey";
    public static final String REQUEST_DEFINE_DAY = "day";
    public static final String REQUEST_DEFINE_WEEK = "week";
    public static final String REQUEST_DEFINE_MONTH = "month";
    public static final String REQUEST_DEFINE_TAIKIN = "3";

    public SmartCardRequest(PageParameters parameters) {
        super(parameters);
    }

    @Override
    public void onRecieved(RequestParameters requestParams) {
        String method = requestParams.get(REQUEST_METHOD).getValue();
        String apiKey = requestParams.get(REQUEST_PARAM_APIKEY).getValue();
        String cardid = requestParams.get(REQUEST_PARAM_CARD_ID).getValue();
        String orgid = "";
        String authId = "";
        String timerecordId = "";
        String newTime = "";
        switch (method) {
            case "touch": {
                this.touch();
                break;
            }
            case "isexist": {
                if (cardid == null) {
                    this.putJson(this.getErrorMessage("Invalid CARD_ID"));
                    return;
                }
                this.returnIsExist(cardid);
                break;
            }
            case "record": {
                if (cardid == null) {
                    this.putJson(this.getErrorMessage("Invalid CARD_ID"));
                    return;
                }
                String orgId = requestParams.get(REQUEST_PARAM_ORG_ID).getValue();
                if (orgId == null) {
                    this.putJson(this.getErrorMessage("Invalid orgid"));
                    return;
                }
                String recordtime = requestParams.get(REQUEST_PARAM_DATETIME).getValue();
                String checkType = requestParams.get(REQUEST_PARAM_CHECKTYPE).getValue();
                String messageKey = "";
                if (requestParams.indexOf(REQUEST_PARAM_MESSAGEKEY) > -1) {
                    messageKey = requestParams.get(REQUEST_PARAM_MESSAGEKEY).getValue();
                }
                this.recordTime(cardid, orgId, recordtime, checkType, messageKey);
                break;
            }
            case "getrecord": {
                if (cardid == null) {
                    this.putJson(this.getErrorMessage("Invalid CARD_ID"));
                    return;
                }
                String period = requestParams.get(REQUEST_PARAM_PERIOD).getValue();
                String from = requestParams.get(REQUEST_PARAM_FROM).getValue();
                this.getRecord(cardid, period, from);
                break;
            }
            case "getorginfo": {
                orgid = requestParams.get(REQUEST_PARAM_ORG_ID).getValue();
                this.getOrgInfo(orgid);
                break;
            }
            case "getorglist": {
                this.getOrgList(apiKey);
                break;
            }
            case "append": {
                orgid = requestParams.get(REQUEST_PARAM_ORG_ID).getValue();
                authId = requestParams.get(REQUEST_PARAM_AUTHOR_ID).getValue();
                newTime = requestParams.get(REQUEST_PARAM_NEWTIME).getValue();
                this.modifyAppend(cardid, authId, orgid, newTime);
                break;
            }
            case "remove": {
                authId = requestParams.get(REQUEST_PARAM_AUTHOR_ID).getValue();
                timerecordId = requestParams.get(REQUEST_PARAM_TIMERECORD_ID).getValue();
                this.modifyRemove(timerecordId, authId);
                break;
            }
            case "overwrite": {
                authId = requestParams.get(REQUEST_PARAM_AUTHOR_ID).getValue();
                timerecordId = requestParams.get(REQUEST_PARAM_TIMERECORD_ID).getValue();
                orgid = requestParams.get(REQUEST_PARAM_ORG_ID).getValue();
                newTime = requestParams.get(REQUEST_PARAM_NEWTIME).getValue();
                this.modifyOverwrite(timerecordId, authId, orgid, newTime);
            }
        }
    }

    public void modifyOverwrite(String timeRecordId, String authId, String orgId, String newTime) {
        try {
            int iAuthId = -1;
            ResultSet rs = this.getEmpoyeeInfo(authId);
            if (rs.next()) {
                iAuthId = rs.getInt("EMPLOYEE_ID");
            }
            rs.close();
            if (iAuthId != -1) {
                String cmd = "update TIME_RECORD set MODIFIED = 1, MODIFIER_ID = %s,  ORGANIZATION_ID = %s, RECORD_DATETIME = '%s', MDATE = CURRENT_TIMESTAMP , STATUS = 1  where TIME_RECORD_ID = %s ";
                cmd = String.format(cmd, iAuthId, orgId, newTime, timeRecordId);
                this.getJdbc().execute(cmd);
                String jvalue = "{\"STATUS\":\"SUCCESS\"}";
                this.putJson(jvalue);
            } else {
                String jvalue = "{\"STATUS\":\"FAILED\"}";
                this.putJson(jvalue);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void modifyRemove(String timeRecordId, String authorId) {
        try {
            int iAuthorId = -1;
            ResultSet rs = this.getEmpoyeeInfo(authorId);
            if (rs.next()) {
                iAuthorId = rs.getInt("EMPLOYEE_ID");
            }
            rs.close();
            if (iAuthorId != -1) {
                String cmd = "update TIME_RECORD set DISABLE = 1, MODIFIED = 1,  MODIFIER_ID = %d , MDATE=CURRENT_TIMESTAMP , STATUS = 1 where TIME_RECORD_ID = %s ";
                cmd = String.format(cmd, iAuthorId, timeRecordId);
                this.getJdbc().execute(cmd);
                String jvalue = "{\"STATUS\":\"SUCCESS\"}";
                this.putJson(jvalue);
            } else {
                String jvalue = "{\"STATUS\":\"FAILED\"}";
                this.putJson(jvalue);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void modifyAppend(String cardId, String szAuthorId, String orgId, String newDateTime) {
        try {
            int employeeId = -1;
            int authorId = -1;
            ResultSet rs = this.getEmpoyeeInfo(cardId);
            if (rs.next()) {
                employeeId = rs.getInt("EMPLOYEE_ID");
            }
            rs.close();
            rs = this.getEmpoyeeInfo(szAuthorId);
            if (rs.next()) {
                authorId = rs.getInt("EMPLOYEE_ID");
            }
            if (employeeId != -1 && authorId != -1) {
                String cmd = "Insert into TIME_RECORD (EMPLOYEE_ID, CHECK_DATE, ORGANIZATION_ID, RECORD_DATETIME, MODIFIED, MODIFIER_ID) values(%d, '%s', %s, '%s', 1, %d)";
                cmd = String.format(cmd, employeeId, newDateTime.substring(0, 10), orgId, newDateTime, authorId);
                this.getJdbc().execute(cmd);
                String putValue = "{\"STATUS\":\"SUCCESS\"}";
                this.putJson(putValue);
            } else {
                String errValue = "{\"STATUS\":\"FAILED\"}";
                this.putJson(errValue);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void getOrgList(String apiKey) {
        int orgId = -1;
        int usrId = -1;
        User user = new User();
        OrganizationUserLink organizationUserLink = new OrganizationUserLink();
        user.setJdbcSupplier(this);
        user.unselectAllColumn();
        ResultSet rs = user.select(user.UserApikey.sameValueOf(apiKey), user.UserId.setSelectable(true), organizationUserLink.OrganizationId.setSelectable(true));
        try {
            if (rs.next()) {
                orgId = organizationUserLink.OrganizationId.of(rs);
                usrId = (Integer)user.UserId.of(rs);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (orgId == -1) {
            this.putJson(this.getErrorMessage(this.getString("API\u30ad\u30fc\u6240\u6709\u8005\u304c\u7d44\u7e54\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002")));
            return;
        }
        String auth = "MANAGEMENT_USER";
        UserAuth userAuth = new UserAuth();
        UserAuthLink userAuthLink = new UserAuthLink();
        userAuth.setJdbcSupplier(this);
        userAuth.unselectAllColumn();
        rs = userAuth.select(userAuthLink.UserId.sameValueOf(String.valueOf(usrId)), userAuth.AuthType.setSelectable(true));
        try {
            if (rs.next()) {
                auth = rs.getString(userAuth.AuthType.getName());
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
        Organization organization = new Organization();
        organization.setJdbcSupplier(this);
        organization.unselectAllColumn();
        organization.OrganizationId.setSelectable(true);
        organization.OrganizationName.setSelectable(true);
        String cmd = "";
        try {
            cmd = auth.equals("ADMIN") ? organization.getSelectSentence(new Condition[0]) : organization.getSelectSentence(organization.ParentId.sameValueOf(String.valueOf(orgId)));
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
        rs = this.getJdbc().select(cmd);
        String jsonData = "{\"STATUS\":\"SUCCESS\",\"RESULT\":[%s]}";
        String lines = "";
        try {
            while (rs.next()) {
                String jsonline = "{\"ORGANIZATION_ID\":\"%d\",\"ORGANIZATION_NAME\":\"%s\"},";
                jsonline = String.format(jsonline, rs.getInt("ORGANIZATION_ID"), rs.getString("ORGANIZATION_NAME"));
                lines = lines + jsonline;
            }
            if (lines.length() > 0) {
                lines = lines.substring(0, lines.length() - 1);
            }
            jsonData = String.format(jsonData, lines);
            this.putJson(jsonData);
        }
        catch (SQLException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void touch() {
        String rvalue = "{\"STATUS\":\"SUCCESS\",\"RESULT\":\"TOUCHED\"}";
        this.putJson(rvalue);
    }

    public void getOrgInfo(String orgId) {
        String cmd = "select  O.ORGANIZATION_ID,  O.ORGANIZATION_NAME, O.PARENT_ID,  P.ORGANIZATION_NAME PARENT_NAME,  O.ORGANIZATION_KANA,  O.ZIPCODE,  O.ADDRESS,  O.PHONE,  O.FAX,  O.WEBSITE  FROM ORGANIZATION O  inner join ORGANIZATION P on O.PARENT_ID = P.PARENT_ID  where O.ORGANIZATION_ID = %s ";
        cmd = String.format(cmd, orgId);
        ResultSet rs = this.getJdbc().select(cmd);
        try {
            String jsonfmt = "{\n    \"STATUS\":\"SUCCESS\",\n    \"ORGANIZATION_ID\":\"%s\",\n    \"ORGANIZATION_NAME\":\"%s\",\n    \"PARENT_ID\":\"%s\",\n    \"PARENT_NAME\":\"%s\",\n    \"ORGANIZATION_KANA\":\"%s\",\n    \"ZIPCODE\":\"%s\",\n    \"ADDRESS\":\"%s\",\n    \"PHONE\":\"%s\",\n    \"FAX\":\"%s\",\n    \"WEBSITE\":\"%s\"\n}";
            if (rs.next()) {
                jsonfmt = String.format(jsonfmt, rs.getString("ORGANIZATION_ID"), rs.getString("ORGANIZATION_NAME"), rs.getString("PARENT_ID"), rs.getString("PARENT_NAME"), rs.getString("ORGANIZATION_KANA"), rs.getString("ZIPCODE"), rs.getString("ADDRESS"), rs.getString("PHONE"), rs.getString("FAX"), rs.getString("WEBSITE"));
            }
            rs.close();
            this.putJson(jsonfmt);
        }
        catch (SQLException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void getRecord(String cardid, String period, String from) {
        LocalDateTime ldtFrom = LocalDateTime.parse(from, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime ldtTo = LocalDateTime.parse(from, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        ldtFrom = ldtFrom.withHour(0);
        ldtFrom = ldtFrom.withMinute(0);
        ldtFrom = ldtFrom.withSecond(0);
        ldtFrom = ldtFrom.withNano(0);
        switch (period) {
            case "day": {
                ldtTo = ldtFrom.plusDays(1L);
                break;
            }
            case "week": {
                ldtFrom = ldtFrom.minusDays(ldtFrom.get(ChronoField.DAY_OF_WEEK));
                ldtTo = ldtFrom.plusDays(7L);
                break;
            }
            case "month": {
                ldtFrom = ldtFrom.withDayOfMonth(1);
                ldtTo = ldtFrom.plusMonths(1L);
            }
        }
        String szFrom = ldtFrom.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String szTo = ldtTo.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String cmd = "select  TIME_RECORD_ID, RECORD_DATETIME, EMPLOYEE_NAME, TR.ORGANIZATION_ID, ORGANIZATION_NAME, MODIFIED from TIME_RECORD TR\n inner join EMPLOYEE E on\n E.EMPLOYEE_ID = TR.EMPLOYEE_ID\n inner join ORGANIZATION O on\n TR.ORGANIZATION_ID = O.ORGANIZATION_ID \n where CHECK_DATE >= '%s' and CHECK_DATE < '%s'\n and SCARD_ID = '%s' and TR.DISABLE = 0 \n  order by RECORD_DATETIME ";
        cmd = String.format(cmd, szFrom, szTo, cardid);
        ResultSet rs = this.getJdbc().select(cmd);
        if (rs != null) {
            String jsonFormat = "{\n  \"STATUS\":\"SUCCESS\",\n  \"RESULT\":{\n    \"CARD_ID\":\"%s\",\n    \"EMPLOY_NAME\":\"%s\",\n    \"RECORD_COUNT\":\"%d\",\n    \"RECORD\":[\n    %s\n    ]\n  }\n}";
            String records = "";
            String employeeName = "";
            int reccount = 0;
            try {
                while (rs.next()) {
                    employeeName = rs.getString("EMPLOYEE_NAME");
                    String lineFormat = "{    \"RECORD_ID\":\"%d\",\n    \"RECORD_TIME\":\"%s\",\n    \"ORG_ID\":\"%d\",\n    \"ORG_NAME\":\"%s\",\n    \"MODIFY_CODE\":\"%d\"\n},\n";
                    lineFormat = String.format(lineFormat, rs.getInt("TIME_RECORD_ID"), rs.getString("RECORD_DATETIME"), rs.getInt("ORGANIZATION_ID"), rs.getString("ORGANIZATION_NAME"), rs.getInt("MODIFIED"));
                    records = records + lineFormat;
                    ++reccount;
                }
                if ((records = records.trim()).length() > 1) {
                    records = records.substring(0, records.length() - 1);
                }
                jsonFormat = String.format(jsonFormat, cardid, employeeName, reccount, records);
                this.putJson(jsonFormat);
            }
            catch (SQLException ex) {
                Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.putJson(this.getErrorMessage("Invalid Api result."));
        }
    }

    public void returnIsExist(String cardId) {
        String cmd = " select count(*) rcount from EMPLOYEE where SCARD_ID = '%s'";
        cmd = String.format(cmd, cardId);
        ResultSet rs = this.getJdbc().select(cmd);
        String jsoncode = "";
        try {
            if (rs.next()) {
                int rcount = rs.getInt("rcount");
                rs.close();
                if (rcount > 0) {
                    String ename = "";
                    cmd = "select EMPLOYEE_NAME from EMPLOYEE where SCARD_ID = '%s'";
                    cmd = String.format(cmd, cardId);
                    rs = this.getJdbc().select(cmd);
                    if (rs.next()) {
                        ename = rs.getString("EMPLOYEE_NAME");
                    }
                    jsoncode = "{\"STATUS\":\"SUCCESS\",\"RESULT\":\"EXIST\",\"EMPLOYEE_NAME\":\"%s\" }";
                    jsoncode = String.format(jsoncode, ename);
                } else {
                    jsoncode = "{\"STATUS\":\"SUCCESS\",\"RESULT\":\"NOT_EXIST\"}";
                }
            } else {
                this.putJson(this.getErrorMessage("DATA SELECTION FAILER."));
            }
            this.putJson(jsoncode);
        }
        catch (SQLException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private ResultSet getEmpoyeeInfo(String cardId) {
        String cmd = "select EMPLOYEE_ID, EMPLOYEE_NAME from EMPLOYEE where SCARD_ID = '%s'";
        cmd = String.format(cmd, cardId);
        ResultSet rs = this.getJdbc().select(cmd);
        return rs;
    }

    public void recordTime(String cardId, String orgId, String datetime, String checkType, String messageKey) {
        LocalDateTime now;
        if (checkType == null) {
            checkType = "-1";
        }
        ResultSet rs = this.getEmpoyeeInfo(cardId);
        int id = -1;
        String name = "";
        try {
            if (rs.next()) {
                id = rs.getInt("EMPLOYEE_ID");
                name = rs.getString("EMPLOYEE_NAME");
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (id < 1) {
            this.putJson(this.getErrorMessage("Invalid Employee id"));
            return;
        }
        LocalDateTime checkDay = now = LocalDateTime.parse(datetime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        if (this.isTodayFirstRecord(id, now) && checkType.equals(REQUEST_DEFINE_TAIKIN)) {
            checkDay = checkDay.minusDays(1L);
        }
        String cmd = "insert into TIME_RECORD (EMPLOYEE_ID, ORGANIZATION_ID, CHECK_DATE, RECORD_DATETIME, CHECK_TYPE, MESSAGE_KEY) values (%d, %s, '%s', '%s', %s, '%s')";
        cmd = String.format(cmd, id, orgId, checkDay.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), checkType, messageKey);
        this.getJdbc().execute(cmd);
        String format = "{\"STATUS\":\"SUCCESS\",\"RESULT\":\"RECORDED\",\"EMPLOYEE_NAME\":\"%s\"}";
        format = String.format(format, name);
        this.putJson(format);
    }

    public boolean isTodayFirstRecord(int userId, LocalDateTime targetTime) {
        boolean rvalue = false;
        String cmd = "select count(*) RECCOUNT from TIME_RECORD where EMPLOYEE_ID = %d and CHECK_DATE = '%s' and DISABLE = 0 ";
        cmd = String.format(cmd, userId, targetTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        ResultSet rs = this.getJdbc().select(cmd);
        try {
            if (rs.next()) {
                int rcount = rs.getInt("RECCOUNT");
                if (rcount == 0) {
                    rvalue = true;
                }
                rs.close();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SmartCardRequest.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }
}

