/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.ClearfyApplication;
import org.clearfy.ClearfyPage;
import org.clearfy.InitializerBase;
import org.clearfy.PasswordCripter;
import org.clearfy.admin.organization.data.OrganizationUserLink;
import org.clearfy.index.Index;
import org.clearfy.plugin.timecard.EventRecordView;
import org.clearfy.plugin.timecard.TimeCardEmployeeRecordView;
import org.clearfy.plugin.timecard.TimeCardMain;
import org.clearfy.plugin.timecard.TimeCardManager;
import org.clearfy.plugin.timecard.WorkTimeSummary;
import org.clearfy.plugin.timecard.autojob.LateTimeCalculator;
import org.clearfy.plugin.timecard.autojob.WorkReportEditor;
import org.clearfy.plugin.timecard.autojob.WorkTimeCalculator;
import org.clearfy.plugin.timecard.data.TimeRecord;

public class Initializer
extends InitializerBase {
    public static final int COLUMN_USER_NAME = 0;
    public static final int COLUMN_USER_KANA = 1;
    public static final int COLUMN_SCARD_ID = 2;
    public static final int COLUMN_ORG_ID = 0;
    public static final int COLUMN_ORG_PARENT_ID = 1;
    public static final int COLUMN_ORG_NAME = 2;
    public static final int COLUMN_ORG_KANA = 3;
    public static final int COLUMN_ORG_ZIP = 4;
    public static final int COLUMN_ORG_ADDRESS = 5;
    public static final int COLUMN_ORG_PHONE = 6;
    public static final int COLUMN_ORG_FAX = 7;
    public static final int COLUMN_ORG_MAIL = 8;
    public static final int COLUMN_ORG_WEB = 9;
    public static final int COLUMN_EMP_ORG_ID = 0;
    public static final int COLUMN_EMP_NAME = 1;
    public static final int COLUMN_EMP_KANA = 2;
    public static final int COLUMN_EMP_SCID = 3;
    public static final int COLUMN_EMP_MAIL = 4;
    public static final int COLUMN_EMP_PASS = 5;
    public static final int COLUMN_DAY_OF_WEEK = 1;
    public static final int COLUMN_ENTRY_NUM = 2;
    public static final int COLUMN_START_TIME = 3;
    public static final int COLUMN_END_TIME = 4;

    @Override
    public String getVersion() {
        return "0.0.0";
    }

    @Override
    public void initDb() {
        this.jdbc.execute(this.getCreateOrganizationTable());
        this.jdbc.execute(this.getCreateSqlOrganiztionUserLink());
        this.jdbc.execute(this.getCreateSqlOrgBizHours());
        this.jdbc.execute(this.getCreateSqlEmployee());
        TimeRecord timerecord = new TimeRecord();
        timerecord.alterOrCreateTable(this);
        this.jdbc.execute(this.getCreateSqlWorkTimeReport());
        this.jdbc.execute("truncate table SCHEDULED_JOB");
        WorkReportEditor wre = new WorkReportEditor(this.jdbc);
        wre.ScheduledJobId = 1;
        wre.Cycle = 1;
        wre.Second = 10;
        wre.saveNextSchedule(this.jdbc);
        WorkTimeCalculator wtc = new WorkTimeCalculator(this.jdbc);
        wtc.ScheduledJobId = 2;
        wtc.Cycle = 1;
        wtc.Second = 30;
        wtc.saveNextSchedule(this.jdbc);
        LateTimeCalculator ltc = new LateTimeCalculator(this.jdbc);
        ltc.ScheduledJobId = 3;
        ltc.Cycle = 1;
        ltc.Second = 30;
        ltc.saveNextSchedule(this.jdbc);
    }

    public void insertOrganizaitonData() {
        String srcPath = ((ClearfyApplication)this.clearfyPage.getApplication()).getRealPath("/WEB-INF/var/organization/organization.txt");
        File efile = new File(srcPath);
        if (efile.exists()) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(efile), "UTF-8"));
                ArrayList<String> lines = new ArrayList<String>();
                String line = "";
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                br.close();
                for (String l : lines) {
                    if (l.trim().length() <= 0) continue;
                    String[] cols = l.split("\t");
                    if (cols[3].length() < 1) {
                        cols[3] = cols[2];
                    }
                    String cmd = "merge into ORGANIZATION ( ORGANIZATION_ID,  PARENT_ID, ORGANIZATION_NAME, ORGANIZATION_KANA, ZIPCODE, ADDRESS, PHONE, FAX, MAIL, WEBSITE) values (%s,%s,'%s','%s','%s', '%s', '%s', '%s', '%s', '%s')";
                    String web = "";
                    if (cols.length > 9) {
                        web = cols[9];
                    }
                    cmd = String.format(cmd, cols[0], cols[1], cols[2], cols[3], cols[4], cols[5], cols[6], cols[7], cols[8], web);
                    this.clearfyPage.getJdbc().execute(cmd);
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Initializer.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Initializer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void insertEmployeeData() {
        String srcPath = ((ClearfyApplication)this.clearfyPage.getApplication()).getRealPath("/WEB-INF/var/employee/employee.txt");
        File efile = new File(srcPath);
        if (efile.exists()) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(efile), "UTF-8"));
                ArrayList<String> lines = new ArrayList<String>();
                String line = "";
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                br.close();
                String cmd = "select AUTH_ID from USER_AUTH where AUTH_TYPE = 'USER'";
                ResultSet rs = this.jdbc.select(cmd);
                rs.next();
                int authId = rs.getInt("AUTH_ID");
                rs.close();
                for (String l : lines) {
                    String[] cols = l.split("\t");
                    if (cols[2].length() < 1) {
                        cols[2] = cols[1];
                    }
                    String account = cols[1];
                    String email = cols[4];
                    String pass = cols[5];
                    cmd = "merge into USER (USER_ACCOUNT, USER_EMAIL, USER_PASSKEY, USER_APIKEY) values('%s', '%s', '%s', '%s')";
                    String pwd = PasswordCripter.get(account, pass);
                    String apikey = PasswordCripter.get(account, pwd);
                    cmd = String.format(cmd, account, email, pwd, apikey);
                    this.jdbc.execute(cmd);
                    cmd = "select USER_ID from USER where USER_ACCOUNT = '%s' ";
                    cmd = String.format(cmd, account);
                    rs = this.jdbc.select(cmd);
                    rs.next();
                    int uid = rs.getInt("USER_ID");
                    rs.close();
                    cmd = "merge into USER_AUTH_LINK(USER_ID, AUTH_ID) values (%d,%d)";
                    cmd = String.format(cmd, uid, authId);
                    this.jdbc.execute(cmd);
                    cmd = "merge into EMPLOYEE ( EMPLOYEE_NAME, EMPLOYEE_KANA, SCARD_ID, ORGANIZATION_ID, USER_ID) values ('%s','%s','%s', %s, %d)";
                    cmd = String.format(cmd, cols[1], cols[2], cols[3], cols[0], uid);
                    this.clearfyPage.getJdbc().execute(cmd);
                    cmd = "merge into ORGANIZATION_USER_LINK (ORGANIZATION_ID, USER_ID) values (%s, %s)";
                    cmd = String.format(cmd, cols[0], uid);
                    this.clearfyPage.getJdbc().execute(cmd);
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Initializer.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException | SQLException ex) {
                Logger.getLogger(Initializer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void insertOrgBizHours() {
        String srcPath = ((ClearfyApplication)this.clearfyPage.getApplication()).getRealPath("/WEB-INF/var/organization/orgbizhours.txt");
        File efile = new File(srcPath);
        if (efile.exists()) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(efile), "UTF-8"));
                ArrayList<String> lines = new ArrayList<String>();
                String line = "";
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                br.close();
                for (String l : lines) {
                    if (l.trim().length() <= 0) continue;
                    String[] cols = l.split("\t");
                    String cmd = "merge into ORGANIZATION_BIZ_HOURS ( ORGANIZATION_ID, DAY_OF_WEEK, ENTRY_NUM , START_TIME, END_TIME ) values ('%s','%s','%s','%s','%s')";
                    cmd = String.format(cmd, cols[0], cols[1], cols[2], cols[3], cols[4]);
                    this.clearfyPage.getJdbc().execute(cmd);
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Initializer.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Initializer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public final String getCreateSqlOrgBizHours() {
        String rvalue = " create table if not exists ORGANIZATION_BIZ_HOURS (  ORGANIZATION_ID int not null,   DAY_OF_WEEK int not null,   ENTRY_NUM int not null default 1,   STAMP datetime not null default CURRENT_TIMESTAMP,   MDATE datetime not null default CURRENT_TIMESTAMP, \u3000DISABLE smallint not null default 0,   START_TIME time not null,   END_TIME time not null,   primary key (ORGANIZATION_ID, DAY_OF_WEEK, ENTRY_NUM) )";
        return rvalue;
    }

    public final String getCreateSqlWorkTimeReport() {
        String cmd = "create table if not exists WORKTIME_REPORT ( EMPLOYEE_ID int not null, REC_DATE DATE not null, STAMP DATETIME not null default CURRENT_TIMESTAMP, MDATE DATETIME not null default CURRENT_TIMESTAMP, DISABLE smallint not null default 0,  START_TIME DATETIME not null default '1900-01-01 0:0:0', GOOUT_TIME DATETIME not null default '1900-01-01 0:0:0', RETURN_TIME DATETIME not null default '1900-01-01 0:0:0', END_TIME DATETIME not null default '1900-01-01 0:0:0', WORK_TIME decimal(18,9) not null default 0.0, BREAKE_TIME decimal(18,9) not null default 0.0, OVER_TIME decimal(18,9) not null default 0.0, LATENIGHT_TIME decimal(18,9) not null default 0.0,  DETAIL_INFO varchar(1024), OVERTIME_COMMIT smallint not null default 0, PAID_HOLIDAY decimal(18,9) not null default 0, SPECIAL_HOLIDAY smallint not null default 0, HOLIDAY_WORK smallint not null default 0, STATUS smallint not null default 0, primary key (EMPLOYEE_ID, REC_DATE))";
        return cmd;
    }

    public final String getCreateSqlTimeRecording() {
        String rvalue = "";
        return rvalue;
    }

    public final String getCreateSqlOrganiztionUserLink() {
        String rvalue = new OrganizationUserLink().getCreateSentence();
        return rvalue;
    }

    public final String getCreateSqlOrganizationEmployeeLink() {
        String rvalue = "create table IF NOT EXISTS ORG_EMPLOYEE_LINK ( ORGANIZATION_ID int not null, EMPLOYEE_ID int not null,  STAMP datetime not null default CURRENT_TIMESTAMP,  MDATE datetime not null default CURRENT_TIMESTAMP, DISABLE smallint not null default 0, primary key (ORGANIZATION_ID, EMPLOYEE_ID) )";
        return rvalue;
    }

    public final String getCreateSqlEmployee() {
        String rvalue = "create table if not exists EMPLOYEE( EMPLOYEE_ID int primary key AUTO_INCREMENT,  STAMP datetime not null default CURRENT_TIMESTAMP,  MDATE datetime not null default CURRENT_TIMESTAMP, DISABLE smallint not null default 0, ORGANIZATION_ID int not null default -1, USER_ID int not null default -1,  EMPLOYEE_NAME varchar(128) not null, EMPLOYEE_KANA varchar(128) not null, SCARD_ID varchar(32),  NORMALIZE_TIME smallint not null default 30,  ZIPCODE varchar(16) , ADDRESS varchar(128) , PHONE varchar(16),  EMAIL varchar(128), MEMO varchar(512) )";
        return rvalue;
    }

    public final String getCreateOrganizationTable() {
        String rvalue = "create table if not exists ORGANIZATION (  ORGANIZATION_ID int primary key auto_increment,   STAMP datetime not null default current_timestamp,   MDATE datetime not null default current_timestamp,   DISABLE smallint not null default 0,  PARENT_ID int not null default -1,   ORGANIZATION_NAME varchar(128) not null,   ORGANIZATION_KANA varchar(128) not null,   ZIPCODE varchar(16) not null,   ADDRESS varchar(128) not null,  PHONE varchar(16) not null,   FAX varchar(16),   USER_NAME varchar(128),   MAIL varchar(128),   WEBSITE varchar(256) )";
        return rvalue;
    }

    @Override
    public void mergeInitialData() {
        this.insertOrganizaitonData();
        this.insertOrgBizHours();
        this.insertEmployeeData();
    }

    @Override
    public void registMenus() {
        this.clearfyPage.registMenu("toTimeCard", "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9", 100, "topMenu", ClearfyPage.class, 4, 1, TimeCardManager.class, TimeCardMain.class, true);
        this.clearfyPage.registMenu("000_toTop", "\u30c8\u30c3\u30d7\u306b\u623b\u308b", 100, "subMenu", TimeCardManager.class, 2, 1, Index.class, null);
        this.clearfyPage.registMenu("001_toTimeCardMain", "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9", 100, "subMenu", TimeCardManager.class, 4, 1, TimeCardManager.class, TimeCardMain.class);
        this.clearfyPage.registMenu("004_toEmployeeRecordView", "\u51fa\u52e4\u8a18\u9332\u306e\u8868\u793a", 100, "subMenu", TimeCardManager.class, 4, 1, TimeCardManager.class, TimeCardEmployeeRecordView.class);
        this.clearfyPage.registMenu("005_toWorkTimeSummary", "\u52e4\u52d9\u8a18\u9332\u30b5\u30de\u30ea\u30fc", 100, "subMenu", TimeCardManager.class, 4, 1, TimeCardManager.class, WorkTimeSummary.class);
        this.clearfyPage.registMenu("006_toEventRecordView", "\u30a4\u30d9\u30f3\u30c8\u53c2\u52a0\u8a18\u9332", 100, "subMenu", TimeCardManager.class, 3, 1, TimeCardManager.class, EventRecordView.class);
    }

    @Override
    public void removeDb() {
    }

    @Override
    public void removeMenus() {
    }
}

