/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.clearfy.ClearfyApplication;
import org.clearfy.ClearfyPage;
import org.clearfy.plugin.mail.MailSender;
import org.clearfy.plugin.mail.MailSetting;

public class ErrorPicker
extends ClearfyPage {
    private MailSender mailSender;
    private HashMap<Integer, String> shops;
    private HashMap<Integer, Integer> errorRecord;
    private HashMap<Integer, HashMap<String, String>> employee = new HashMap();
    private int gid;

    public ErrorPicker(PageParameters parameters) {
        super(parameters);
        this.shops = new HashMap();
        this.errorRecord = new HashMap();
        String groupid = parameters.get("groupid").toString();
        if (groupid != null) {
            this.mailSender = new MailSender();
            this.mailSender.loadSmtpSetting((ClearfyApplication)this.getApplication());
            this.gid = Integer.valueOf(groupid);
            this.start();
        }
    }

    private void start() {
        this.loadShop(this.gid);
        this.loadEmployee();
        for (int i = 1; i <= this.employee.size(); ++i) {
            HashMap<String, String> emp = this.employee.get(i);
            System.out.println(emp.get("EMPLOYEE_NAME"));
            String employeeName = emp.get("EMPLOYEE_NAME");
            String employeeEmail = emp.get("EMAIL");
            int errCount = this.getErrorCount(i);
            System.out.println(errCount);
            if (errCount <= 0) continue;
            String ldate = LocalDate.now().minusDays(1L).toString();
            String cmd = "SELECT DISTINCT WR.* FROM WORKTIME_REPORT  WR\ninner join (\n  SELECT * FROM TIME_RECORD \n)TR\non WR.EMPLOYEE_ID = TR.EMPLOYEE_ID and WR.REC_DATE = TR.CHECK_DATE\nwhere WR.STATUS = 999 and TR.DISABLE = 0 and WR.REC_DATE <= '%s' and WR.EMPLOYEE_ID = %d order by REC_DATE";
            cmd = String.format(cmd, ldate, i);
            ResultSet rs = ((ClearfyApplication)this.getApplication()).getJdbc().select(cmd);
            String message = employeeName + " \u69d8\u306e\u6253\u523b\u8a18\u9332\u306b\u30a8\u30e9\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u306e\u3067\u3054\u9023\u7d61\u3057\u307e\u3059\u3002\n\u3054\u78ba\u8a8d\u3068\u8a02\u6b63\u3092\u3088\u308d\u3057\u304f\u304a\u9858\u3044\u3057\u307e\u3059\u3002\n\u5bfe\u8c61\u6708\u65e5\u306f\u4ee5\u4e0b\u306e\u901a\u308a\u3067\u3059\u3002\n\n";
            try {
                while (rs.next()) {
                    message = message + rs.getString("REC_DATE") + " .\n";
                }
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(ErrorPicker.class.getName()).log(Level.SEVERE, null, ex);
            }
            message = message + "\n\n\u203b\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306f\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9\u30b7\u30b9\u30c6\u30e0\u3088\u308a\u81ea\u52d5\u914d\u4fe1\u3055\u308c\u3066\u304a\u308a\u307e\u3059\u3002";
            message = message + "\n\u914d\u4fe1\u6642\u523b: " + LocalDateTime.now().toString() + "\n";
            this.sendMail(employeeEmail, message);
            System.out.println("SEND.");
        }
    }

    private void sendMail(String account, String message) {
        MailSetting msetting = new MailSetting();
        msetting.setJdbcSupplier(this);
        MailSender mailer = new MailSender();
        String smtpserver = msetting.getParameter("SMTP_SERVER");
        String szPort = msetting.getParameter("PORT");
        int port = Integer.valueOf(szPort);
        mailer.setSMTPServer(smtpserver, port).setStartTls(true).setAuthenticate(true);
        int timeout = Integer.valueOf(msetting.getParameter("DEFAULT_TIMEOUT"));
        mailer.setTimeout(timeout);
        String domain = msetting.getParameter("DOMAIN");
        String myaccount = msetting.getParameter("SYSTEM_MAIL_SENDER");
        String password = msetting.getParameter("PASSWORD");
        mailer.setMessageId(myaccount, domain);
        mailer.setDebugMode(true);
        mailer.createSession(myaccount, password);
        mailer.setFrom(myaccount).setTo(account).setSubject("\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9\u30c1\u30a7\u30c3\u30af\u7d50\u679c\u306e\u3054\u6848\u5185").setText(message);
        mailer.sendMessage();
    }

    private int getErrorCount(int employeeId) {
        String ldate = LocalDate.now().minusDays(1L).toString();
        String cmd = "SELECT count(*) reccount FROM (\nSelect distinct WR.* from WORKTIME_REPORT  WR\ninner join (\n  SELECT * FROM TIME_RECORD \n)TR\non WR.EMPLOYEE_ID = TR.EMPLOYEE_ID and WR.REC_DATE = TR.CHECK_DATE\n where WR.STATUS = 999 and TR.DISABLE = 0  \n)WR where WR.REC_DATE <= '%s' and WR.EMPLOYEE_ID = %d";
        cmd = String.format(cmd, ldate, employeeId);
        ResultSet rs = ((ClearfyApplication)this.getApplication()).getJdbc().select(cmd);
        int rvalue = 0;
        try {
            rs.next();
            rvalue = rs.getInt("reccount");
        }
        catch (SQLException ex) {
            Logger.getLogger(ErrorPicker.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    private void loadEmployee() {
        String cmd = "select EMPLOYEE_ID, EMPLOYEE_NAME, EMAIL from EMPLOYEE where DISABLE = 0 and ORGANIZATION_ID = %s";
        cmd = String.format(cmd, this.gid);
        ResultSet rs = ((ClearfyApplication)this.getApplication()).getJdbc().select(cmd);
        try {
            while (rs.next()) {
                int employeeId = rs.getInt("EMPLOYEE_ID");
                HashMap<String, String> emp = new HashMap<String, String>();
                emp.put("EMPLOYEE_NAME", rs.getString("EMPLOYEE_NAME"));
                emp.put("EMAIL", rs.getString("EMAIL"));
                this.employee.put(employeeId, emp);
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(ErrorPicker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadShop(int groupid) {
        String cmd = "select ORGANIZATION_ID, ORGANIZATION_NAME from ORGANIZATION where DISABLE = 0 and PARENT_ID = %d and ORGANIZATION_ID <> PARENT_ID ";
        cmd = String.format(cmd, groupid);
        ResultSet rs = ((ClearfyApplication)this.getApplication()).getJdbc().select(cmd);
        try {
            while (rs.next()) {
                int sid = rs.getInt("ORGANIZATION_ID");
                String sname = rs.getString("ORGANIZATION_NAME");
                this.shops.put(sid, sname);
                System.out.println(sid + " " + sname);
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(ErrorPicker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

