/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.scheduler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.datawrapper.Jdbc;
import org.clearfy.plugin.scheduler.Job;

public class JobScheduler
extends Thread {
    Jdbc controller;
    private boolean keepOnLoop = true;
    private ArrayList<Job> que = new ArrayList();

    public JobScheduler(Jdbc controller) {
        this.controller = controller;
    }

    public void stopJobScheduler() {
        this.keepOnLoop = false;
    }

    @Override
    public void run() {
        System.out.println("Job Scheduler Started.");
        while (this.keepOnLoop) {
            this.pickupQue();
            for (Job job : this.que) {
                job.execute();
                job.saveNextSchedule(this.controller);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(JobScheduler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private boolean isExistTable() {
        boolean rvalue = false;
        try {
            ResultSet rs = this.controller.getConnection().getMetaData().getTables(null, null, "SCHEDULED_JOB", new String[]{"TABLE"});
            rvalue = rs.next();
        }
        catch (SQLException ex) {
            Logger.getLogger(JobScheduler.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    private void pickupQue() {
        if (!this.isExistTable()) {
            return;
        }
        this.que.clear();
        String cmd = "select * from SCHEDULED_JOB where NEXT_QUE <=CURRENT_TIMESTAMP and DISABLE = 0";
        cmd = String.format(cmd, new Object[0]);
        ResultSet rs = this.controller.select(cmd);
        try {
            while (rs.next()) {
                Job job = Job.create(rs.getString("JOBCLASS"), this.controller);
                job.capsule(rs);
                this.que.add(job);
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(JobScheduler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

