/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.scheduler;

import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.datawrapper.Jdbc;

public class Job {
    public static final int SPOT_JOB = 0;
    public static final int CYCLE_JOB = 1;
    public int ScheduledJobId;
    public int Disable;
    public int Year;
    public int Month;
    public int Day;
    public int Hour;
    public int Minute;
    public int Second;
    public short Cycle;
    public LocalDateTime NextQue = LocalDateTime.now();
    public String JobClass;
    private Jdbc controller;

    public Job(Jdbc controller) {
        this.controller = controller;
    }

    public void capsule(ResultSet rs) throws SQLException {
        this.ScheduledJobId = rs.getInt("SCHEDULED_JOB_ID");
        this.Disable = rs.getShort("DISABLE");
        this.Year = rs.getInt("YEAR");
        this.Month = rs.getInt("MONTH");
        this.Day = rs.getInt("DAY");
        this.Hour = rs.getInt("HOUR");
        this.Minute = rs.getInt("MINUTE");
        this.Second = rs.getInt("SECOND");
        this.Cycle = rs.getShort("CYCLE");
        Date dt = rs.getDate("NEXT_QUE");
        Time tm = rs.getTime("NEXT_QUE");
        this.NextQue = LocalDateTime.of(dt.toLocalDate(), tm.toLocalTime());
        this.JobClass = rs.getString("JOBCLASS");
    }

    public void saveNextSchedule(Jdbc controller) {
        String cd = "Select count(*) reccount from SCHEDULED_JOB ";
        ResultSet rs = this.getDataController().select(cd);
        int reccount = -1;
        try {
            rs.next();
            reccount = rs.getInt("reccount");
        }
        catch (SQLException ex) {
            Logger.getLogger(Job.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.Cycle == 1) {
            if (this.Year != -1) {
                this.NextQue = this.NextQue.plusYears(this.Year);
            }
            if (this.Month != -1) {
                this.NextQue = this.NextQue.plusMonths(this.Month);
            }
            if (this.Day != -1) {
                this.NextQue = this.NextQue.plusDays(this.Day);
            }
            if (this.Hour != -1) {
                this.NextQue = this.NextQue.plusHours(this.Hour);
            }
            if (this.Minute != -1) {
                this.NextQue = this.NextQue.plusMinutes(this.Minute);
            }
            if (this.Second != -1) {
                this.NextQue = this.NextQue.plusSeconds(this.Second);
            }
        } else {
            this.NextQue = this.NextQue.withYear(2500);
        }
        if (this.ScheduledJobId == 0) {
            this.ScheduledJobId = reccount++;
        }
        String cmd = "merge into SCHEDULED_JOB ( SCHEDULED_JOB_ID, DISABLE, YEAR, MONTH, DAY, HOUR, MINUTE, SECOND, CYCLE, NEXT_QUE,  JOBCLASS) values (%d, %d, %d, %d, %d, %d, %d, %d, %d, '%s', '%s')";
        cmd = String.format(cmd, this.ScheduledJobId, this.Disable, this.Year, this.Month, this.Day, this.Hour, this.Minute, this.Second, this.Cycle, Timestamp.valueOf(this.NextQue).toString(), this.getClass().getName());
        controller.execute(cmd);
    }

    public void execute() {
        System.out.println(LocalDateTime.now().toString());
    }

    public Jdbc getDataController() {
        return this.controller;
    }

    public static Job create(String className, Jdbc controller) {
        Job rvalue = null;
        try {
            rvalue = (Job)Class.forName(className).getConstructor(Jdbc.class).newInstance(controller);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(Job.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }
}

