/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.mail;

import java.io.Serializable;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.plugin.mail.MailSender;
import org.clearfy.plugin.mail.MailSetting;

public class MailSettingEditor
extends ClearfySection {
    private MailSetting mailSetting;
    private Form mailSettingForm;
    private Label labelSmtpServer;
    private TextField txtSmtpServer;
    private TextField txtPortNumber;
    private TextField txtTimeout;
    private CheckBox chkUseSTARTTLS;
    private TextField txtDomain;
    private TextField txtMailAddressForSend;
    private PasswordTextField txtPassword;
    private FeedbackPanel feedbackPanel;
    private AjaxButton btnTestSend;
    private AjaxButton btnSave;

    public MailSettingEditor(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.mailSetting = new MailSetting();
        this.mailSetting.setJdbcSupplier(this.page);
        this.mailSettingForm = new Form("mailSettingForm");
        this.txtSmtpServer = new TextField<String>("txtSmtpServer", (IModel<String>)Model.of(this.mailSetting.getParameter("SMTP_SERVER")));
        this.mailSettingForm.add(this.txtSmtpServer);
        this.txtPortNumber = new TextField<String>("txtPortNumber", (IModel<String>)Model.of(this.mailSetting.getParameter("PORT")));
        this.mailSettingForm.add(this.txtPortNumber);
        this.txtTimeout = new TextField<String>("txtTimeout", (IModel<String>)Model.of(this.mailSetting.getParameter("DEFAULT_TIMEOUT")));
        this.mailSettingForm.add(this.txtTimeout);
        String p = this.mailSetting.getParameter("USE_STARTTLS");
        Boolean useStartTLS = Boolean.valueOf(p);
        this.chkUseSTARTTLS = new CheckBox("chkUseSTARTTLS", (IModel<Boolean>)Model.of(useStartTLS));
        this.mailSettingForm.add(this.chkUseSTARTTLS);
        this.txtDomain = new TextField<String>("txtDomain", (IModel<String>)Model.of(this.mailSetting.getParameter("DOMAIN")));
        this.mailSettingForm.add(this.txtDomain);
        this.txtMailAddressForSend = new TextField<String>("txtMailAddressForSend", (IModel<String>)Model.of(this.mailSetting.getParameter("SYSTEM_MAIL_SENDER")));
        this.mailSettingForm.add(this.txtMailAddressForSend);
        this.txtPassword = new PasswordTextField("txtPassword", (IModel<String>)Model.of(this.mailSetting.getParameter("PASSWORD")));
        this.txtPassword.setDefaultModelObject(Model.of(this.mailSetting.getParameter("PASSWORD")));
        this.mailSettingForm.add(this.txtPassword);
        this.add(this.mailSettingForm);
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.feedbackPanel.setOutputMarkupId(true);
        this.mailSettingForm.add(this.feedbackPanel);
        this.btnTestSend = new AjaxButton("btnTestSend"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                MailSettingEditor.this.onTestSendClicked(target);
            }
        };
        this.mailSettingForm.add(this.btnTestSend);
        this.btnSave = new AjaxButton("btnSave"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                MailSettingEditor.this.btnSaveClicked(target);
            }
        };
        this.mailSettingForm.add(this.btnSave);
    }

    public void btnSaveClicked(AjaxRequestTarget target) {
        this.mailSetting.Key.setValue("SMTP_SERVER");
        this.mailSetting.Value.setValue(this.txtSmtpServer.getModelObject().toString());
        this.mailSetting.merge(this.mailSetting.Key, this.mailSetting.Value);
        this.mailSetting.Key.setValue("PORT");
        this.mailSetting.Value.setValue(this.txtPortNumber.getModelObject().toString());
        this.mailSetting.merge(this.mailSetting.Key, this.mailSetting.Value);
        this.mailSetting.Key.setValue("USE_STARTTLS");
        this.mailSetting.Value.setValue(((Boolean)this.chkUseSTARTTLS.getModelObject()).toString());
        this.mailSetting.merge(this.mailSetting.Key, this.mailSetting.Value);
        this.mailSetting.Key.setValue("DEFAULT_TIMEOUT");
        this.mailSetting.Value.setValue(this.txtTimeout.getModelObject().toString());
        this.mailSetting.merge(this.mailSetting.Key, this.mailSetting.Value);
        this.mailSetting.Key.setValue("DOMAIN");
        this.mailSetting.Value.setValue(this.txtDomain.getModelObject().toString());
        this.mailSetting.merge(this.mailSetting.Key, this.mailSetting.Value);
        this.mailSetting.Key.setValue("SYSTEM_MAIL_SENDER");
        this.mailSetting.Value.setValue(this.txtMailAddressForSend.getModelObject().toString());
        this.mailSetting.merge(this.mailSetting.Key, this.mailSetting.Value);
        this.mailSetting.Key.setValue("PASSWORD");
        this.mailSetting.Value.setValue((String)this.txtPassword.getModelObject());
        this.mailSetting.merge(this.mailSetting.Key, this.mailSetting.Value);
        this.feedbackPanel.info((Serializable)((Object)this.getSentence("\u66f4\u65b0\u3057\u307e\u3057\u305f")));
        target.add(this.feedbackPanel);
    }

    public void onTestSendClicked(AjaxRequestTarget target) {
        int port = Integer.valueOf(this.txtPortNumber.getModelObject().toString());
        int timeout = Integer.valueOf(this.txtTimeout.getModelObject().toString());
        MailSender sender = new MailSender();
        sender.setSMTPServer(this.txtSmtpServer.getModelObject().toString(), port).setStartTls((Boolean)this.chkUseSTARTTLS.getModelObject()).setAuthenticate(true).setTimeout(timeout);
        sender.setMessageId(this.txtMailAddressForSend.getModelObject().toString(), this.txtDomain.getModelObject().toString()).setDebugMode(true);
        sender.createSession(this.txtMailAddressForSend.getModelObject().toString(), (String)this.txtPassword.getModelObject());
        String subject = this.getSentence("\u30e1\u30fc\u30eb\u9001\u4fe1\u306e\u30c6\u30b9\u30c8\u3067\u3059\u3002");
        String text = this.getSentence("\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u53d7\u3051\u53d6\u308b\u3053\u3068\u304c\u3067\u304d\u3066\u3044\u308c\u3070\u3001\u8a2d\u5b9a\u306f\u3046\u307e\u304f\u884c\u3063\u3066\u3044\u307e\u3059\u3002");
        sender.setFrom(this.txtMailAddressForSend.getModelObject().toString()).setTo(this.txtMailAddressForSend.getModelObject().toString());
        sender.setSubject(subject);
        sender.setText(text);
        sender.sendMessage();
        this.feedbackPanel.info((Serializable)((Object)this.getSentence("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u7528\u30a2\u30c9\u30ec\u30b9\u306b\u9001\u308a\u307e\u3057\u305f\u306e\u3067\u3001\u53d7\u4fe1\u3067\u304d\u3066\u3044\u308c\u3070\u30c6\u30b9\u30c8\u6210\u529f\u3067\u3059\u3002")));
        target.add(this.feedbackPanel);
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u30e1\u30fc\u30eb\u8a2d\u5b9a");
    }
}

