/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.mail;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.plugin.mail.MailSetting;
import org.clearfy.plugin.mail.PasswordAuthenticator;

public class MailSender {
    private MimeMessage message;
    private MimeBodyPart messageText;
    private Multipart contents;
    private Properties properties = new Properties();
    private Session session;

    public MailSender() {
        this.messageText = new MimeBodyPart();
        this.contents = new MimeMultipart();
    }

    public MailSender setAuthenticate(boolean authmode) {
        this.properties.setProperty("mail.smtp.auth", String.valueOf(authmode));
        return this;
    }

    public MailSender setDebugMode(boolean debugMode) {
        this.properties.setProperty("mail.debug", String.valueOf(debugMode));
        this.properties.setProperty("mail.smtp.debug", String.valueOf(debugMode));
        return this;
    }

    public MailSender setFrom(String from) {
        try {
            this.message = new MimeMessage(this.session);
            this.message.setFrom(new InternetAddress(from));
            this.message.setSender(new InternetAddress(from));
        }
        catch (MessagingException ex) {
            Logger.getLogger(MailSender.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public MailSender setMessageId(String user, String host) {
        this.properties.setProperty("mail.user", user);
        this.properties.setProperty("mail.host", host);
        return this;
    }

    public MailSender setSMTPServer(String hostUrl, int port) {
        this.properties.setProperty("mail.smtp.host", hostUrl);
        this.properties.setProperty("mail.smtp.port", String.valueOf(port));
        return this;
    }

    public MailSender setStartTls(boolean b) {
        if (b) {
            this.properties.setProperty("mail.smtp.starttls.enable", "true");
        }
        return this;
    }

    public MailSender setSubject(String subject) {
        try {
            this.message.setSubject(subject);
        }
        catch (MessagingException ex) {
            Logger.getLogger(MailSender.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public MailSender setText(String text) {
        try {
            this.messageText.setText(text, "ISO-2022-JP");
            this.contents.addBodyPart(this.messageText);
        }
        catch (MessagingException ex) {
            Logger.getLogger(MailSender.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public MailSender setTimeout(int timeout) {
        this.properties.setProperty("mail.smtp.connectiontimeout", String.valueOf(timeout));
        this.properties.setProperty("mail.smtp.timeout", String.valueOf(timeout));
        return this;
    }

    public MailSender setTo(String to) {
        try {
            this.message.setRecipient(Message.RecipientType.TO, new InternetAddress(to));
        }
        catch (MessagingException ex) {
            Logger.getLogger(MailSender.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public MailSender createSession(String user, String password) {
        PasswordAuthenticator auth = new PasswordAuthenticator(user, password);
        this.session = Session.getDefaultInstance(this.properties, auth);
        return this;
    }

    public void printMessage() {
        try {
            this.message.writeTo(System.out);
        }
        catch (IOException ex) {
            Logger.getLogger(MailSender.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MessagingException ex) {
            Logger.getLogger(MailSender.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void sendMessage() {
        try {
            this.message.setContent(this.contents);
            Transport.send(this.message);
        }
        catch (MessagingException ex) {
            Logger.getLogger(MailSender.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addFile(String filePath) {
        try {
            FileDataSource source = new FileDataSource(filePath);
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setDataHandler(new DataHandler((DataSource)source));
            mbp.setFileName(MimeUtility.encodeWord(source.getName()));
            this.contents.addBodyPart(mbp);
        }
        catch (UnsupportedEncodingException | MessagingException ex) {
            Logger.getLogger(MailSender.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadSmtpSetting(IJdbcSupplier supplier) {
        MailSetting setting = new MailSetting();
        setting.setJdbcSupplier(supplier);
    }
}

