/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.employee;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.components.Selecter;
import org.clearfy.components.tableview.Record;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.plugin.employee.data.Employee;

public abstract class EmployeeSelecter
extends ClearfyContentHolder {
    public static final int INITIAL_ID = -1;
    private Selecter employeeSelecter;
    private int currentOrganizationId = -1;
    private int selectedEmployeeId = -1;
    Employee employee;

    public EmployeeSelecter(String id, ClearfyPage page) {
        super(id, page);
    }

    public void setOrganizationId(int id) {
        this.currentOrganizationId = id;
    }

    public int getSelectedEmployeeId() {
        return this.selectedEmployeeId;
    }

    @Override
    public void drawContent() {
        this.employee = new Employee();
        this.page.bindJdbc(this.employee);
        this.employeeSelecter = new Selecter("employeeSelecter", this.page){

            @Override
            public String getTitle() {
                return this.getSentence("\u5f93\u696d\u8005\u9078\u629e");
            }

            @Override
            public void onSelected(AjaxRequestTarget target, Record record) {
                EmployeeSelecter.this.selectedEmployeeId = Integer.valueOf(record.getField(EmployeeSelecter.this.employee.EmployeeId));
                EmployeeSelecter.this.onEmployeeSelected(target, record);
            }

            @Override
            protected String getSelectSentence() {
                String search = this.getSearchText();
                String rvalue = "";
                try {
                    EmployeeSelecter.this.employee.unselectAllColumn();
                    rvalue = EmployeeSelecter.this.currentOrganizationId == -1 ? EmployeeSelecter.this.employee.getSelectSentence(EmployeeSelecter.this.employee.EmployeeId.setSelectable(true), EmployeeSelecter.this.employee.EmployeeName.like("%" + search + "%").setSelectable(true)) : EmployeeSelecter.this.employee.getSelectSentence(EmployeeSelecter.this.employee.EmployeeId.setSelectable(true), EmployeeSelecter.this.employee.EmployeeName.like("%" + search + "%").setSelectable(true), EmployeeSelecter.this.employee.OrganizationId.sameValueOf(EmployeeSelecter.this.currentOrganizationId));
                }
                catch (ClearfyDatabaseException ex) {
                    Logger.getLogger(EmployeeSelecter.class.getName()).log(Level.SEVERE, null, ex);
                }
                return rvalue;
            }
        };
        this.add(this.employeeSelecter);
    }

    public abstract void onEmployeeSelected(AjaxRequestTarget var1, Record var2);

    public void setAutoSelection(boolean selection) {
        this.employeeSelecter.setAutoSelection(selection);
    }

    public boolean isAutoSelection() {
        return this.employeeSelecter.isAutoSelection();
    }

    public void setSearchText(String searchText) {
        this.employeeSelecter.setSearchText(searchText);
    }

    public String getEmployeeIdByUserId(String uid) {
        String rvalue = "-1";
        this.employee.unselectAllColumn();
        try (ResultSet rs = this.employee.select(this.employee.EmployeeId.setSelectable(true), this.employee.EmployeeName.setSelectable(true), this.employee.UserId.sameValueOf(uid));){
            if (rs.next()) {
                int eId = (Integer)this.employee.EmployeeId.of(rs);
                rvalue = String.valueOf(eId);
                String eName = this.employee.EmployeeName.of(rs);
                this.setSearchText(eName);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(EmployeeSelecter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }
}

