/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.employee;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.components.Selecter;
import org.clearfy.plugin.employee.data.Employee;

public abstract class EmployeePicker
extends ClearfyContentHolder {
    private WebMarkupContainer employeeListViewContainer;
    private TextField<String> searchName;
    private ArrayList<EmployeeInfo> employeeList;
    private ListView<EmployeeInfo> employeeListView;
    private Selecter employeePicker;
    private Employee employee;

    public EmployeePicker(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.employeeList = new ArrayList();
        this.searchName = new TextField<String>("searchName", (IModel<String>)Model.of(""));
        this.searchName.add(new AjaxFormComponentUpdatingBehavior("change"){

            @Override
            protected void onUpdate(AjaxRequestTarget target) {
                EmployeePicker.this.loadEmployeeList(target);
            }
        });
        this.add(this.searchName);
        this.employeeListViewContainer = new WebMarkupContainer("employeeListViewContainer");
        this.employeeListViewContainer.setOutputMarkupId(true);
        this.add(this.employeeListViewContainer);
        this.employeeListView = new ListView<EmployeeInfo>("employeeListView", this.employeeList){

            @Override
            protected void populateItem(ListItem<EmployeeInfo> item) {
                final EmployeeInfo info = item.getModelObject();
                AjaxLink employeeLink = new AjaxLink("employeeLink"){

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        EmployeePicker.this.onEmployeePickerSelected(target, info);
                    }
                };
                item.add(employeeLink);
                String caption = info.getEmployeeName();
                Label ename = new Label("employeeName", Model.of(caption));
                employeeLink.add(ename);
            }
        };
        this.employeeListView.setOutputMarkupId(true);
        this.employeeListViewContainer.add(this.employeeListView);
    }

    @Override
    public String getTitle() {
        return this.getSentence("\u5f93\u696d\u8005\u9078\u629e");
    }

    @Override
    public void initializeMenu() {
    }

    public abstract void onEmployeePickerSelected(AjaxRequestTarget var1, EmployeeInfo var2);

    public void loadEmployeeList(AjaxRequestTarget target) {
        this.employeeList.clear();
        String cmd = "select EMPLOYEE_ID, EMPLOYEE_NAME from EMPLOYEE where EMPLOYEE_NAME like '%%%s%%'";
        cmd = String.format(cmd, this.searchName.getModelObject());
        ResultSet rs = this.getDataController().select(cmd);
        if (rs != null) {
            try {
                while (rs.next()) {
                    EmployeeInfo einfo = new EmployeeInfo();
                    einfo.setEmployeeId(rs.getInt("EMPLOYEE_ID"));
                    einfo.setEmployeeName(rs.getString("EMPLOYEE_NAME"));
                    this.employeeList.add(einfo);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(EmployeePicker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        target.add(this.employeeListViewContainer);
    }

    public String getEmployeeIdByUserId(String uid) {
        String rvalue = "-1";
        String cmd = "Select EMPLOYEE_ID , EMPLOYEE_NAME from EMPLOYEE where USER_ID = %s ";
        cmd = String.format(cmd, uid);
        ResultSet rs = this.getDataController().select(cmd);
        try {
            if (rs.next()) {
                String empId;
                rvalue = empId = rs.getString("EMPLOYEE_ID");
                String empName = rs.getString("EMPLOYEE_NAME");
                this.searchName.setModelObject(empName);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(EmployeePicker.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    public class EmployeeInfo
    implements Serializable {
        int employeeId = -1;
        String employeeName = "";

        public void setEmployeeId(int id) {
            this.employeeId = id;
        }

        public int getEmployeeId() {
            return this.employeeId;
        }

        public void setEmployeeName(String name) {
            this.employeeName = name;
        }

        public String getEmployeeName() {
            return this.employeeName;
        }
    }
}

