/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.description;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfyRoles;
import org.clearfy.ClearfySection;
import org.clearfy.ClearfySession;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.Column;
import org.clearfy.plugin.description.data.DescriptionData;
import wicket.contrib.tinymce4.TinyMceBehavior;
import wicket.contrib.tinymce4.ajax.TinyMceAjaxButton;

public class Description
extends ClearfySection {
    private DescriptionData textData;
    private Label description;
    private AjaxLink editLink;
    private Form editForm;
    private TextField<String> titleEditor;
    private TextArea<String> richTextEditor;
    private TinyMceAjaxButton update;
    private FeedbackPanel feedback;
    private Model<String> titleKey;
    private Model<String> descriptionKey;

    public Description(String id, ClearfyPage page) {
        super(id, page);
    }

    @Override
    public void drawContent() {
        this.setOutputMarkupId(true);
        this.titleKey = new Model();
        this.descriptionKey = new Model();
        this.editLink = new AjaxLink("editLink", Model.of(this.getSentence("\u8aac\u660e\u306e\u7de8\u96c6"))){

            @Override
            public void onClick(AjaxRequestTarget art) {
                Description.this.setEditMode(true);
                art.add(Description.this);
            }
        };
        this.add(this.editLink);
        this.textData = new DescriptionData();
        this.textData.setJdbcSupplier(this.page);
        String myKey = this.page.getPageClass().getSimpleName() + "Description";
        this.descriptionKey.setObject(myKey);
        String descr = "\u8aac\u660e\u306f\u307e\u3060\u66f8\u304b\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        try {
            this.textData.unselectAllColumn();
            ResultSet rs = this.textData.select(this.textData.Value.setSelectable(true), this.textData.TextKey.sameValueOf(myKey));
            if (rs.next()) {
                descr = rs.getString(this.textData.Value.getName());
            } else {
                this.textData.insert(this.textData.Mdate.setValue(Timestamp.valueOf(LocalDateTime.now())), this.textData.TextKey.setValue(myKey), this.textData.Value.setValue(descr));
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(Description.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.description = new Label("description", Model.of(this.getSentence(descr)));
        this.description.setEscapeModelStrings(false);
        this.description.setOutputMarkupId(true);
        this.description.setOutputMarkupPlaceholderTag(true);
        this.add(this.description);
        this.editForm = new Form("editForm");
        this.editForm.setOutputMarkupId(true);
        this.editForm.setOutputMarkupPlaceholderTag(true);
        this.titleEditor = new TextField<String>("titleEditor", (IModel<String>)Model.of(this.getSentence(this.getTitle())));
        this.titleEditor.setDefaultModelObject(this.getSentence(this.getTitle()));
        this.titleEditor.setOutputMarkupId(true);
        this.titleEditor.setOutputMarkupPlaceholderTag(true);
        this.titleEditor.setVisible(false);
        this.editForm.add(this.titleEditor);
        this.update = new TinyMceAjaxButton("update"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                Description.this.updateDescription(target);
            }
        };
        this.update.setDefaultModel(Model.of(this.getSentence("\u66f4\u65b0")));
        this.update.setOutputMarkupId(true);
        this.update.setOutputMarkupPlaceholderTag(true);
        this.update.setVisible(false);
        this.editForm.add(this.update);
        this.richTextEditor = new TextArea<String>("richTextEditor", (IModel<String>)Model.of(descr));
        this.richTextEditor.add(new TinyMceBehavior());
        this.richTextEditor.setOutputMarkupId(true);
        this.richTextEditor.setOutputMarkupPlaceholderTag(true);
        this.richTextEditor.setVisible(false);
        this.editForm.add(this.richTextEditor);
        this.add(this.editForm);
        this.feedback = new FeedbackPanel("feedback");
        this.add(this.feedback);
        ClearfySession session = (ClearfySession)this.getSession();
        ClearfyRoles roles = (ClearfyRoles)session.getRoles();
        if (roles == null) {
            this.editLink.setVisible(false);
        } else if (!roles.hasRole("ADMIN")) {
            this.editLink.setVisible(false);
        }
        this.setEditMode(false);
    }

    public void updateDescription(AjaxRequestTarget target) {
        String descriptionText = (String)this.richTextEditor.getModelObject();
        while (descriptionText.contains("\n")) {
            descriptionText = descriptionText.replace("\n", "");
        }
        while (descriptionText.contains("\r")) {
            descriptionText = descriptionText.replace("\r", "");
        }
        String titleText = (String)this.titleEditor.getModelObject();
        try {
            this.textData.unselectAllColumn();
            this.textData.Mdate.setValue(Column.getCurrentTimestamp());
            this.textData.Value.setValue(descriptionText);
            this.textData.update(this.textData.TextKey.sameValueOf((String)this.descriptionKey.getObject()));
            this.textData.Value.setValue(titleText);
            this.textData.update(this.textData.TextKey.sameValueOf((String)this.titleKey.getObject()));
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(Description.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.description.setDefaultModelObject(descriptionText);
        this.sectionTitle.setDefaultModelObject(titleText);
        this.setEditMode(false);
        target.add(this.description);
        target.add(this.update);
        target.add(this.richTextEditor);
        target.add(this.editForm);
        target.add(this.titleEditor);
        target.add(this.sectionTitle);
    }

    public void setEditMode(boolean mode) {
        if (mode) {
            this.richTextEditor.setVisible(true);
            this.update.setVisible(true);
            this.titleEditor.setVisible(true);
            this.description.setVisible(false);
        } else {
            this.richTextEditor.setVisible(false);
            this.update.setVisible(false);
            this.description.setVisible(true);
            this.titleEditor.setVisible(false);
        }
    }

    @Override
    public String getTitle() {
        if (this.page == null) {
            return "";
        }
        if (this.textData == null) {
            this.textData = new DescriptionData();
        }
        if (this.titleKey == null) {
            this.titleKey = new Model();
        }
        this.textData.setJdbcSupplier(this.page);
        String rvalue = "";
        String titleKey = this.page.getPageClass().getSimpleName() + "DescritpionTitle";
        this.titleKey.setObject(titleKey);
        try (ResultSet rs = this.textData.select(this.textData.Value.setSelectable(true), this.textData.TextKey.sameValueOf(titleKey));){
            if (rs.next()) {
                rvalue = rs.getString(this.textData.Value.getName());
            } else {
                System.out.println("SECTION TITLE: " + titleKey);
                this.textData.insert(this.textData.TextKey.setValue(titleKey), this.textData.Value.setValue(titleKey));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Description.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.getSentence(rvalue);
    }
}

